/*
 * Decompiled with CFR 0.152.
 */
package dev.mariany.storagepot.block.entity;

import dev.mariany.storagepot.block.entity.SPBlockEntities;
import dev.mariany.storagepot.block.entity.StoragePotContents;
import dev.mariany.storagepot.item.component.SPComponents;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8172;
import net.minecraft.class_9323;
import net.minecraft.class_9473;
import org.jetbrains.annotations.Nullable;

public class StoragePotBlockEntity
extends class_2586
implements class_1263 {
    private static final String CONTENTS_NBT = "Contents";
    private static final String WAXED_NBT = "Waxed";
    private static final int EXTRACT_COOLDOWN_TICKS = 3;
    private static final int VANILLA_CHEST_SIZE = 27;
    private class_1799 waxed = class_1799.field_8037;
    private StoragePotContents contents = StoragePotContents.EMPTY;
    private long lastExtractTime;
    public long lastWobbleTime;
    @Nullable
    public class_8172.class_8837 lastWobbleType;

    public StoragePotBlockEntity(class_2338 pos, class_2680 state) {
        this(SPBlockEntities.STORAGE_POT, pos, state);
    }

    public StoragePotBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public boolean canInsert(class_1799 stack) {
        if (!this.waxed.method_7960() && !class_1799.method_31577((class_1799)stack, (class_1799)this.waxed)) {
            return false;
        }
        if (this.contents.isEmpty()) {
            return true;
        }
        if (class_1799.method_31577((class_1799)stack, (class_1799)this.contents.getBaseStack())) {
            return !this.isFull();
        }
        return false;
    }

    public static boolean shouldCancelInteraction(class_1937 world, class_2338 blockPos, class_1799 stack) {
        class_2586 class_25862 = world.method_8321(blockPos);
        if (class_25862 instanceof StoragePotBlockEntity) {
            StoragePotBlockEntity storagePotBlockEntity = (StoragePotBlockEntity)class_25862;
            return storagePotBlockEntity.canInsert(stack);
        }
        return false;
    }

    public StoragePotContents getContents() {
        return this.contents;
    }

    public class_1799 getWaxedItem() {
        return this.waxed;
    }

    public boolean isWaxed() {
        return !this.waxed.method_7960();
    }

    public boolean wax() {
        if (this.contents.isEmpty() || this.isWaxed()) {
            return false;
        }
        this.waxed = this.contents.getBaseStack().method_46651(1);
        this.updateListeners();
        return true;
    }

    public boolean unwax() {
        if (this.isWaxed()) {
            this.waxed = class_1799.field_8037;
            this.updateListeners();
            return true;
        }
        return false;
    }

    public boolean add(@Nullable class_1657 player, class_1799 stack, boolean all) {
        if (this.field_11863 == null || this.field_11863.method_8608()) {
            return false;
        }
        if (this.contents.count() >= this.getCapacity()) {
            return false;
        }
        if (!stack.method_7960() && this.canInsert(stack)) {
            int capacity = this.getCapacity();
            int contentsAmount = this.contents.count();
            int stackCount = stack.method_7947();
            int space = Math.max(0, capacity - contentsAmount);
            int amount = all ? Math.min(space, stackCount) : 1;
            this.contents = new StoragePotContents((class_6880<class_1792>)stack.method_41409(), amount + contentsAmount, stack.method_57380());
            stack.method_60504(amount, (class_1309)player);
            this.updateListeners();
            return amount > 0;
        }
        return false;
    }

    public boolean extract(class_1657 player) {
        if (player.method_37908().method_8608()) {
            return false;
        }
        class_1799 baseStack = this.contents.getBaseStack();
        int contentsAmount = this.contents.count();
        int maxCount = baseStack.method_7914();
        int amount = Math.min(contentsAmount, player.method_5715() ? maxCount : 1);
        this.contents = this.contents.withCount(oldCount -> oldCount - amount);
        class_1799 extracted = baseStack.method_46651(amount);
        this.updateListeners();
        if (!extracted.method_7960()) {
            StoragePotBlockEntity.giveItemStack(player, extracted);
            return true;
        }
        return false;
    }

    private static void giveItemStack(class_1657 player, class_1799 stack) {
        int remainingCount = stack.method_7947();
        int maxStackSize = stack.method_7914();
        while (remainingCount > 0) {
            class_1542 itemEntity;
            int currentSplitCount = Math.min(maxStackSize, remainingCount);
            remainingCount -= currentSplitCount;
            class_1799 splitStack = stack.method_46651(currentSplitCount);
            boolean successfullyInserted = player.method_31548().method_7394(splitStack);
            if (successfullyInserted && splitStack.method_7960()) {
                itemEntity = player.method_7328(stack, false);
                if (itemEntity != null) {
                    itemEntity.method_6987();
                }
                player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15197, class_3419.field_15248, 0.2f, ((player.method_59922().method_43057() - player.method_59922().method_43057()) * 0.7f + 1.0f) * 2.0f);
                continue;
            }
            itemEntity = player.method_7328(splitStack, false);
            if (itemEntity == null) continue;
            itemEntity.method_6975();
            itemEntity.method_48349(player.method_5667());
            itemEntity.method_18799(class_243.field_1353);
        }
    }

    public int getFillPercentage() {
        return class_3532.method_15340((int)(this.contents.count() / this.getCapacity()), (int)0, (int)1);
    }

    public int getCapacity() {
        return 3456;
    }

    public void wobble(class_8172.class_8837 wobbleType) {
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            this.field_11863.method_8427(this.method_11016(), this.method_11010().method_26204(), 1, wobbleType.ordinal());
        }
    }

    public void onChange() {
        this.wobble(class_8172.class_8837.field_46664);
        if (this.field_11863 != null) {
            this.field_11863.method_8396(null, this.field_11867, class_3417.field_46649, class_3419.field_15245, 1.0f, 0.7f + 0.5f * (float)this.getFillPercentage());
            class_1937 class_19372 = this.field_11863;
            if (class_19372 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                serverWorld.method_65096((class_2394)class_2398.field_46763, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 1.2, (double)this.field_11867.method_10260() + 0.5, 7, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public void triggerCooldown() {
        if (this.field_11863 != null) {
            this.lastExtractTime = this.field_11863.method_8510();
        }
    }

    public boolean isOnCooldown() {
        if (this.field_11863 == null) {
            return false;
        }
        return this.field_11863.method_8510() - this.lastExtractTime < 3L;
    }

    public class_2350 getHorizontalFacing() {
        return (class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12481);
    }

    public boolean method_11004(int type, int data) {
        if (this.field_11863 != null && type == 1 && data >= 0 && data < class_8172.class_8837.values().length) {
            this.lastWobbleTime = this.field_11863.method_8510();
            this.lastWobbleType = class_8172.class_8837.values()[data];
            return true;
        }
        return super.method_11004(type, data);
    }

    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        if (!this.contents.isEmpty()) {
            view.method_71468(CONTENTS_NBT, StoragePotContents.CODEC, (Object)this.contents);
        }
        if (!this.waxed.method_7960()) {
            view.method_71468(WAXED_NBT, class_1799.field_24671, (Object)this.waxed);
        }
    }

    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        Optional contents = view.method_71426(CONTENTS_NBT, StoragePotContents.CODEC);
        Optional waxed = view.method_71426(WAXED_NBT, class_1799.field_24671);
        contents.ifPresentOrElse(storagePotContents -> {
            this.contents = storagePotContents;
        }, () -> {
            this.contents = StoragePotContents.EMPTY;
        });
        waxed.ifPresentOrElse(waxedItem -> {
            this.waxed = waxedItem;
        }, () -> {
            this.waxed = class_1799.field_8037;
        });
    }

    protected void method_57567(class_9323.class_9324 builder) {
        super.method_57567(builder);
        if (!this.contents.isEmpty()) {
            builder.method_57840(SPComponents.CONTENTS, (Object)this.contents);
        }
        if (!this.waxed.method_7960()) {
            builder.method_57840(SPComponents.WAXED, (Object)this.waxed);
        }
    }

    protected void method_57568(class_9473 components) {
        super.method_57568(components);
        this.contents = (StoragePotContents)components.method_58695(SPComponents.CONTENTS, (Object)StoragePotContents.EMPTY);
        this.waxed = (class_1799)components.method_58695(SPComponents.WAXED, (Object)class_1799.field_8037);
    }

    private void updateListeners() {
        class_1937 world = this.field_11863;
        if (world != null) {
            this.method_5431();
            world.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        }
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        return this.method_58692(registries);
    }

    public int method_5439() {
        return 1;
    }

    public class_1799 method_5438(int slot) {
        if (slot == 0) {
            return this.contents.toStack(1);
        }
        return class_1799.field_8037;
    }

    public void method_5447(int slot, class_1799 stack) {
        if (class_1799.method_31577((class_1799)stack, (class_1799)this.contents.getBaseStack()) && slot == 0) {
            List<class_1799> items = this.contents.toStacks();
            if (items.isEmpty()) {
                this.contents = StoragePotContents.from(List.of(stack));
            } else {
                int lastStackCount = items.getLast().method_7947();
                int difference = lastStackCount - stack.method_7947();
                this.contents = this.contents.withCount(oldCount -> oldCount - difference);
            }
            this.updateListeners();
        }
    }

    public class_1799 method_5441(int slot) {
        return this.remove(slot, -1);
    }

    public class_1799 method_5434(int slot, int amount) {
        return this.remove(slot, amount);
    }

    private class_1799 remove(int slot, int amount) {
        if (this.getCapacity() > slot) {
            class_1799 baseStack = this.contents.getBaseStack();
            int maxCount = baseStack.method_7914();
            int count = baseStack.method_7947();
            int clampedStack = Math.min(maxCount, count);
            int removeAmount = amount < 0 ? clampedStack : Math.min(amount, clampedStack);
            this.contents = this.contents.withCount(oldCount -> oldCount - removeAmount);
            this.updateListeners();
            return baseStack.method_46651(removeAmount);
        }
        return class_1799.field_8037;
    }

    public void method_5448() {
        this.contents = StoragePotContents.EMPTY;
        this.updateListeners();
    }

    public boolean method_5442() {
        return this.contents.isEmpty();
    }

    public boolean isFull() {
        return this.contents.count() >= this.getCapacity();
    }

    public boolean method_5443(class_1657 player) {
        return class_1263.method_49105((class_2586)this, (class_1657)player);
    }

    public void method_66473(class_2338 pos, class_2680 oldState) {
    }
}

