/*
 * Decompiled with CFR 0.152.
 */
package dev.mariany.storagepot.block.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9326;

public record StoragePotContents(class_6880<class_1792> item, int count, class_9326 components) {
    public static final Codec<StoragePotContents> CODEC = Codec.lazyInitialized(StoragePotContents::createCodec);
    public static final class_9139<class_9129, StoragePotContents> PACKET_CODEC = StoragePotContents.createPacketCodec();
    public static StoragePotContents EMPTY = new StoragePotContents((class_6880<class_1792>)class_1802.field_8162.method_7854().method_41409(), 0, class_9326.field_49588);

    private static Codec<StoragePotContents> createCodec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)class_7923.field_41178.method_40294().fieldOf("id").forGetter(StoragePotContents::item), (App)class_5699.field_33441.fieldOf("count").orElse((Object)1).forGetter(StoragePotContents::count), (App)class_9326.field_49589.optionalFieldOf("components", (Object)class_9326.field_49588).forGetter(StoragePotContents::components)).apply((Applicative)instance, StoragePotContents::new));
    }

    private static class_9139<class_9129, StoragePotContents> createPacketCodec() {
        return class_9139.method_56436((class_9139)class_1792.field_55708, StoragePotContents::item, (class_9139)class_9135.field_48550, StoragePotContents::count, (class_9139)class_9326.field_49590, StoragePotContents::components, StoragePotContents::new);
    }

    public static StoragePotContents from(List<class_1799> stacks) {
        if (stacks.isEmpty()) {
            return EMPTY;
        }
        class_1799 baseStack = stacks.getFirst();
        class_6880 baseItem = baseStack.method_41409();
        class_9326 componentChanges = baseStack.method_57380();
        if (!stacks.stream().allMatch(stack -> stack.method_7909().equals(baseStack.method_7909()))) {
            throw new IllegalArgumentException("Stacks must all be of the same item.");
        }
        if (!stacks.stream().allMatch(stack -> stack.method_57380().equals((Object)componentChanges))) {
            throw new IllegalArgumentException("Stacks must have matching components.");
        }
        int count = 0;
        for (class_1799 stack2 : stacks) {
            count += stack2.method_7947();
        }
        return new StoragePotContents((class_6880<class_1792>)baseItem, count, componentChanges);
    }

    public StoragePotContents withCount(Function<Integer, Integer> callback) {
        return this.withCount(callback.apply(this.count));
    }

    public StoragePotContents withCount(int newCount) {
        if (newCount <= 0) {
            return EMPTY;
        }
        return new StoragePotContents(this.item, newCount, this.components);
    }

    public class_1799 toStack(int count) {
        if (count <= 0) {
            return class_1799.field_8037;
        }
        return new class_1799(this.item, count, this.components);
    }

    public boolean isEmpty() {
        return this.count <= 0 || this.item.comp_349() == class_1802.field_8162;
    }

    public List<class_1799> toStacks() {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        if (!this.isEmpty()) {
            int stackSize;
            class_1799 baseStack = this.toStack(1);
            int maxCountPerStack = baseStack.method_7914();
            for (int remaining = this.count; remaining > 0; remaining -= stackSize) {
                stackSize = Math.min(remaining, maxCountPerStack);
                class_1799 splitStack = this.toStack(stackSize);
                stacks.add(splitStack);
            }
        }
        return stacks;
    }

    public class_1799 getBaseStack() {
        if (this.isEmpty()) {
            return class_1799.field_8037;
        }
        return this.toStacks().getFirst();
    }
}

