/*
 * Decompiled with CFR 0.152.
 */
package dev.mariany.storagepot.client.render.block.entity;

import dev.mariany.storagepot.block.entity.StoragePotBlockEntity;
import dev.mariany.storagepot.block.entity.StoragePotContents;
import dev.mariany.storagepot.client.render.SPTexturedRenderLayers;
import dev.mariany.storagepot.client.render.entity.SPModelLayers;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4730;
import net.minecraft.class_5599;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_8172;
import net.minecraft.class_827;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class StoragePotBlockEntityRenderer
implements class_827<StoragePotBlockEntity> {
    private static final String FRONT = "front";
    private static final String BACK = "back";
    private static final String LEFT = "left";
    private static final String RIGHT = "right";
    private static final String TOP = "top";
    private final class_918 itemRenderer;
    @Nullable
    private final class_327 textRenderer;
    private final class_630 neck;
    private final class_630 front;
    private final class_630 back;
    private final class_630 left;
    private final class_630 right;
    private final class_630 top;
    private final class_630 bottom;

    public StoragePotBlockEntityRenderer(class_5614.class_5615 context) {
        this(context.method_43335(), context.method_32143(), context.method_32142());
    }

    public StoragePotBlockEntityRenderer(class_918 itemRenderer, @Nullable class_327 textRenderer, class_5599 models) {
        class_630 basePart = models.method_32072(SPModelLayers.STORAGE_POT_BASE);
        this.neck = basePart.method_32086("neck");
        this.top = basePart.method_32086(TOP);
        this.bottom = basePart.method_32086("bottom");
        class_630 sidePart = models.method_32072(SPModelLayers.STORAGE_POT_SIDES);
        this.front = sidePart.method_32086(FRONT);
        this.back = sidePart.method_32086(BACK);
        this.left = sidePart.method_32086(LEFT);
        this.right = sidePart.method_32086(RIGHT);
        this.itemRenderer = itemRenderer;
        this.textRenderer = textRenderer;
    }

    public static class_5607 getTopBottomNeckTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        class_5605 dilation = new class_5605(0.2f);
        class_5605 dilation2 = new class_5605(-0.1f);
        modelPartData.method_32117("neck", class_5606.method_32108().method_32101(0, 0).method_32098(4.0f, 17.0f, 4.0f, 8.0f, 3.0f, 8.0f, dilation2).method_32101(0, 5).method_32098(5.0f, 20.0f, 5.0f, 6.0f, 1.0f, 6.0f, dilation), class_5603.method_32091((float)0.0f, (float)37.0f, (float)16.0f, (float)((float)Math.PI), (float)0.0f, (float)0.0f));
        class_5606 modelPartBuilder = class_5606.method_32108().method_32101(-16, 13).method_32097(0.0f, 0.0f, 0.0f, 16.0f, 0.0f, 16.0f);
        modelPartData.method_32117(TOP, modelPartBuilder, class_5603.method_32091((float)0.0f, (float)16.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        modelPartData.method_32117("bottom", modelPartBuilder, class_5603.method_32091((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return class_5607.method_32110((class_5609)modelData, (int)32, (int)32);
    }

    public static class_5607 getSidesTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        class_5606 modelPartBuilder = class_5606.method_32108().method_32101(0, 0).method_49304(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 0.0f, EnumSet.of(class_2350.field_11043));
        modelPartData.method_32117(BACK, modelPartBuilder, class_5603.method_32091((float)16.0f, (float)16.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.PI)));
        modelPartData.method_32117(LEFT, modelPartBuilder, class_5603.method_32091((float)0.0f, (float)16.0f, (float)0.0f, (float)0.0f, (float)-1.5707964f, (float)((float)Math.PI)));
        modelPartData.method_32117(RIGHT, modelPartBuilder, class_5603.method_32091((float)16.0f, (float)16.0f, (float)16.0f, (float)0.0f, (float)1.5707964f, (float)((float)Math.PI)));
        modelPartData.method_32117(FRONT, modelPartBuilder, class_5603.method_32091((float)0.0f, (float)16.0f, (float)16.0f, (float)((float)Math.PI), (float)0.0f, (float)0.0f));
        return class_5607.method_32110((class_5609)modelData, (int)16, (int)16);
    }

    public void render(StoragePotBlockEntity storagePotBlockEntity, float f, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, int overlay, class_243 vec3d) {
        float g;
        matrixStack.method_22903();
        class_2350 direction = storagePotBlockEntity.getHorizontalFacing();
        matrixStack.method_22904(0.5, 0.0, 0.5);
        matrixStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f - direction.method_10144()));
        matrixStack.method_22904(-0.5, 0.0, -0.5);
        class_8172.class_8837 wobbleType = storagePotBlockEntity.lastWobbleType;
        class_1937 world = storagePotBlockEntity.method_10997();
        if (wobbleType != null && world != null && (g = ((float)(world.method_8510() - storagePotBlockEntity.lastWobbleTime) + f) / (float)wobbleType.field_46666) >= 0.0f && g <= 1.0f) {
            if (wobbleType == class_8172.class_8837.field_46664) {
                h = 0.015625f;
                float k = g * ((float)Math.PI * 2);
                float l = -1.5f * (class_3532.method_15362((float)k) + 0.5f) * class_3532.method_15374((float)(k / 2.0f));
                matrixStack.method_49278((Quaternionfc)class_7833.field_40714.rotation(l * h), 0.5f, 0.0f, 0.5f);
                float m = class_3532.method_15374((float)k);
                matrixStack.method_49278((Quaternionfc)class_7833.field_40718.rotation(m * h), 0.5f, 0.0f, 0.5f);
            } else {
                h = class_3532.method_15374((float)(-g * 3.0f * (float)Math.PI)) * 0.125f;
                float k = 1.0f - g;
                matrixStack.method_49278((Quaternionfc)class_7833.field_40716.rotation(h * k), 0.5f, 0.0f, 0.5f);
            }
        }
        StoragePotContents contents = storagePotBlockEntity.getContents();
        class_1799 waxedItem = storagePotBlockEntity.getWaxedItem();
        this.render(matrixStack, vertexConsumerProvider, light, overlay, contents, waxedItem);
        this.renderText(matrixStack, vertexConsumerProvider, light, storagePotBlockEntity);
        matrixStack.method_22909();
    }

    public void render(class_4587 matrixStack, class_4597 vertexConsumers, int light, int overlay, StoragePotContents contents, class_1799 waxedItem) {
        if (!waxedItem.method_7960()) {
            contents = StoragePotContents.from(List.of(waxedItem));
        }
        class_4588 vertexConsumer = SPTexturedRenderLayers.STORAGE_POT_BASE.method_24145(vertexConsumers, class_1921::method_23572);
        this.neck.method_22698(matrixStack, vertexConsumer, light, overlay);
        this.top.method_22698(matrixStack, vertexConsumer, light, overlay);
        this.bottom.method_22698(matrixStack, vertexConsumer, light, overlay);
        this.renderSide(this.back, matrixStack, vertexConsumers, light, overlay);
        this.renderSide(this.left, matrixStack, vertexConsumers, light, overlay);
        this.renderSide(this.right, matrixStack, vertexConsumers, light, overlay);
        this.renderSide(this.front, matrixStack, vertexConsumers, light, overlay, SPTexturedRenderLayers.STORAGE_POT_FRONT);
        this.renderItem(matrixStack, vertexConsumers, overlay, light, contents);
    }

    private void renderSide(class_630 part, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        this.renderSide(part, matrices, vertexConsumers, light, overlay, SPTexturedRenderLayers.STORAGE_POT_SIDE);
    }

    private void renderSide(class_630 part, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, class_4730 textureId) {
        part.method_22698(matrices, textureId.method_24145(vertexConsumers, class_1921::method_23572), light, overlay);
    }

    private void renderItem(class_4587 matrices, class_4597 vertexConsumers, int overlay, int light, StoragePotContents contents) {
        float scale = 0.35f;
        matrices.method_22903();
        matrices.method_46416(0.5f, 0.5f, 1.0f);
        matrices.method_22905(scale, scale, scale);
        matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f));
        this.itemRenderer.method_23178(contents.toStack(1), class_811.field_4319, light, overlay, matrices, vertexConsumers, null, 0);
        matrices.method_22909();
    }

    private void renderText(class_4587 matrices, class_4597 vertexConsumers, int light, StoragePotBlockEntity storagePotBlockEntity) {
        if (this.textRenderer != null) {
            int count = storagePotBlockEntity.getContents().count();
            int color = storagePotBlockEntity.isFull() ? -65536 : -16777216;
            String text = Integer.toString(count);
            if (count > 0) {
                float textWidth = this.textRenderer.method_1727(text);
                float halfWidth = textWidth / 2.0f;
                float textHeight = 20.0f;
                float scale = 0.0075f;
                matrices.method_22903();
                matrices.method_46416(0.5f, 1.0f - scale * ((textHeight - 4.0f) / 2.0f), 1.0f);
                matrices.method_22905(scale, -scale, scale);
                this.textRenderer.method_27522(class_2561.method_30163((String)text), -halfWidth, textHeight, color, false, matrices.method_23760().method_23761(), vertexConsumers, class_327.class_6415.field_33995, 0, light);
                matrices.method_22909();
            }
        }
    }

    public void collectVertices(Set<Vector3f> vertices) {
        class_4587 matrixStack = new class_4587();
        this.neck.method_72152(matrixStack, vertices);
        this.top.method_72152(matrixStack, vertices);
        this.bottom.method_72152(matrixStack, vertices);
    }
}

