/*
 * Decompiled with CFR 0.152.
 */
package com.chaoscraft;

import com.chaoscraft.ExtremeChaos;
import com.chaoscraft.InsaneMechanics;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ChaosEvents {
    private static final Random random = new Random();
    public static boolean chaosEnabled = true;
    public static int chaosLevel = 50;

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player;
        if (!chaosEnabled || !((player = event.getPlayer()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (random.nextInt(100) >= chaosLevel) {
            return;
        }
        ServerLevel level = (ServerLevel)event.getLevel();
        BlockPos pos = event.getPos();
        switch (random.nextInt(25)) {
            case 0: {
                this.chickenExplosion(level, pos, player2);
                break;
            }
            case 1: {
                this.gravityReverse(player2);
                break;
            }
            case 2: {
                this.tntSurprise(level, pos, player2);
                break;
            }
            case 3: {
                this.sonicMode(player2);
                break;
            }
            case 4: {
                this.pigRain(level, pos, player2);
                break;
            }
            case 5: {
                this.randomTeleport(player2);
                break;
            }
            case 6: {
                this.ghostMode(player2);
                break;
            }
            case 7: {
                this.creeperFriend(level, pos, player2);
                break;
            }
            case 8: {
                this.lavaFloor(level, pos, player2);
                break;
            }
            case 9: {
                this.diamondShower(level, pos, player2);
                break;
            }
            case 10: {
                this.zombieArmy(level, pos, player2);
                break;
            }
            case 11: {
                this.blockSwap(level, pos, player2);
                break;
            }
            case 12: {
                this.fireworkParty(level, pos, player2);
                break;
            }
            case 13: {
                this.anvilRain(level, pos, player2);
                break;
            }
            case 14: {
                this.iceAge(level, pos, player2);
                break;
            }
            case 15: {
                this.bedrockTroll(level, pos, player2);
                break;
            }
            case 16: {
                this.entityLaunch(player2);
                break;
            }
            case 17: {
                this.invertControls(player2);
                break;
            }
            case 18: {
                this.giantMode(player2);
                break;
            }
            case 19: {
                this.babyZombieSwarm(level, pos, player2);
                break;
            }
            case 20: {
                InsaneMechanics.realityGlitch(level, player2);
                break;
            }
            case 21: {
                InsaneMechanics.chickenDimension(level, player2);
                break;
            }
            case 22: {
                InsaneMechanics.blockTornado(level, player2);
                break;
            }
            case 23: {
                InsaneMechanics.blockTornado(level, player2);
                break;
            }
            case 24: {
                InsaneMechanics.mirrorDimension(level, player2);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity livingEntity;
        if (!chaosEnabled || !((livingEntity = event.getEntity()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        if (random.nextInt(100) >= chaosLevel / 2) {
            return;
        }
        ServerLevel level = player.m_284548_();
        switch (random.nextInt(8)) {
            case 0: {
                player.m_20256_(player.m_20184_().m_82542_(1.0, 5.0, 1.0));
                player.f_19864_ = true;
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] SUPER JUMP!"));
                break;
            }
            case 1: {
                player.m_20256_(player.m_20184_().m_82542_(1.0, -2.0, 1.0));
                player.f_19864_ = true;
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] Gravity says NO!"));
                break;
            }
            case 2: {
                for (int i = 0; i < 360; i += 30) {
                    double rad = Math.toRadians(i);
                    Chicken c = new Chicken(EntityType.f_20555_, (Level)level);
                    c.m_6034_(player.m_20185_() + Math.cos(rad) * 2.0, player.m_20186_(), player.m_20189_() + Math.sin(rad) * 2.0);
                    c.m_20334_(Math.cos(rad) * 0.5, 0.5, Math.sin(rad) * 0.5);
                    level.m_7967_((Entity)c);
                }
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] CHICKEN CIRCLE!"));
                break;
            }
            case 3: {
                level.m_7731_(player.m_20183_().m_7495_(), Blocks.f_50374_.m_49966_(), 3);
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] Bouncy floor!"));
                break;
            }
            case 4: {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 200, 0));
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] Feather mode!"));
                break;
            }
            case 5: {
                player.m_20334_(random.nextGaussian(), 2.0, random.nextGaussian());
                player.f_19864_ = true;
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] RANDOM YEET!"));
                break;
            }
            case 6: {
                level.m_5594_(null, player.m_20183_(), SoundEvents.f_11922_, SoundSource.HOSTILE, 1.0f, 1.0f);
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] What was that sound?!"));
                break;
            }
            case 7: {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 60, 10));
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] TO SPACE!"));
            }
        }
    }

    @SubscribeEvent
    public void onAttack(AttackEntityEvent event) {
        Player player;
        if (!chaosEnabled || !((player = event.getEntity()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (random.nextInt(100) >= chaosLevel / 2) {
            return;
        }
        ServerLevel level = player2.m_284548_();
        switch (random.nextInt(15)) {
            case 0: {
                player2.m_20256_(player2.m_20154_().m_82490_(-3.0));
                player2.f_19864_ = true;
                player2.m_213846_((Component)Component.m_237113_((String)"[CHAOS] RECOIL!"));
                break;
            }
            case 1: {
                if (event.getTarget() == null) break;
                event.getTarget().m_20334_(0.0, 5.0, 0.0);
                player2.m_213846_((Component)Component.m_237113_((String)"[CHAOS] Enemy launched!"));
                break;
            }
            case 2: {
                for (int i = 0; i < 5; ++i) {
                    PrimedTnt tnt = new PrimedTnt((Level)level, player2.m_20185_(), player2.m_20186_(), player2.m_20189_(), null);
                    tnt.m_32085_(60);
                    tnt.m_20334_(random.nextGaussian() * 0.3, 0.5, random.nextGaussian() * 0.3);
                    level.m_7967_((Entity)tnt);
                }
                player2.m_213846_((Component)Component.m_237113_((String)"[CHAOS] TNT EVERYWHERE!"));
                break;
            }
            case 3: {
                player2.m_21205_().m_41774_(1);
                player2.m_213846_((Component)Component.m_237113_((String)"[CHAOS] Your weapon broke!"));
                break;
            }
            case 4: {
                player2.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 200, 5));
                player2.m_213846_((Component)Component.m_237113_((String)"[CHAOS] HULK MODE!"));
                break;
            }
            case 5: {
                if (event.getTarget() == null) break;
                for (int i = 0; i < 3; ++i) {
                    Zombie z = new Zombie((Level)level);
                    z.m_6034_(event.getTarget().m_20185_(), event.getTarget().m_20186_(), event.getTarget().m_20189_());
                    level.m_7967_((Entity)z);
                }
                player2.m_213846_((Component)Component.m_237113_((String)"[CHAOS] Target called for backup!"));
                break;
            }
            case 6: {
                player2.m_5634_(20.0f);
                player2.m_213846_((Component)Component.m_237113_((String)"[CHAOS] Violence heals you!"));
                break;
            }
            case 7: {
                player2.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 0));
                player2.m_213846_((Component)Component.m_237113_((String)"[CHAOS] Rage blindness!"));
                break;
            }
            case 8: {
                level.m_255391_(null, player2.m_20185_(), player2.m_20186_(), player2.m_20189_(), 2.0f, false, Level.ExplosionInteraction.NONE);
                player2.m_213846_((Component)Component.m_237113_((String)"[CHAOS] Explosive punch!"));
                break;
            }
            case 9: {
                player2.m_6034_(event.getTarget().m_20185_(), event.getTarget().m_20186_(), event.getTarget().m_20189_());
                player2.m_213846_((Component)Component.m_237113_((String)"[CHAOS] Teleport strike!"));
                break;
            }
            case 10: {
                ExtremeChaos.nuke(level, player2.m_20183_(), player2);
                break;
            }
            case 11: {
                ExtremeChaos.mobApocalypse(level, player2.m_20183_(), player2);
                break;
            }
            case 12: {
                ExtremeChaos.superSpeed(player2);
                break;
            }
            case 13: {
                ExtremeChaos.invincibility(player2);
                break;
            }
            case 14: {
                InsaneMechanics.cloneArmy(level, player2);
            }
        }
    }

    @SubscribeEvent
    public void onEat(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity;
        if (!chaosEnabled || !((livingEntity = event.getEntity()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        if (!event.getItem().m_41614_()) {
            return;
        }
        if (random.nextInt(100) >= chaosLevel / 2) {
            return;
        }
        ServerLevel level = player.m_284548_();
        switch (random.nextInt(10)) {
            case 0: {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 100, 2));
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] Food poisoning!"));
                break;
            }
            case 1: {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 600, 4));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 2));
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] SUPER FOOD!"));
                break;
            }
            case 2: {
                player.m_20334_(0.0, 3.0, 0.0);
                player.f_19864_ = true;
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] Explosive digestion!"));
                break;
            }
            case 3: {
                for (int i = 0; i < 10; ++i) {
                    ItemEntity item = new ItemEntity((Level)level, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), new ItemStack((ItemLike)Items.f_42583_));
                    item.m_20334_(random.nextGaussian() * 0.3, 0.5, random.nextGaussian() * 0.3);
                    level.m_7967_((Entity)item);
                }
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] You threw up!"));
                break;
            }
            case 4: {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 400, 5));
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] Sugar rush!"));
                break;
            }
            case 5: {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 300, 0));
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] That tasted weird..."));
                break;
            }
            case 6: {
                player.m_7311_(100);
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] SPICY FOOD!"));
                break;
            }
            case 7: {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 400, 0));
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] Invisible food!"));
                break;
            }
            case 8: {
                Cow cow = new Cow(EntityType.f_20557_, (Level)level);
                cow.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
                level.m_7967_((Entity)cow);
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] You summoned a cow!"));
                break;
            }
            case 9: {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 600, 0));
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] Radioactive food!"));
            }
        }
    }

    @SubscribeEvent
    public void onDamage(LivingDamageEvent event) {
        LivingEntity livingEntity;
        if (!chaosEnabled || !((livingEntity = event.getEntity()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        if (random.nextInt(100) >= chaosLevel / 2) {
            return;
        }
        ServerLevel level = player.m_284548_();
        switch (random.nextInt(8)) {
            case 0: {
                event.setCanceled(true);
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] Damage? What damage?"));
                break;
            }
            case 1: {
                event.setAmount(event.getAmount() * 3.0f);
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] CRITICAL HIT ON YOU!"));
                break;
            }
            case 2: {
                player.m_6021_(player.m_20185_() + (double)random.nextInt(20) - 10.0, player.m_20186_(), player.m_20189_() + (double)random.nextInt(20) - 10.0);
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] Panic teleport!"));
                break;
            }
            case 3: {
                level.m_255391_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), 3.0f, false, Level.ExplosionInteraction.NONE);
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] Pain explosion!"));
                break;
            }
            case 4: {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 100, 4));
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] Rage armor!"));
                break;
            }
            case 5: {
                for (int i = 0; i < 5; ++i) {
                    Wolf wolf = new Wolf(EntityType.f_20499_, (Level)level);
                    wolf.m_6034_(player.m_20185_() + (double)random.nextInt(4) - 2.0, player.m_20186_(), player.m_20189_() + (double)random.nextInt(4) - 2.0);
                    wolf.m_21828_((Player)player);
                    level.m_7967_((Entity)wolf);
                }
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] Wolf pack to the rescue!"));
                break;
            }
            case 6: {
                player.m_5634_(event.getAmount());
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] Pain is gain!"));
                break;
            }
            case 7: {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 200, 10));
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] ADRENALINE RUSH!"));
            }
        }
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        Player player;
        if (!chaosEnabled || !((player = event.getEntity()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (random.nextInt(100) >= chaosLevel / 3) {
            return;
        }
        ServerLevel level = (ServerLevel)player2.m_9236_();
        BlockPos pos = event.getPos();
        switch (random.nextInt(15)) {
            case 0: {
                player2.m_20334_(0.0, 5.0, 0.0);
                player2.f_19864_ = true;
                player2.m_213846_((Component)Component.m_237113_((String)"[CHAOS] TO THE MOON!"));
                break;
            }
            case 1: {
                for (int x = -3; x <= 3; ++x) {
                    for (int z = -3; z <= 3; ++z) {
                        if (!random.nextBoolean()) continue;
                        level.m_7731_(pos.m_7918_(x, 0, z), Blocks.f_50090_.m_49966_(), 3);
                    }
                }
                player2.m_213846_((Component)Component.m_237113_((String)"[CHAOS] DIAMOND FLOOR!"));
                break;
            }
            case 2: {
                for (int i = 0; i < 20; ++i) {
                    Pig pig = new Pig(EntityType.f_20510_, (Level)level);
                    pig.m_6034_((double)pos.m_123341_(), (double)(pos.m_123342_() + 30), (double)pos.m_123343_());
                    pig.m_20334_(random.nextGaussian() * 0.5, 0.0, random.nextGaussian() * 0.5);
                    level.m_7967_((Entity)pig);
                }
                player2.m_213846_((Component)Component.m_237113_((String)"[CHAOS] PIG APOCALYPSE!"));
                break;
            }
            case 3: {
                level.m_8606_(0, 24000, true, true);
                player2.m_213846_((Component)Component.m_237113_((String)"[CHAOS] STORM SUMMONED!"));
                break;
            }
            case 4: {
                level.m_8615_(18000L);
                player2.m_213846_((Component)Component.m_237113_((String)"[CHAOS] Instant night!"));
                break;
            }
            case 5: {
                level.m_8615_(6000L);
                player2.m_213846_((Component)Component.m_237113_((String)"[CHAOS] Instant day!"));
                break;
            }
            case 6: {
                for (int i = 0; i < 10; ++i) {
                    Creeper creeper = new Creeper(EntityType.f_20558_, (Level)level);
                    creeper.m_6034_((double)(pos.m_123341_() + random.nextInt(10) - 5), (double)pos.m_123342_(), (double)(pos.m_123343_() + random.nextInt(10) - 5));
                    level.m_7967_((Entity)creeper);
                }
                player2.m_213846_((Component)Component.m_237113_((String)"[CHAOS] CREEPER PARTY!"));
                break;
            }
            case 7: {
                for (int x = -5; x <= 5; ++x) {
                    for (int y = -5; y <= 5; ++y) {
                        for (int z = -5; z <= 5; ++z) {
                            BlockPos p = pos.m_7918_(x, y, z);
                            if (level.m_8055_(p).m_60734_() != Blocks.f_50069_) continue;
                            level.m_7731_(p, Blocks.f_49995_.m_49966_(), 3);
                        }
                    }
                }
                player2.m_213846_((Component)Component.m_237113_((String)"[CHAOS] MIDAS TOUCH!"));
                break;
            }
            case 8: {
                for (int i = 0; i < 50; ++i) {
                    ItemEntity item = new ItemEntity((Level)level, (double)pos.m_123341_(), (double)(pos.m_123342_() + 10), (double)pos.m_123343_(), new ItemStack((ItemLike)Items.f_42436_));
                    item.m_20334_(random.nextGaussian() * 0.5, 0.0, random.nextGaussian() * 0.5);
                    level.m_7967_((Entity)item);
                }
                player2.m_213846_((Component)Component.m_237113_((String)"[CHAOS] GOLDEN APPLE RAIN!"));
                break;
            }
            case 9: {
                for (int x = -10; x <= 10; ++x) {
                    for (int z = -10; z <= 10; ++z) {
                        BlockPos p = pos.m_7918_(x, -1, z);
                        level.m_7731_(p, Blocks.f_50450_.m_49966_(), 3);
                    }
                }
                player2.m_213846_((Component)Component.m_237113_((String)"[CHAOS] THE FLOOR IS ACTUALLY LAVA!"));
                break;
            }
            case 10: {
                player2.m_150109_().m_36071_();
                player2.m_213846_((Component)Component.m_237113_((String)"[CHAOS] BUTTERFINGERS!"));
                break;
            }
            case 11: {
                for (int i = 0; i < 20; ++i) {
                    FireworkRocketEntity fw = new FireworkRocketEntity((Level)level, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), ItemStack.f_41583_);
                    level.m_7967_((Entity)fw);
                }
                player2.m_213846_((Component)Component.m_237113_((String)"[CHAOS] FIREWORK SHOW!"));
                break;
            }
            case 12: {
                for (int i = 0; i < 100; ++i) {
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123813_, (double)pos.m_123341_() + random.nextGaussian() * 5.0, (double)pos.m_123342_() + random.nextDouble() * 5.0, (double)pos.m_123343_() + random.nextGaussian() * 5.0, 1, 0.0, 0.0, 0.0, 0.0);
                }
                player2.m_213846_((Component)Component.m_237113_((String)"[CHAOS] PARTICLE MADNESS!"));
                break;
            }
            case 13: {
                for (int x = -3; x <= 3; ++x) {
                    for (int z = -3; z <= 3; ++z) {
                        level.m_7731_(pos.m_7918_(x, 0, z), Blocks.f_50077_.m_49966_(), 3);
                    }
                }
                player2.m_213846_((Component)Component.m_237113_((String)"[CHAOS] TNT FIELD!"));
                break;
            }
            case 14: {
                Skeleton skeleton = new Skeleton(EntityType.f_20524_, (Level)level);
                skeleton.m_6034_((double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_());
                skeleton.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
                skeleton.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42472_));
                level.m_7967_((Entity)skeleton);
                player2.m_213846_((Component)Component.m_237113_((String)"[CHAOS] Elite skeleton spawned!"));
            }
        }
    }

    @SubscribeEvent
    public void onExplosion(ExplosionEvent.Detonate event) {
        if (!chaosEnabled) {
            return;
        }
        if (random.nextInt(100) >= chaosLevel) {
            return;
        }
        ServerLevel level = (ServerLevel)event.getLevel();
        Vec3 pos = event.getExplosion().getPosition();
        switch (random.nextInt(5)) {
            case 0: {
                for (int i = 0; i < 30; ++i) {
                    Chicken c = new Chicken(EntityType.f_20555_, (Level)level);
                    c.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
                    c.m_20334_(random.nextGaussian(), random.nextDouble() * 2.0, random.nextGaussian());
                    level.m_7967_((Entity)c);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < 5; ++i) {
                    PrimedTnt tnt = new PrimedTnt((Level)level, pos.f_82479_, pos.f_82480_, pos.f_82481_, null);
                    tnt.m_32085_(20 + random.nextInt(40));
                    tnt.m_20334_(random.nextGaussian() * 0.5, 1.0, random.nextGaussian() * 0.5);
                    level.m_7967_((Entity)tnt);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < 20; ++i) {
                    ItemEntity item = new ItemEntity((Level)level, pos.f_82479_, pos.f_82480_, pos.f_82481_, new ItemStack((ItemLike)(random.nextBoolean() ? Items.f_42415_ : Items.f_42616_)));
                    item.m_20334_(random.nextGaussian() * 0.5, 1.0, random.nextGaussian() * 0.5);
                    level.m_7967_((Entity)item);
                }
                break;
            }
        }
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        if (!chaosEnabled) {
            return;
        }
        Level level = event.getEntity().m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (event.getEntity() instanceof Chicken) {
            return;
        }
        if (random.nextInt(100) >= chaosLevel / 2) {
            return;
        }
        BlockPos pos = event.getEntity().m_20183_();
        switch (random.nextInt(5)) {
            case 0: {
                for (int i = 0; i < 5; ++i) {
                    Chicken c = new Chicken(EntityType.f_20555_, (Level)level2);
                    c.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                    c.m_20334_(random.nextGaussian() * 0.5, 1.0, random.nextGaussian() * 0.5);
                    level2.m_7967_((Entity)c);
                }
                break;
            }
            case 1: {
                level2.m_255391_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 2.0f, false, Level.ExplosionInteraction.NONE);
                break;
            }
            case 2: {
                for (int i = 0; i < 5; ++i) {
                    ItemEntity item = new ItemEntity((Level)level2, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)Items.f_42500_, 16));
                    level2.m_7967_((Entity)item);
                }
                break;
            }
            case 3: {
                Zombie z = new Zombie((Level)level2);
                z.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                z.m_6863_(true);
                level2.m_7967_((Entity)z);
                break;
            }
            case 4: {
                for (int i = 0; i < 20; ++i) {
                    level2.m_8767_((ParticleOptions)ParticleTypes.f_123746_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 1, random.nextGaussian() * 0.5, random.nextDouble(), random.nextGaussian() * 0.5, 0.1);
                }
                break;
            }
        }
    }

    private void chickenExplosion(ServerLevel level, BlockPos pos, ServerPlayer player) {
        for (int i = 0; i < 30; ++i) {
            Chicken chicken = new Chicken(EntityType.f_20555_, (Level)level);
            chicken.m_6034_((double)pos.m_123341_(), (double)(pos.m_123342_() + 2), (double)pos.m_123343_());
            chicken.m_20334_(random.nextGaussian() * 0.8, 1.5, random.nextGaussian() * 0.8);
            level.m_7967_((Entity)chicken);
        }
        level.m_5594_(null, pos, SoundEvents.f_11750_, SoundSource.NEUTRAL, 2.0f, 1.0f);
        player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] MEGA CHICKEN EXPLOSION!"));
    }

    private void gravityReverse(ServerPlayer player) {
        player.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 150, 3));
        player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] Gravity machine broke!"));
    }

    private void tntSurprise(ServerLevel level, BlockPos pos, ServerPlayer player) {
        for (int i = 0; i < 5; ++i) {
            PrimedTnt tnt = new PrimedTnt((Level)level, (double)(pos.m_123341_() + random.nextInt(6) - 3), (double)pos.m_123342_(), (double)(pos.m_123343_() + random.nextInt(6) - 3), null);
            tnt.m_32085_(40 + random.nextInt(40));
            level.m_7967_((Entity)tnt);
        }
        player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] SURPRISE TNT PARTY!"));
    }

    private void sonicMode(ServerPlayer player) {
        player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 400, 15));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 400, 3));
        player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] GOTTA GO FAST!"));
    }

    private void pigRain(ServerLevel level, BlockPos pos, ServerPlayer player) {
        for (int i = 0; i < 15; ++i) {
            Pig pig = new Pig(EntityType.f_20510_, (Level)level);
            pig.m_6034_((double)(pos.m_123341_() + random.nextInt(20) - 10), (double)(pos.m_123342_() + 40), (double)(pos.m_123343_() + random.nextInt(20) - 10));
            level.m_7967_((Entity)pig);
        }
        player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] IT'S RAINING PIGS! HALLELUJAH!"));
    }

    private void randomTeleport(ServerPlayer player) {
        double newX = player.m_20185_() + (double)random.nextInt(200) - 100.0;
        double newZ = player.m_20189_() + (double)random.nextInt(200) - 100.0;
        player.m_6021_(newX, player.m_20186_() + 10.0, newZ);
        player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 100, 0));
        player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] YEET! You're somewhere else now!"));
    }

    private void ghostMode(ServerPlayer player) {
        player.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 400, 0));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 200, 0));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 400, 0));
        player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] You're a spooky ghost now!"));
    }

    private void creeperFriend(ServerLevel level, BlockPos pos, ServerPlayer player) {
        for (int i = 0; i < 5; ++i) {
            Creeper creeper = new Creeper(EntityType.f_20558_, (Level)level);
            creeper.m_6034_((double)(pos.m_123341_() + random.nextInt(4) - 2), (double)pos.m_123342_(), (double)(pos.m_123343_() + random.nextInt(4) - 2));
            level.m_7967_((Entity)creeper);
        }
        player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] Your new friends want a hug!"));
    }

    private void lavaFloor(ServerLevel level, BlockPos pos, ServerPlayer player) {
        for (int x = -5; x <= 5; ++x) {
            for (int z = -5; z <= 5; ++z) {
                BlockPos p = pos.m_7918_(x, -1, z);
                if (!level.m_8055_(p).m_280296_()) continue;
                level.m_7731_(p, Blocks.f_49991_.m_49966_(), 3);
            }
        }
        player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 200, 0));
        player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] THE FLOOR IS LAVA! (you're fireproof tho)"));
    }

    private void diamondShower(ServerLevel level, BlockPos pos, ServerPlayer player) {
        for (int i = 0; i < 30; ++i) {
            ItemEntity item = new ItemEntity((Level)level, (double)pos.m_123341_(), (double)(pos.m_123342_() + 20), (double)pos.m_123343_(), new ItemStack((ItemLike)Items.f_42415_, 1 + random.nextInt(3)));
            item.m_20334_(random.nextGaussian() * 0.5, 0.0, random.nextGaussian() * 0.5);
            level.m_7967_((Entity)item);
        }
        player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] DIAMOND RAIN! QUICK GRAB THEM!"));
    }

    private void zombieArmy(ServerLevel level, BlockPos pos, ServerPlayer player) {
        for (int i = 0; i < 20; ++i) {
            Zombie zombie = new Zombie((Level)level);
            zombie.m_6034_((double)(pos.m_123341_() + random.nextInt(10) - 5), (double)pos.m_123342_(), (double)(pos.m_123343_() + random.nextInt(10) - 5));
            level.m_7967_((Entity)zombie);
        }
        player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] ZOMBIE APOCALYPSE!"));
    }

    private void blockSwap(ServerLevel level, BlockPos pos, ServerPlayer player) {
        BlockState[] blocks = new BlockState[]{Blocks.f_50090_.m_49966_(), Blocks.f_50074_.m_49966_(), Blocks.f_50268_.m_49966_(), Blocks.f_50077_.m_49966_(), Blocks.f_50056_.m_49966_()};
        for (int x = -3; x <= 3; ++x) {
            for (int y = -3; y <= 3; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    BlockPos p = pos.m_7918_(x, y, z);
                    if (level.m_8055_(p).m_60795_()) continue;
                    level.m_7731_(p, blocks[random.nextInt(blocks.length)], 3);
                }
            }
        }
        player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] BLOCK RANDOMIZER!"));
    }

    private void fireworkParty(ServerLevel level, BlockPos pos, ServerPlayer player) {
        for (int i = 0; i < 30; ++i) {
            FireworkRocketEntity fw = new FireworkRocketEntity((Level)level, (double)(pos.m_123341_() + random.nextInt(10) - 5), (double)pos.m_123342_(), (double)(pos.m_123343_() + random.nextInt(10) - 5), ItemStack.f_41583_);
            level.m_7967_((Entity)fw);
        }
        player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] FIREWORK CELEBRATION!"));
    }

    private void anvilRain(ServerLevel level, BlockPos pos, ServerPlayer player) {
        for (int i = 0; i < 10; ++i) {
            FallingBlockEntity anvil = FallingBlockEntity.m_201971_((Level)level, (BlockPos)pos.m_7918_(random.nextInt(10) - 5, 30, random.nextInt(10) - 5), (BlockState)Blocks.f_50322_.m_49966_());
            level.m_7967_((Entity)anvil);
        }
        player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] ANVIL RAIN! RUN!"));
    }

    private void iceAge(ServerLevel level, BlockPos pos, ServerPlayer player) {
        for (int x = -10; x <= 10; ++x) {
            for (int y = -3; y <= 3; ++y) {
                for (int z = -10; z <= 10; ++z) {
                    BlockPos p = pos.m_7918_(x, y, z);
                    BlockState state = level.m_8055_(p);
                    if (state.m_60734_() == Blocks.f_49990_) {
                        level.m_7731_(p, Blocks.f_50126_.m_49966_(), 3);
                        continue;
                    }
                    if (state.m_60734_() == Blocks.f_49991_) {
                        level.m_7731_(p, Blocks.f_50080_.m_49966_(), 3);
                        continue;
                    }
                    if (!state.m_60795_() || random.nextInt(3) != 0) continue;
                    level.m_7731_(p, Blocks.f_50125_.m_49966_(), 3);
                }
            }
        }
        player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 2));
        player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] ICE AGE ACTIVATED!"));
    }

    private void bedrockTroll(ServerLevel level, BlockPos pos, ServerPlayer player) {
        level.m_7731_(pos, Blocks.f_50752_.m_49966_(), 3);
        player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] Oops, that's bedrock now. Good luck!"));
    }

    private void entityLaunch(ServerPlayer player) {
        Vec3 look = player.m_20154_();
        player.m_20256_(look.m_82490_(5.0));
        player.f_19864_ = true;
        player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 100, 0));
        player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] HUMAN CANNONBALL!"));
    }

    private void invertControls(ServerPlayer player) {
        player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 300, 0));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 300, 3));
        player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] Your brain is confused!"));
    }

    private void giantMode(ServerPlayer player) {
        player.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 400, 5));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 400, 0));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 400, 3));
        player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] GIANT MODE! STOMP STOMP!"));
    }

    private void babyZombieSwarm(ServerLevel level, BlockPos pos, ServerPlayer player) {
        for (int i = 0; i < 15; ++i) {
            Zombie zombie = new Zombie((Level)level);
            zombie.m_6863_(true);
            zombie.m_6034_((double)(pos.m_123341_() + random.nextInt(8) - 4), (double)pos.m_123342_(), (double)(pos.m_123343_() + random.nextInt(8) - 4));
            level.m_7967_((Entity)zombie);
        }
        player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] BABY ZOMBIE SWARM! THEY'RE FAST!"));
    }
}

