/*
 * Decompiled with CFR 0.152.
 */
package com.chaoscraft;

import com.chaoscraft.ChaosEvents;
import com.chaoscraft.ChaosKeyBindings;
import java.util.Random;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ChaosScreen
extends Screen {
    private int chaosLevel = ChaosEvents.chaosLevel;
    private boolean chaosEnabled = ChaosEvents.chaosEnabled;
    private final Random random = new Random();
    private int animTick = 0;
    private Button toggleButton;

    public ChaosScreen() {
        super((Component)Component.m_237113_((String)"CHAOS CONTROL"));
    }

    protected void m_7856_() {
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        this.toggleButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)(this.chaosEnabled ? "CHAOS: ON" : "CHAOS: OFF")), button -> {
            ChaosEvents.chaosEnabled = this.chaosEnabled = !this.chaosEnabled;
            button.m_93666_((Component)Component.m_237113_((String)(this.chaosEnabled ? "CHAOS: ON" : "CHAOS: OFF")));
        }).m_252987_(centerX - 100, centerY + 10, 200, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"< LESS"), button -> {
            if (this.chaosLevel > 0) {
                ChaosEvents.chaosLevel = this.chaosLevel = Math.max(0, this.chaosLevel - 10);
            }
        }).m_252987_(centerX - 100, centerY + 40, 95, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"MORE >"), button -> {
            if (this.chaosLevel < 100) {
                ChaosEvents.chaosLevel = this.chaosLevel = Math.min(100, this.chaosLevel + 10);
            }
        }).m_252987_(centerX + 5, centerY + 40, 95, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Mild (25%)"), button -> {
            this.chaosLevel = 25;
            ChaosEvents.chaosLevel = 25;
        }).m_252987_(centerX - 100, centerY + 70, 63, 18).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Medium (50%)"), button -> {
            this.chaosLevel = 50;
            ChaosEvents.chaosLevel = 50;
        }).m_252987_(centerX - 31, centerY + 70, 63, 18).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Extreme (75%)"), button -> {
            this.chaosLevel = 75;
            ChaosEvents.chaosLevel = 75;
        }).m_252987_(centerX + 38, centerY + 70, 62, 18).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"MAXIMUM (100%)"), button -> {
            this.chaosLevel = 100;
            ChaosEvents.chaosLevel = 100;
            ChaosEvents.chaosEnabled = true;
            this.chaosEnabled = true;
            this.toggleButton.m_93666_((Component)Component.m_237113_((String)"CHAOS: ON"));
        }).m_252987_(centerX - 100, centerY + 95, 200, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Disable All"), button -> {
            this.chaosLevel = 0;
            ChaosEvents.chaosLevel = 0;
            ChaosEvents.chaosEnabled = false;
            this.chaosEnabled = false;
            this.toggleButton.m_93666_((Component)Component.m_237113_((String)"CHAOS: OFF"));
        }).m_252987_(centerX - 70, centerY + 125, 140, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Close"), button -> this.m_7379_()).m_252987_(centerX - 50, centerY + 155, 100, 20).m_253136_());
    }

    public void m_86600_() {
        super.m_86600_();
        ++this.animTick;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int bgColor1 = -2147478208;
        int bgColor2 = -2147481056;
        graphics.m_280024_(centerX - 120, centerY - 90, centerX + 120, centerY + 190, bgColor1, bgColor2);
        graphics.m_280509_(centerX - 121, centerY - 91, centerX + 121, centerY - 90, -16750849);
        graphics.m_280509_(centerX - 121, centerY + 190, centerX + 121, centerY + 191, -16750849);
        graphics.m_280509_(centerX - 121, centerY - 90, centerX - 120, centerY + 190, -16750849);
        graphics.m_280509_(centerX + 120, centerY - 90, centerX + 121, centerY + 190, -16750849);
        String title = "CHAOS CONTROL";
        int titleColor = -16724737;
        graphics.m_280137_(this.f_96547_, title, centerX + 1, centerY - 80, 1073768191);
        graphics.m_280137_(this.f_96547_, title, centerX - 1, centerY - 80, 1073768191);
        graphics.m_280137_(this.f_96547_, title, centerX, centerY - 79, 1073768191);
        graphics.m_280137_(this.f_96547_, title, centerX, centerY - 81, 1073768191);
        graphics.m_280137_(this.f_96547_, title, centerX, centerY - 80, titleColor);
        int barWidth = 180;
        int barHeight = 10;
        int barX = centerX - barWidth / 2;
        int barY = centerY - 55;
        graphics.m_280509_(barX - 1, barY - 1, barX + barWidth + 1, barY + barHeight + 1, -16777165);
        graphics.m_280509_(barX, barY, barX + barWidth, barY + barHeight, -16777114);
        int fillWidth = (int)((double)barWidth * ((double)this.chaosLevel / 100.0));
        int barColor = this.getBarColor();
        for (int i = 0; i < fillWidth; ++i) {
            float ratio = (float)i / (float)barWidth;
            int color = this.blendColors(barColor, -16711681, ratio * 0.3f);
            graphics.m_280509_(barX + i, barY, barX + i + 1, barY + barHeight, color);
        }
        String percent = this.chaosLevel + "%";
        graphics.m_280137_(this.f_96547_, percent, centerX, barY + 1, -1);
        String levelText = "Level: " + this.chaosLevel + "%";
        graphics.m_280137_(this.f_96547_, levelText, centerX, barY + 15, -1);
        String desc = this.getDescription();
        int descColor = this.getDescColor();
        graphics.m_280137_(this.f_96547_, desc, centerX, barY + 28, descColor);
        if (this.chaosLevel >= 75) {
            String warning = "! HIGH CHAOS !";
            int warnColor = this.animTick % 20 < 10 ? -65536 : -256;
            graphics.m_280137_(this.f_96547_, warning, centerX, centerY - 70, warnColor);
        }
        graphics.m_280137_(this.f_96547_, "Press K to toggle menu", centerX, centerY + 180, -10066330);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    private String getDescription() {
        if (this.chaosLevel == 0) {
            return "[ Peaceful ]";
        }
        if (this.chaosLevel < 25) {
            return "[ Mild Chaos ]";
        }
        if (this.chaosLevel < 50) {
            return "[ Moderate Chaos ]";
        }
        if (this.chaosLevel < 75) {
            return "[ High Chaos ]";
        }
        if (this.chaosLevel < 100) {
            return "[ Extreme Chaos ]";
        }
        return "[ MAXIMUM CHAOS ]";
    }

    private int getDescColor() {
        if (this.chaosLevel < 25) {
            return -16711936;
        }
        if (this.chaosLevel < 50) {
            return -7799040;
        }
        if (this.chaosLevel < 75) {
            return -256;
        }
        if (this.chaosLevel < 100) {
            return -30720;
        }
        return -65536;
    }

    private int getBarColor() {
        if (this.chaosLevel < 25) {
            return -16711936;
        }
        if (this.chaosLevel < 50) {
            return -7799040;
        }
        if (this.chaosLevel < 75) {
            return -256;
        }
        if (this.chaosLevel < 100) {
            return -30720;
        }
        return -65536;
    }

    private int blendColors(int color1, int color2, float ratio) {
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int r = (int)((float)r1 + (float)(r2 - r1) * ratio);
        int g = (int)((float)g1 + (float)(g2 - g1) * ratio);
        int b = (int)((float)b1 + (float)(b2 - b1) * ratio);
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (ChaosKeyBindings.OPEN_CHAOS_GUI != null && ChaosKeyBindings.OPEN_CHAOS_GUI.m_90832_(keyCode, scanCode)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }
}

