/*
 * Decompiled with CFR 0.152.
 */
package com.chaoscraft;

import com.chaoscraft.ChaosEvents;
import com.chaoscraft.InsaneMechanics;
import com.chaoscraft.PCInteractionManager;
import com.chaoscraft.WorldChaosManager;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ChaosTickHandler {
    private static final Random random = new Random();
    private int tickCounter = 0;
    private int miniTickCounter = 0;
    private static final String[] RANDOM_MESSAGES = new String[]{"[CHAOS] Something is behind you... or not?", "[CHAOS] Your shoelaces are untied!", "[CHAOS] Someone ate your lunch from the fridge", "[CHAOS] You forgot to turn off the iron at home", "[CHAOS] A creeper says hello!", "[CHAOS] Your mom called, wants you to call back", "[CHAOS] An Enderman is looking at you... with love", "[CHAOS] You look beautiful today!", "[CHAOS] THE FLOOR IS LAVA!", "[CHAOS] Steve stole your diamonds", "[CHAOS] Herobrine liked your post", "[CHAOS] You are now breathing manually", "[CHAOS] Your tongue doesn't fit comfortably", "[CHAOS] You are now blinking manually", "[CHAOS] A spider is on your back IRL", "[CHAOS] Your game is about to crash... jk", "[CHAOS] Delete System32 for free diamonds", "[CHAOS] Alt+F4 for secret items!"};
    private static final String[] VOICES = new String[]{"[Voice] Dig straight down...", "[Voice] They're watching you...", "[Voice] Place a bed in the Nether...", "[Voice] Diamonds at Y=-59...", "[Voice] Hug a creeper...", "[Voice] Jump into the void...", "[Voice] Trust the Enderman...", "[Voice] The cake is a lie...", "[Voice] Water bucket MLG...", "[Voice] Sleep is for the weak..."};

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        int chance;
        if (!ChaosEvents.chaosEnabled) {
            return;
        }
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ++this.tickCounter;
        ++this.miniTickCounter;
        int miniDelay = 60 + (100 - ChaosEvents.chaosLevel) * 2;
        int majorDelay = 160 + (100 - ChaosEvents.chaosLevel) * 4;
        if (this.miniTickCounter >= miniDelay) {
            this.miniTickCounter = 0;
            chance = Math.max(5, ChaosEvents.chaosLevel / 3);
            if (random.nextInt(100) < chance) {
                event.getServer().m_6846_().m_11314_().forEach(this::miniChaosEvent);
            }
        }
        if (this.tickCounter >= majorDelay) {
            this.tickCounter = 0;
            chance = Math.max(10, ChaosEvents.chaosLevel / 2);
            if (random.nextInt(100) < chance) {
                event.getServer().m_6846_().m_11314_().forEach(this::majorChaosEvent);
            }
        }
    }

    private void miniChaosEvent(ServerPlayer player) {
        ServerLevel level = player.m_284548_();
        switch (random.nextInt(15)) {
            case 0: {
                player.m_213846_((Component)Component.m_237113_((String)RANDOM_MESSAGES[random.nextInt(RANDOM_MESSAGES.length)]));
                break;
            }
            case 1: {
                player.m_213846_((Component)Component.m_237113_((String)VOICES[random.nextInt(VOICES.length)]));
                break;
            }
            case 2: {
                level.m_5594_(null, player.m_20183_(), SoundEvents.f_11837_, SoundSource.HOSTILE, 1.0f, 1.0f);
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] *hissing sounds*"));
                break;
            }
            case 3: {
                level.m_5594_(null, player.m_20183_(), SoundEvents.f_11922_, SoundSource.HOSTILE, 0.5f, 1.0f);
                break;
            }
            case 4: {
                level.m_5594_(null, player.m_20183_(), SoundEvents.f_11851_, SoundSource.HOSTILE, 1.0f, 1.0f);
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] Don't look behind you..."));
                break;
            }
            case 5: {
                player.m_20256_(player.m_20184_().m_82520_(random.nextGaussian() * 0.3, 0.0, random.nextGaussian() * 0.3));
                player.f_19864_ = true;
                break;
            }
            case 6: {
                for (int i = 0; i < 20; ++i) {
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1, random.nextGaussian() * 0.5, random.nextDouble(), random.nextGaussian() * 0.5, 0.0);
                }
                break;
            }
            case 7: {
                level.m_5594_(null, player.m_20183_(), SoundEvents.f_12090_, SoundSource.WEATHER, 0.3f, 1.0f);
                break;
            }
            case 8: {
                player.m_213846_((Component)Component.m_237113_((String)("[CHAOS] *whispers* " + player.m_7755_().getString() + "...")));
                break;
            }
            case 9: {
                String[] sounds = new String[]{"*crack*", "*boom*", "*splash*", "*meow*", "*oink*", "*moo*", "*baa*"};
                player.m_213846_((Component)Component.m_237113_((String)sounds[random.nextInt(sounds.length)]));
                break;
            }
            case 10: {
                level.m_8767_((ParticleOptions)ParticleTypes.f_123750_, player.m_20185_(), player.m_20186_() + 2.0, player.m_20189_(), 5, 0.5, 0.5, 0.5, 0.0);
                break;
            }
            case 11: {
                level.m_8767_((ParticleOptions)ParticleTypes.f_123792_, player.m_20185_(), player.m_20186_() + 2.0, player.m_20189_(), 5, 0.5, 0.5, 0.5, 0.0);
                break;
            }
            case 12: {
                player.m_146922_(player.m_146908_() + (float)random.nextInt(90) - 45.0f);
                break;
            }
            case 13: {
                level.m_5594_(null, player.m_20183_(), (SoundEvent)SoundEvents.f_12216_.get(), SoundSource.BLOCKS, 1.0f, random.nextFloat() * 2.0f);
                break;
            }
            case 14: {
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] Achievement unlocked: Existing!"));
            }
        }
    }

    private void majorChaosEvent(ServerPlayer player) {
        ServerLevel level = player.m_284548_();
        BlockPos pos = player.m_20183_();
        switch (random.nextInt(65)) {
            case 0: {
                for (int i = 0; i < 10; ++i) {
                    int slot1 = random.nextInt(36);
                    int slot2 = random.nextInt(36);
                    ItemStack temp = player.m_150109_().m_8020_(slot1).m_41777_();
                    player.m_150109_().m_6836_(slot1, player.m_150109_().m_8020_(slot2).m_41777_());
                    player.m_150109_().m_6836_(slot2, temp);
                }
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] Someone reorganized your inventory!"));
                break;
            }
            case 1: {
                ItemStack gift = switch (random.nextInt(10)) {
                    case 0 -> new ItemStack((ItemLike)Items.f_42415_, random.nextInt(5) + 1);
                    case 1 -> new ItemStack((ItemLike)Items.f_42329_, 64);
                    case 2 -> new ItemStack((ItemLike)Items.f_42583_, 64);
                    case 3 -> new ItemStack((ItemLike)Items.f_42436_);
                    case 4 -> new ItemStack((ItemLike)Items.f_42418_);
                    case 5 -> new ItemStack((ItemLike)Items.f_42675_, 64);
                    case 6 -> new ItemStack((ItemLike)Items.f_42741_);
                    case 7 -> new ItemStack((ItemLike)Items.f_42747_);
                    case 8 -> new ItemStack((ItemLike)Items.f_41829_);
                    default -> new ItemStack((ItemLike)Items.f_42398_, 1);
                };
                ItemEntity itemEntity = new ItemEntity((Level)level, (double)pos.m_123341_(), (double)(pos.m_123342_() + 5), (double)pos.m_123343_(), gift);
                level.m_7967_((Entity)itemEntity);
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] A gift from the chaos gods!"));
                break;
            }
            case 2: {
                for (int i = 0; i < 10; ++i) {
                    Cow cow = new Cow(EntityType.f_20557_, (Level)level);
                    cow.m_6034_((double)(pos.m_123341_() + random.nextInt(10) - 5), (double)(pos.m_123342_() + 30), (double)(pos.m_123343_() + random.nextInt(10) - 5));
                    level.m_7967_((Entity)cow);
                }
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] IT'S RAINING COWS!"));
                break;
            }
            case 3: {
                MobEffectInstance effect = switch (random.nextInt(12)) {
                    case 0 -> new MobEffectInstance(MobEffects.f_19604_, 300, 0);
                    case 1 -> new MobEffectInstance(MobEffects.f_19603_, 300, 5);
                    case 2 -> new MobEffectInstance(MobEffects.f_19591_, 300, 0);
                    case 3 -> new MobEffectInstance(MobEffects.f_19593_, 300, 0);
                    case 4 -> new MobEffectInstance(MobEffects.f_19607_, 300, 0);
                    case 5 -> new MobEffectInstance(MobEffects.f_19620_, 100, 2);
                    case 6 -> new MobEffectInstance(MobEffects.f_19609_, 300, 0);
                    case 7 -> new MobEffectInstance(MobEffects.f_19619_, 300, 0);
                    case 8 -> new MobEffectInstance(MobEffects.f_19596_, 300, 5);
                    case 9 -> new MobEffectInstance(MobEffects.f_19611_, 300, 0);
                    case 10 -> new MobEffectInstance(MobEffects.f_19605_, 300, 2);
                    default -> new MobEffectInstance(MobEffects.f_19617_, 300, 4);
                };
                player.m_7292_(effect);
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] Effect roulette!"));
                break;
            }
            case 4: {
                for (int x = -2; x <= 2; ++x) {
                    for (int z = -2; z <= 2; ++z) {
                        level.m_7731_(pos.m_7495_().m_7918_(x, 0, z), Blocks.f_50016_.m_49966_(), 3);
                    }
                }
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] Floor? What floor?"));
                break;
            }
            case 5: {
                for (int i = 0; i < 5; ++i) {
                    FallingBlockEntity anvil = FallingBlockEntity.m_201971_((Level)level, (BlockPos)pos.m_6630_(20 + random.nextInt(10)).m_7918_(random.nextInt(6) - 3, 0, random.nextInt(6) - 3), (BlockState)Blocks.f_50322_.m_49966_());
                    level.m_7967_((Entity)anvil);
                }
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] ANVILS INCOMING!"));
                break;
            }
            case 6: {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 600, 0));
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] You're a lighthouse now!"));
                break;
            }
            case 7: {
                player.m_20334_(random.nextGaussian() * 0.8, 0.5, random.nextGaussian() * 0.8);
                player.f_19864_ = true;
                level.m_5594_(null, pos, SoundEvents.f_11913_, SoundSource.BLOCKS, 0.5f, 0.5f);
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] EARTHQUAKE!"));
                break;
            }
            case 8: {
                if (random.nextBoolean()) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 600, 0));
                    player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] ULTRA VISION!"));
                    break;
                }
                player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 0));
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] WHO TURNED OFF THE LIGHTS?!"));
                break;
            }
            case 9: {
                for (int i = 0; i < 8; ++i) {
                    Skeleton skeleton = new Skeleton(EntityType.f_20524_, (Level)level);
                    skeleton.m_6034_((double)(pos.m_123341_() + random.nextInt(10) - 5), (double)pos.m_123342_(), (double)(pos.m_123343_() + random.nextInt(10) - 5));
                    level.m_7967_((Entity)skeleton);
                }
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] SKELETON ARMY!"));
                break;
            }
            case 10: {
                for (int i = 0; i < 15; ++i) {
                    Chicken chicken = new Chicken(EntityType.f_20555_, (Level)level);
                    double angle = Math.toRadians(i * 24);
                    double radius = (double)i * 0.3;
                    chicken.m_6034_((double)pos.m_123341_() + Math.cos(angle) * radius, (double)pos.m_123342_() + (double)i * 0.3, (double)pos.m_123343_() + Math.sin(angle) * radius);
                    chicken.m_20334_(Math.cos(angle) * 0.3, 0.2, Math.sin(angle) * 0.3);
                    level.m_7967_((Entity)chicken);
                }
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] CHICKEN TORNADO!"));
                break;
            }
            case 11: {
                double newX = player.m_20185_() + (double)random.nextInt(100) - 50.0;
                double newZ = player.m_20189_() + (double)random.nextInt(100) - 50.0;
                player.m_6021_(newX, player.m_20186_() + 5.0, newZ);
                player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 60, 0));
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] TELEPORT ROULETTE!"));
                break;
            }
            case 12: {
                for (int i = 0; i < 10; ++i) {
                    Pig pig = new Pig(EntityType.f_20510_, (Level)level);
                    pig.m_6034_((double)(pos.m_123341_() + random.nextInt(10) - 5), (double)pos.m_123342_(), (double)(pos.m_123343_() + random.nextInt(10) - 5));
                    level.m_7967_((Entity)pig);
                }
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] PIG CAVALRY ARRIVED!"));
                break;
            }
            case 13: {
                level.m_7731_(pos.m_7495_(), Blocks.f_50090_.m_49966_(), 3);
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] Diamond floor! You're welcome!"));
                break;
            }
            case 14: {
                level.m_7731_(pos.m_7495_(), Blocks.f_50077_.m_49966_(), 3);
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] Don't look down..."));
                break;
            }
            case 15: {
                for (int i = 0; i < 8; ++i) {
                    double angle = Math.toRadians(i * 45);
                    Creeper creeper = new Creeper(EntityType.f_20558_, (Level)level);
                    creeper.m_6034_((double)pos.m_123341_() + Math.cos(angle) * 5.0, (double)pos.m_123342_(), (double)pos.m_123343_() + Math.sin(angle) * 5.0);
                    level.m_7967_((Entity)creeper);
                }
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] You're surrounded by friends!"));
                break;
            }
            case 16: {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 200, 20));
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] NYOOOOM!"));
                break;
            }
            case 17: {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 5));
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] Slow motion activated..."));
                break;
            }
            case 18: {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 400, 10));
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] EXTREME HUNGER!"));
                break;
            }
            case 19: {
                player.m_5634_(20.0f);
                player.m_36324_().m_38705_(20);
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] Full restore! Lucky you!"));
                break;
            }
            case 20: {
                for (int i = 0; i < 15; ++i) {
                    Spider spider = new Spider(EntityType.f_20479_, (Level)level);
                    spider.m_6034_((double)(pos.m_123341_() + random.nextInt(8) - 4), (double)pos.m_123342_(), (double)(pos.m_123343_() + random.nextInt(8) - 4));
                    level.m_7967_((Entity)spider);
                }
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] SPIDER SWARM!"));
                break;
            }
            case 21: {
                for (int i = 0; i < 20; ++i) {
                    Sheep sheep = new Sheep(EntityType.f_20520_, (Level)level);
                    sheep.m_6034_((double)pos.m_123341_(), (double)(pos.m_123342_() + 2), (double)pos.m_123343_());
                    sheep.m_20334_(random.nextGaussian() * 0.5, 1.0, random.nextGaussian() * 0.5);
                    sheep.m_29855_(DyeColor.m_41053_((int)random.nextInt(16)));
                    level.m_7967_((Entity)sheep);
                }
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] RAINBOW SHEEP EXPLOSION!"));
                break;
            }
            case 22: {
                level.m_5594_(null, pos, SoundEvents.f_12090_, SoundSource.WEATHER, 1.0f, 1.0f);
                for (int i = 0; i < 30; ++i) {
                    level.m_8767_((ParticleOptions)ParticleTypes.f_175830_, (double)pos.m_123341_() + random.nextGaussian() * 3.0, (double)pos.m_123342_() + random.nextDouble() * 3.0, (double)pos.m_123343_() + random.nextGaussian() * 3.0, 1, 0.0, 0.0, 0.0, 0.0);
                }
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] *ZAP*"));
                break;
            }
            case 23: {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 80, 5));
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] GRAVITY FLIP!"));
                break;
            }
            case 24: {
                level.m_45976_(ItemEntity.class, player.m_20191_().m_82400_(20.0)).forEach(item -> item.m_20256_(player.m_20182_().m_82546_(item.m_20182_()).m_82541_().m_82490_(0.5)));
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] ITEM MAGNET!"));
                break;
            }
            case 25: {
                level.m_45976_(Mob.class, player.m_20191_().m_82400_(30.0)).forEach(mob -> mob.m_20256_(player.m_20182_().m_82546_(mob.m_20182_()).m_82541_().m_82490_(0.3)));
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] All mobs want to be your friend!"));
                break;
            }
            case 26: {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 100, 10));
                for (int i = 0; i < 3; ++i) {
                    level.m_255391_(null, (double)(pos.m_123341_() + random.nextInt(6) - 3), (double)pos.m_123342_(), (double)(pos.m_123343_() + random.nextInt(6) - 3), 3.0f, false, Level.ExplosionInteraction.TNT);
                }
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] BOOM! (you're immune tho)"));
                break;
            }
            case 27: {
                for (int x = -3; x <= 3; ++x) {
                    for (int z = -3; z <= 3; ++z) {
                        level.m_7731_(pos.m_7495_().m_7918_(x, 0, z), Blocks.f_50374_.m_49966_(), 3);
                    }
                }
                player.m_20334_(0.0, 2.0, 0.0);
                player.f_19864_ = true;
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] BOUNCY CASTLE!"));
                break;
            }
            case 28: {
                for (int x = -2; x <= 2; ++x) {
                    for (int z = -2; z <= 2; ++z) {
                        level.m_7731_(pos.m_7918_(x, 0, z), Blocks.f_50719_.m_49966_(), 3);
                    }
                }
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] STICKY SITUATION!"));
                break;
            }
            case 29: {
                for (int i = 0; i < 20; ++i) {
                    FireworkRocketEntity fw = new FireworkRocketEntity((Level)level, (double)(pos.m_123341_() + random.nextInt(10) - 5), (double)pos.m_123342_(), (double)(pos.m_123343_() + random.nextInt(10) - 5), ItemStack.f_41583_);
                    level.m_7967_((Entity)fw);
                }
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] CELEBRATION TIME!"));
                break;
            }
            case 30: {
                PCInteractionManager.scarePlayer(player);
                break;
            }
            case 31: {
                PCInteractionManager.fakeError(player);
                break;
            }
            case 32: {
                PCInteractionManager.creepySound(player);
                break;
            }
            case 33: {
                PCInteractionManager.screenShake(player);
                break;
            }
            case 34: {
                PCInteractionManager.invertControls(player);
                break;
            }
            case 35: {
                PCInteractionManager.fakeLag(player);
                break;
            }
            case 36: {
                PCInteractionManager.matrixEffect(player);
                break;
            }
            case 37: {
                PCInteractionManager.fakeAchievement(player);
                break;
            }
            case 38: {
                WorldChaosManager.floorDisappear(level, pos, player);
                break;
            }
            case 39: {
                WorldChaosManager.worldInversion(level, pos, player);
                break;
            }
            case 40: {
                WorldChaosManager.gravityWaves(level, pos, player);
                break;
            }
            case 41: {
                WorldChaosManager.timeFreeze(level, player);
                break;
            }
            case 42: {
                WorldChaosManager.blockRoulette(level, pos, player);
                break;
            }
            case 43: {
                if (random.nextBoolean()) {
                    level.m_8606_(0, 6000, true, true);
                    player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] STORM SUMMONED!"));
                    break;
                }
                level.m_8606_(6000, 0, false, false);
                player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] Perfect weather!"));
                break;
            }
            case 44: {
                long time = random.nextBoolean() ? 0L : 18000L;
                level.m_8615_(time);
                player.m_213846_((Component)Component.m_237113_((String)("[CHAOS] TIME WARP! " + (time == 0L ? "Day" : "Night") + "!")));
                break;
            }
            case 45: {
                InsaneMechanics.realityGlitch(level, player);
                break;
            }
            case 46: {
                InsaneMechanics.cloneArmy(level, player);
                break;
            }
            case 47: {
                InsaneMechanics.reverseWorld(level, player);
                break;
            }
            case 48: {
                InsaneMechanics.chickenDimension(level, player);
                break;
            }
            case 49: {
                InsaneMechanics.itemRain(level, player);
                break;
            }
            case 50: {
                InsaneMechanics.lightningStorm(level, player);
                break;
            }
            case 51: {
                InsaneMechanics.drunkMode(player);
                break;
            }
            case 52: {
                InsaneMechanics.blockSnake(level, player);
                break;
            }
            case 53: {
                InsaneMechanics.mirrorDimension(level, player);
                break;
            }
            case 54: {
                InsaneMechanics.sizeShift(player);
                break;
            }
            case 55: {
                InsaneMechanics.blockTornado(level, player);
                break;
            }
            case 56: {
                InsaneMechanics.quantumTeleport(player);
                break;
            }
            case 57: {
                InsaneMechanics.sizeShift(player);
                break;
            }
            case 58: {
                InsaneMechanics.drunkMode(player);
                break;
            }
            case 59: {
                InsaneMechanics.blockSnake(level, player);
                break;
            }
            case 60: {
                InsaneMechanics.itemRain(level, player);
                break;
            }
            case 61: {
                InsaneMechanics.lightningStorm(level, player);
                break;
            }
            case 62: {
                InsaneMechanics.quantumTeleport(player);
                break;
            }
            case 63: {
                InsaneMechanics.mirrorDimension(level, player);
                break;
            }
            case 64: {
                InsaneMechanics.reverseWorld(level, player);
            }
        }
    }
}

