/*
 * Decompiled with CFR 0.152.
 */
package com.chaoscraft;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class WorldChaosManager {
    private static final Random random = new Random();
    private static final Map<ServerPlayer, Long> lastChaosTime = new HashMap<ServerPlayer, Long>();
    private static final int MAX_CHICKENS = 10;

    public static void floorDisappear(ServerLevel level, BlockPos center, ServerPlayer player) {
        ArrayList<BlockPos> toRemove = new ArrayList<BlockPos>();
        for (int radius = 1; radius <= 4; ++radius) {
            for (int angle = 0; angle < 360; angle += 30) {
                double rad = Math.toRadians(angle);
                int x = (int)(Math.cos(rad) * (double)radius);
                int z = (int)(Math.sin(rad) * (double)radius);
                BlockPos pos = center.m_7495_().m_7918_(x, 0, z);
                if (level.m_8055_(pos).m_60795_()) continue;
                toRemove.add(pos);
            }
        }
        new Thread(() -> {
            int i = 0;
            while (i < toRemove.size()) {
                int index = i++;
                try {
                    Thread.sleep(50L);
                    level.m_7654_().execute(() -> {
                        if (index < toRemove.size()) {
                            level.m_7731_((BlockPos)toRemove.get(index), Blocks.f_50016_.m_49966_(), 3);
                        }
                    });
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }).start();
        player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] Floor is disappearing in spiral!"));
    }

    public static void worldInversion(ServerLevel level, BlockPos center, ServerPlayer player) {
        for (int x = -5; x <= 5; ++x) {
            for (int y = -3; y <= 3; ++y) {
                for (int z = -5; z <= 5; ++z) {
                    BlockState newState;
                    BlockPos pos = center.m_7918_(x, y, z);
                    BlockState state = level.m_8055_(pos);
                    switch (state.m_60734_().toString()) {
                        case "Block{minecraft:stone}": {
                            BlockState blockState = Blocks.f_50089_.m_49966_();
                            break;
                        }
                        case "Block{minecraft:dirt}": {
                            BlockState blockState = Blocks.f_50074_.m_49966_();
                            break;
                        }
                        case "Block{minecraft:grass_block}": {
                            BlockState blockState = Blocks.f_50268_.m_49966_();
                            break;
                        }
                        case "Block{minecraft:water}": {
                            BlockState blockState = Blocks.f_49991_.m_49966_();
                            break;
                        }
                        case "Block{minecraft:lava}": {
                            BlockState blockState = Blocks.f_49990_.m_49966_();
                            break;
                        }
                        default: {
                            BlockState blockState = newState = state;
                        }
                    }
                    if (newState == state) continue;
                    level.m_7731_(pos, newState, 3);
                }
            }
        }
        player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] WORLD INVERSION!"));
    }

    public static void gravityWaves(final ServerLevel level, BlockPos center, ServerPlayer player) {
        new Thread(() -> {
            int wave = 0;
            while (wave < 5) {
                int w = wave++;
                try {
                    Thread.sleep(200L);
                    level.m_7654_().execute(() -> {
                        for (int angle = 0; angle < 360; angle += 15) {
                            int z;
                            double rad = Math.toRadians(angle);
                            int x = (int)(Math.cos(rad) * (double)(w + 3));
                            final BlockPos pos = center.m_7918_(x, 0, z = (int)(Math.sin(rad) * (double)(w + 3)));
                            final BlockState below = level.m_8055_(pos.m_7495_());
                            if (below.m_60795_()) continue;
                            level.m_7731_(pos.m_7494_(), below, 3);
                            new Timer().schedule(new TimerTask(){

                                @Override
                                public void run() {
                                    level.m_7654_().execute(() -> {
                                        if (level.m_8055_(pos.m_7494_()).m_60734_() == below.m_60734_()) {
                                            level.m_7731_(pos.m_7494_(), Blocks.f_50016_.m_49966_(), 3);
                                        }
                                    });
                                }
                            }, 500L);
                        }
                    });
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }).start();
        player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] GRAVITY WAVES!"));
    }

    public static void timeFreeze(ServerLevel level, ServerPlayer player) {
        level.m_8583_().forEach(entity -> {
            if (entity != player) {
                entity.m_20334_(0.0, 0.0, 0.0);
            }
        });
        player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] ZA WARUDO! Time stopped!"));
    }

    public static void blockRoulette(ServerLevel level, BlockPos center, ServerPlayer player) {
        BlockState[] blocks = new BlockState[]{Blocks.f_50090_.m_49966_(), Blocks.f_50077_.m_49966_(), Blocks.f_50056_.m_49966_(), Blocks.f_50374_.m_49966_(), Blocks.f_50719_.m_49966_(), Blocks.f_50450_.m_49966_(), Blocks.f_50126_.m_49966_()};
        new Thread(() -> {
            int spin = 0;
            while (spin < 10) {
                int s = spin++;
                try {
                    Thread.sleep(100L);
                    level.m_7654_().execute(() -> {
                        BlockState block = blocks[s % blocks.length];
                        for (int x = -2; x <= 2; ++x) {
                            for (int z = -2; z <= 2; ++z) {
                                level.m_7731_(center.m_7918_(x, -1, z), block, 3);
                            }
                        }
                    });
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }).start();
        player.m_213846_((Component)Component.m_237113_((String)"[CHAOS] BLOCK ROULETTE!"));
    }
}

