/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.block;

import com.github.wolfiewaffle.hardcore_torches.HardcoreTorches;
import com.github.wolfiewaffle.hardcore_torches.blockentity.FuelBlockEntity;
import com.github.wolfiewaffle.hardcore_torches.blockentity.IFuelBlock;
import com.github.wolfiewaffle.hardcore_torches.blockentity.LanternBlockEntity;
import com.github.wolfiewaffle.hardcore_torches.component.DataTypes;
import com.github.wolfiewaffle.hardcore_torches.config.Config;
import com.github.wolfiewaffle.hardcore_torches.init.BlockEntityInit;
import com.github.wolfiewaffle.hardcore_torches.item.LanternItem;
import com.github.wolfiewaffle.hardcore_torches.util.LanternGroup;
import com.github.wolfiewaffle.hardcore_torches.util.LanternTools;
import com.github.wolfiewaffle.hardcore_torches.util.TorchTools;
import java.util.function.IntSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLanternBlock
extends BaseEntityBlock
implements EntityBlock,
IFuelBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty HANGING = BlockStateProperties.HANGING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape AABB = Shapes.or((VoxelShape)Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)7.0, (double)11.0), (VoxelShape)Block.box((double)6.0, (double)7.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0));
    protected static final VoxelShape HANGING_AABB = Shapes.or((VoxelShape)Block.box((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), (VoxelShape)Block.box((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0));
    public static final int LANTERN_LIGHT_LEVEL = 15;
    public boolean isLit;
    public LanternGroup group;
    public IntSupplier maxFuel;

    protected AbstractLanternBlock(BlockBehaviour.Properties prop, boolean isLit, IntSupplier maxFuel) {
        super(prop);
        this.isLit = isLit;
        this.maxFuel = maxFuel;
    }

    @Override
    public boolean isSoulVariant() {
        return this.group == HardcoreTorches.soulLanterns;
    }

    @Override
    public int getMaxFuel() {
        return this.maxFuel.getAsInt();
    }

    @Override
    public boolean canLight(Level world, BlockPos pos) {
        return ((LanternBlockEntity)world.getBlockEntity(pos)).getFuel() > 0 && !this.isLit;
    }

    @Override
    public void extinguish(Level world, BlockPos pos, BlockState state, boolean playSound) {
        if (!world.isClientSide) {
            if (playSound) {
                world.playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            TorchTools.displayParticle(ParticleTypes.LARGE_SMOKE, state, world, pos);
            TorchTools.displayParticle(ParticleTypes.LARGE_SMOKE, state, world, pos);
            TorchTools.displayParticle(ParticleTypes.SMOKE, state, world, pos);
            TorchTools.displayParticle(ParticleTypes.SMOKE, state, world, pos);
            this.setState(world, pos, false);
        }
    }

    @Override
    public ItemInteractionResult attemptLight(Level world, BlockPos pos, BlockState state, Player player, ItemStack stack, InteractionHand hand) {
        return LanternTools.basicAttemptLight(world, pos, player, stack, hand);
    }

    @Override
    public void light(Level world, BlockPos pos) {
        if (!world.isClientSide) {
            world.playSound(null, pos, SoundEvents.FIRECHARGE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.setState(world, pos, true);
        }
    }

    public void setState(Level world, BlockPos pos, boolean lit) {
        BlockState oldState = world.getBlockState(pos);
        BlockState newState = this.group.getLanternBlock(lit).defaultBlockState();
        newState = (BlockState)((BlockState)newState.setValue((Property)HANGING, (Comparable)((Boolean)oldState.getValue((Property)HANGING)))).setValue((Property)WATERLOGGED, (Comparable)((Boolean)oldState.getValue((Property)WATERLOGGED)));
        int newFuel = 0;
        if (world.getBlockEntity(pos) != null) {
            newFuel = ((FuelBlockEntity)world.getBlockEntity(pos)).getFuel();
        }
        world.setBlockAndUpdate(pos, newState);
        if (world.getBlockEntity(pos) != null) {
            ((FuelBlockEntity)world.getBlockEntity(pos)).setFuel(newFuel);
        }
    }

    @Override
    public ItemStack getStack(Level world, BlockPos pos) {
        ItemStack stack = new ItemStack((ItemLike)world.getBlockState(pos).getBlock().asItem());
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity != null && blockEntity instanceof FuelBlockEntity) {
            int remainingFuel = ((FuelBlockEntity)blockEntity).getFuel();
            stack.set(DataTypes.FUEL, (Object)remainingFuel);
        }
        return stack;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return LanternTools.interactLantern(state, world, pos, player, hand);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hitResult) {
        return LanternTools.interactLanternEmpty(state, world, pos, player, InteractionHand.MAIN_HAND);
    }

    @Override
    public boolean isLit() {
        return this.isLit;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        super.setPlacedBy(world, pos, state, placer, itemStack);
        BlockEntity be = world.getBlockEntity(pos);
        if (be != null && be instanceof FuelBlockEntity && itemStack.getItem() instanceof LanternItem) {
            int fuel = LanternItem.getFuel(itemStack);
            ((FuelBlockEntity)be).setFuel(fuel);
        }
    }

    public boolean isLightItem(ItemStack stack) {
        if (stack.is(HardcoreTorches.FREE_LANTERN_LIGHT_ITEMS)) {
            return true;
        }
        if (stack.is(HardcoreTorches.DAMAGE_LANTERN_LIGHT_ITEMS)) {
            return true;
        }
        return stack.is(HardcoreTorches.CONSUME_LANTERN_LIGHT_ITEMS);
    }

    @Override
    public void outOfFuel(Level world, BlockPos pos, BlockState state) {
        ((AbstractLanternBlock)world.getBlockState(pos).getBlock()).extinguish(world, pos, state, true);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = Blocks.LANTERN.getStateForPlacement(context);
        BlockState newState = null;
        if (state != null) {
            newState = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)HANGING, (Comparable)((Boolean)state.getValue((Property)HANGING)))).setValue((Property)WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)WATERLOGGED)));
        }
        return newState;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateDefinition) {
        stateDefinition.add(new Property[]{HANGING, WATERLOGGED});
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = AbstractLanternBlock.getConnectedDirection(state).getOpposite();
        return Block.canSupportCenter((LevelReader)level, (BlockPos)pos.relative(direction), (Direction)direction.getOpposite());
    }

    public PushReaction getPistonPushReaction(BlockState p_153494_) {
        return PushReaction.DESTROY;
    }

    protected static Direction getConnectedDirection(BlockState state) {
        return (Boolean)state.getValue((Property)HANGING) != false ? Direction.DOWN : Direction.UP;
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return AbstractLanternBlock.getConnectedDirection(state).getOpposite() == direction && !state.canSurvive((LevelReader)level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)HANGING) != false ? HANGING_AABB : AABB;
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return type == BlockEntityInit.LANTERN_BLOCK_ENTITY.get() ? (level, pos, blockState, be) -> ((LanternBlockEntity)be).tick() : super.getTicker(world, state, type);
    }

    public RenderShape getRenderShape(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        LanternBlockEntity be = new LanternBlockEntity(pos, state);
        be.setFuel((Integer)Config.startingLanternFuel.get());
        return be;
    }
}

