/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.block;

import com.github.wolfiewaffle.hardcore_torches.blockentity.HardcoreCampfireBlockEntity;
import com.github.wolfiewaffle.hardcore_torches.blockentity.IFuelBlock;
import com.github.wolfiewaffle.hardcore_torches.config.Config;
import com.github.wolfiewaffle.hardcore_torches.init.BlockEntityInit;
import com.github.wolfiewaffle.hardcore_torches.util.ETorchState;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class HardcoreCampfire
extends CampfireBlock
implements IFuelBlock {
    public HardcoreCampfire(boolean p_51236_, int p_51237_, BlockBehaviour.Properties p_51238_) {
        super(p_51236_, p_51237_, p_51238_);
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_51240_) {
        BlockPos blockpos;
        Level levelaccessor = p_51240_.getLevel();
        boolean flag = levelaccessor.getFluidState(blockpos = p_51240_.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).setValue((Property)SIGNAL_FIRE, (Comparable)Boolean.valueOf(this.isSmokeSource(levelaccessor.getBlockState(blockpos.below()))))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)p_51240_.getHorizontalDirection());
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.getItem() instanceof FlintAndSteelItem) {
            if (((Boolean)state.getValue((Property)CampfireBlock.LIT)).booleanValue()) {
                return super.useItemOn(stack, state, world, pos, player, hand, hitResult);
            }
            if (!world.isClientSide) {
                BlockEntity blockEntity;
                HardcoreCampfire campfire;
                Block block = state.getBlock();
                if (block instanceof HardcoreCampfire && !(campfire = (HardcoreCampfire)block).canLight(world, pos)) {
                    if (campfire.getFuel(world, pos) <= 0) {
                        return this.needsFuel(player);
                    }
                } else if (CampfireBlock.canLight((BlockState)state) && (blockEntity = world.getBlockEntity(pos)) instanceof HardcoreCampfireBlockEntity) {
                    HardcoreCampfireBlockEntity campfire2 = (HardcoreCampfireBlockEntity)blockEntity;
                    if (this.attemptUseItem(stack, player, hand, ETorchState.LIT)) {
                        this.light(world, pos, state);
                        player.swing(hand);
                        return ItemInteractionResult.SUCCESS;
                    }
                }
            }
            return ItemInteractionResult.CONSUME;
        }
        if (this.isValidStack(stack, this.getFreeLightItems(), this.getDamageLightItems(), this.getConsumeLightItems())) {
            if (((Boolean)state.getValue((Property)CampfireBlock.LIT)).booleanValue()) {
                return super.useItemOn(stack, state, world, pos, player, hand, hitResult);
            }
            if (!world.isClientSide) {
                if (this.getFuel(world, pos) <= 0) {
                    return this.needsFuel(player);
                }
                BlockEntity blockEntity = world.getBlockEntity(pos);
                if (blockEntity instanceof HardcoreCampfireBlockEntity) {
                    HardcoreCampfireBlockEntity campfire = (HardcoreCampfireBlockEntity)blockEntity;
                    if (this.attemptUseItem(stack, player, hand, ETorchState.LIT)) {
                        this.light(world, pos, state);
                        player.swing(hand);
                        return ItemInteractionResult.SUCCESS;
                    }
                }
            }
            return ItemInteractionResult.CONSUME;
        }
        return super.useItemOn(stack, state, world, pos, player, hand, hitResult);
    }

    private boolean isSmokeSource(BlockState p_51324_) {
        return p_51324_.is(Blocks.HAY_BLOCK);
    }

    public static ToIntFunction<BlockState> litBlockEmission(int p_50760_) {
        return p_50763_ -> (Boolean)p_50763_.getValue((Property)BlockStateProperties.LIT) != false ? p_50760_ : 0;
    }

    @Override
    public int getMaxFuel() {
        return (Integer)Config.campfireMaxFuel.get();
    }

    @Override
    public void outOfFuel(Level world, BlockPos pos, BlockState state) {
        BlockState newState = (BlockState)state.setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false));
        world.setBlockAndUpdate(pos, newState);
    }

    public void light(Level world, BlockPos pos, BlockState state) {
        BlockState newState = (BlockState)state.setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(true));
        world.setBlockAndUpdate(pos, newState);
        world.playSound(null, pos, SoundEvents.FIRECHARGE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    @Override
    public boolean canLight(Level world, BlockPos pos) {
        HardcoreCampfireBlockEntity campfire;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity != null && blockEntity instanceof HardcoreCampfireBlockEntity && (campfire = (HardcoreCampfireBlockEntity)blockEntity).getFuel() <= 0) {
            return false;
        }
        return HardcoreCampfire.canLight((BlockState)world.getBlockState(pos));
    }

    public int getFuel(Level world, BlockPos pos) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity != null && blockEntity instanceof HardcoreCampfireBlockEntity) {
            HardcoreCampfireBlockEntity campfire = (HardcoreCampfireBlockEntity)blockEntity;
            return campfire.getFuel();
        }
        return 0;
    }

    public ItemInteractionResult needsFuel(Player player) {
        player.displayClientMessage((Component)Component.literal((String)"Drop combustible items on top to add fuel!"), true);
        return ItemInteractionResult.CONSUME;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new HardcoreCampfireBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        if (world.isClientSide) {
            return (Boolean)state.getValue((Property)LIT) != false ? HardcoreCampfire.createTickerHelper(type, (BlockEntityType)((BlockEntityType)BlockEntityInit.CAMPFIRE_BLOCK_ENTITY.get()), HardcoreCampfireBlockEntity::clientTick) : null;
        }
        return (Boolean)state.getValue((Property)LIT) != false ? HardcoreCampfire.createTickerHelper(type, (BlockEntityType)((BlockEntityType)BlockEntityInit.CAMPFIRE_BLOCK_ENTITY.get()), HardcoreCampfireBlockEntity::cookTick) : HardcoreCampfire.createTickerHelper(type, (BlockEntityType)((BlockEntityType)BlockEntityInit.CAMPFIRE_BLOCK_ENTITY.get()), HardcoreCampfireBlockEntity::cooldownTick);
    }

    @Override
    public boolean isSoulVariant() {
        return false;
    }

    @Override
    public ItemStack getStack(Level world, BlockPos pos) {
        return new ItemStack((ItemLike)world.getBlockState(pos).getBlock());
    }

    @Override
    public void extinguish(Level world, BlockPos pos, BlockState state, boolean playSound) {
        this.outOfFuel(world, pos, state);
    }

    @Override
    public void light(Level world, BlockPos pos) {
    }

    @Override
    public ItemInteractionResult attemptLight(Level world, BlockPos pos, BlockState state, Player player, ItemStack stack, InteractionHand hand) {
        return ItemInteractionResult.FAIL;
    }

    @Override
    public boolean isLit() {
        return false;
    }
}

