/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.blockentity;

import com.github.wolfiewaffle.hardcore_torches.block.AbstractLanternBlock;
import com.github.wolfiewaffle.hardcore_torches.blockentity.FuelBlockEntity;
import com.github.wolfiewaffle.hardcore_torches.config.Config;
import com.github.wolfiewaffle.hardcore_torches.init.BlockEntityInit;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class LanternBlockEntity
extends FuelBlockEntity {
    public LanternBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.LANTERN_BLOCK_ENTITY.get(), pos, state);
        this.fuel = (Integer)Config.startingLanternFuel.get();
    }

    @Override
    public int getMaxFuel() {
        return (Integer)Config.defaultLanternFuel.get();
    }

    public void tick() {
        Level world = this.getLevel();
        if (!world.isClientSide) {
            BlockPos pos = this.getBlockPos();
            if (this.fuel >= 0 && ((AbstractLanternBlock)world.getBlockState((BlockPos)pos).getBlock()).isLit) {
                this.changeFuel(-1);
            }
            this.setChanged();
        }
    }
}

