/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.compat.curio;

import com.github.wolfiewaffle.hardcore_torches.config.Config;
import com.github.wolfiewaffle.hardcore_torches.item.BandolierItem;
import com.github.wolfiewaffle.hardcore_torches.item.TorchItem;
import com.github.wolfiewaffle.hardcore_torches.util.ETorchState;
import java.util.Optional;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.event.entity.player.UseItemOnBlockEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class BandolierCurio
implements ICurio {
    ItemStack stack;

    public BandolierCurio(ItemStack stack) {
        this.stack = stack;
    }

    public void curioTick(SlotContext slotContext) {
        if (!((Boolean)Config.tickInInventory.get()).booleanValue()) {
            return;
        }
        String identifier = slotContext.identifier();
        int index = slotContext.index();
        LivingEntity entity = slotContext.entity();
        Optional stackHandler = CuriosApi.getCuriosInventory((LivingEntity)entity);
        stackHandler.ifPresent(handler -> {
            IDynamicStackHandler dynamicStackHandler = ((ICurioStacksHandler)handler.getCurios().get(identifier)).getStacks();
            dynamicStackHandler.setStackInSlot(index, BandolierItem.getTickedBandolier(dynamicStackHandler.getStackInSlot(index)));
        });
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public boolean tryPlace(Player player, BlockPlaceContext placeContext) {
        ItemStack stack = placeContext.getItemInHand();
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            InteractionResult result = blockItem.place(placeContext);
            return result != InteractionResult.FAIL;
        }
        return false;
    }

    public static void handleRightClick(UseItemOnBlockEvent event, BlockHitResult hitResult) {
        Player player = event.getPlayer();
        InteractionHand hand = event.getHand();
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(curiosInventory -> curiosInventory.getStacksHandler("belt").ifPresent(slotInventory -> {
            IDynamicStackHandler stackHandler = slotInventory.getStacks();
            for (int i = 0; i < stackHandler.getSlots(); ++i) {
                ICurio curio = (ICurio)CuriosCapability.ITEM.getCapability(stackHandler.getStackInSlot(i), null);
                if (!(curio instanceof BandolierCurio)) continue;
                BandolierCurio bandolier = (BandolierCurio)curio;
                ItemStack bandolierStack = bandolier.stack;
                ItemStack torchStack = BandolierItem.getNextTorchOrEmpty(bandolierStack, true);
                Item patt0$temp = torchStack.getItem();
                if (!(patt0$temp instanceof TorchItem)) continue;
                TorchItem torchItem = (TorchItem)patt0$temp;
                ItemStack placementStack = TorchItem.stateStack(torchStack, torchItem.burnState != ETorchState.BURNT ? ETorchState.LIT : ETorchState.BURNT);
                BlockPlaceContext context = new BlockPlaceContext(player, hand, placementStack, hitResult);
                if (!bandolier.tryPlace(player, context)) continue;
                BandolierItem.deleteOneTorch(bandolierStack, torchStack);
                player.swing(InteractionHand.MAIN_HAND);
                event.setCanceled(true);
            }
        }));
    }
}

