/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.compat.farmersdelight;

import com.github.wolfiewaffle.hardcore_torches.compat.farmersdelight.FarmersCommonCompat;
import com.github.wolfiewaffle.hardcore_torches.config.Config;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import vectorwing.farmersdelight.common.block.StoveBlock;
import vectorwing.farmersdelight.common.block.entity.StoveBlockEntity;

public class HardcoreStoveBlockEntity
extends StoveBlockEntity {
    int fuel = 0;

    public HardcoreStoveBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public void addFuel(int additional) {
        this.fuel += additional;
        if (this.fuel > (Integer)Config.campfireMaxFuel.get()) {
            this.fuel = (Integer)Config.campfireMaxFuel.get();
        }
    }

    public boolean canAcceptFuel(int additional) {
        return this.fuel + additional <= (Integer)Config.campfireMaxFuel.get();
    }

    public BlockEntityType<?> getType() {
        return (BlockEntityType)FarmersCommonCompat.STOVE_BLOCK_ENTITY.get();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, HardcoreStoveBlockEntity stove) {
        Block block;
        StoveBlockEntity.cookingTick((Level)level, (BlockPos)pos, (BlockState)state, (StoveBlockEntity)stove);
        --stove.fuel;
        if (stove.fuel <= 0 && (block = state.getBlock()) instanceof StoveBlock) {
            StoveBlock stoveBlock = (StoveBlock)block;
            stoveBlock.extinguish(state, level, pos);
        }
    }

    public static void animationTick(Level level, BlockPos pos, BlockState state, HardcoreStoveBlockEntity stove) {
        StoveBlockEntity.animationTick((Level)level, (BlockPos)pos, (BlockState)state, (StoveBlockEntity)stove);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.fuel = compound.contains("Fuel") ? compound.getInt("Fuel") : 0;
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putInt("Fuel", this.fuel);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        this.loadAdditional(pkt.getTag(), lookupProvider);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag nbt = super.getUpdateTag(registries);
        this.saveAdditional(nbt, registries);
        return nbt;
    }
}

