/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.event;

import com.github.wolfiewaffle.hardcore_torches.compat.curio.BandolierCurio;
import com.github.wolfiewaffle.hardcore_torches.config.Config;
import com.github.wolfiewaffle.hardcore_torches.item.BandolierItem;
import com.github.wolfiewaffle.hardcore_torches.item.LanternItem;
import com.github.wolfiewaffle.hardcore_torches.item.TorchItem;
import com.github.wolfiewaffle.hardcore_torches.util.ETorchState;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.event.entity.player.UseItemOnBlockEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class PlayerEventHandler {
    private static Random random = new Random();

    @SubscribeEvent
    public void playerTick(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        Inventory inventory = player.getInventory();
        Level world = player.level();
        BlockPos pos = player.getOnPos().above();
        int rainEffect = (Integer)Config.invExtinguishInRain.get();
        boolean doRain = rainEffect > 0 && world.isRainingAt(pos);
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            Item item = stack.getItem();
            if (item instanceof TorchItem) {
                boolean mainOrOffhand;
                TorchItem torchItem = (TorchItem)item;
                boolean rain = doRain;
                boolean bl = mainOrOffhand = i == inventory.selected || inventory.offhand.get(0) == stack;
                if (rainEffect == 1 && doRain) {
                    boolean bl2 = rain = mainOrOffhand;
                }
                if (rain) {
                    if (torchItem.burnState == ETorchState.LIT) {
                        if (((Boolean)Config.torchesSmolder.get()).booleanValue()) {
                            inventory.setItem(i, TorchItem.stateStack(stack, ETorchState.SMOLDERING));
                            world.playSound(null, pos.above(), SoundEvents.FIRE_EXTINGUISH, SoundSource.PLAYERS, 0.5f, 1.0f);
                            continue;
                        }
                        inventory.setItem(i, TorchItem.stateStack(stack, ETorchState.UNLIT));
                        world.playSound(null, pos.above(), SoundEvents.FIRE_EXTINGUISH, SoundSource.PLAYERS, 0.5f, 1.0f);
                        continue;
                    }
                    if (torchItem.burnState == ETorchState.SMOLDERING && !((Boolean)Config.torchesSmolder.get()).booleanValue()) {
                        inventory.setItem(i, TorchItem.stateStack(stack, ETorchState.UNLIT));
                        world.playSound(null, pos.above(), SoundEvents.FIRE_EXTINGUISH, SoundSource.PLAYERS, 0.5f, 1.0f);
                        continue;
                    }
                }
                if ((Integer)Config.invExtinguishInWater.get() > 0 && player.isUnderWater() && (torchItem.burnState == ETorchState.LIT || torchItem.burnState == ETorchState.SMOLDERING) && ((Integer)Config.invExtinguishInWater.get() == 1 && mainOrOffhand || (Integer)Config.invExtinguishInWater.get() == 2)) {
                    inventory.setItem(i, TorchItem.stateStack(stack, ETorchState.UNLIT));
                    world.playSound(null, pos.above(), SoundEvents.FIRE_EXTINGUISH, SoundSource.PLAYERS, 0.5f, 1.0f);
                    continue;
                }
                if (((Boolean)Config.tickInInventory.get()).booleanValue() && torchItem.burnState == ETorchState.LIT) {
                    inventory.setItem(i, TorchItem.addFuel(stack, world, -1));
                }
                if (!((Boolean)Config.tickInInventory.get()).booleanValue() || torchItem.burnState != ETorchState.SMOLDERING || random.nextInt(3) != 0) continue;
                inventory.setItem(i, TorchItem.addFuel(stack, world, -1));
                continue;
            }
            if (item instanceof LanternItem) {
                if (!((Boolean)Config.tickInInventory.get()).booleanValue() || !((LanternItem)item).isLit) continue;
                inventory.setItem(i, LanternItem.addFuel(stack, world, -1));
                continue;
            }
            if (!(item instanceof BandolierItem)) continue;
            BandolierItem bandolier = (BandolierItem)item;
            if (!((Boolean)Config.tickInInventory.get()).booleanValue()) continue;
            inventory.setItem(i, BandolierItem.getTickedBandolier(stack));
        }
    }

    @SubscribeEvent
    public void playerInteract(UseItemOnBlockEvent event) {
        if ((Integer)Config.bandolierInteractMode.get() == 0) {
            return;
        }
        if (event.getCancellationResult() == ItemInteractionResult.CONSUME || event.getCancellationResult() == ItemInteractionResult.SUCCESS || event.getCancellationResult() == ItemInteractionResult.FAIL) {
            return;
        }
        int mode = (Integer)Config.bandolierInteractMode.get();
        switch (mode) {
            case 1: {
                if (event.getHand() != InteractionHand.MAIN_HAND) break;
                return;
            }
            case 2: {
                if (event.getHand() == InteractionHand.MAIN_HAND) {
                    return;
                }
                if (event.getPlayer().getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) break;
                return;
            }
        }
        if (!ModList.get().isLoaded("curios")) {
            return;
        }
        if (mode != 0) {
            HitResult hitResult;
            ItemStack item = event.getItemStack();
            if ((mode == 1 || item.isEmpty()) && event.getCancellationResult() == ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION && (hitResult = Minecraft.getInstance().hitResult) instanceof BlockHitResult) {
                BlockHitResult result = (BlockHitResult)hitResult;
                BandolierCurio.handleRightClick(event, result);
            }
        }
    }
}

