/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.item;

import com.github.wolfiewaffle.hardcore_torches.block.AbstractHardcoreTorchBlock;
import com.github.wolfiewaffle.hardcore_torches.block.AbstractLanternBlock;
import com.github.wolfiewaffle.hardcore_torches.block.HardcoreCampfire;
import com.github.wolfiewaffle.hardcore_torches.config.Config;
import com.github.wolfiewaffle.hardcore_torches.util.ETorchState;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.phys.BlockHitResult;

public class FireStarterItem
extends Item {
    private static final int USE_DURATION = 72000;

    public FireStarterItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        return super.useOn(context);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.literal((String)"Has a chance to fail").withStyle(ChatFormatting.GRAY));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void releaseUsing(ItemStack stack, Level world, LivingEntity entity, int number) {
        boolean attempt;
        block14: {
            boolean simulateFlintAndSteel;
            BlockHitResult hit;
            block16: {
                boolean success;
                block19: {
                    Block block;
                    BlockPos pos;
                    block18: {
                        block17: {
                            block15: {
                                if (world.isClientSide) {
                                    return;
                                }
                                hit = world.clip(new ClipContext(entity.getEyePosition(), entity.getEyePosition().add(entity.getLookAngle().scale(entity.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE))), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)entity));
                                pos = hit.getBlockPos();
                                block = world.getBlockState(pos).getBlock();
                                attempt = false;
                                Random random = new Random();
                                boolean bl = success = random.nextDouble() < (Double)Config.starterSuccessChance.get();
                                if (number > 71985 || !(entity instanceof Player)) break block14;
                                simulateFlintAndSteel = false;
                                if (!(block instanceof HardcoreCampfire)) break block15;
                                HardcoreCampfire campfire = (HardcoreCampfire)block;
                                if (!((Boolean)Config.starterLightCampfires.get()).booleanValue()) break block15;
                                if (campfire.getFuel(world, pos) <= 0) {
                                    if (entity != null && entity instanceof Player) {
                                        Player player = (Player)entity;
                                        campfire.needsFuel(player);
                                    }
                                    break block16;
                                } else {
                                    attempt = true;
                                    if (success) {
                                        campfire.light(world, pos, world.getBlockState(pos));
                                    }
                                }
                                break block16;
                            }
                            if (!(block instanceof CampfireBlock) || !((Boolean)Config.starterLightCampfires.get()).booleanValue()) break block17;
                            attempt = true;
                            if (success) {
                                simulateFlintAndSteel = true;
                            }
                            break block16;
                        }
                        if (!(block instanceof AbstractHardcoreTorchBlock) || !((Boolean)Config.starterLightTorches.get()).booleanValue()) break block18;
                        if (((AbstractHardcoreTorchBlock)block).burnState != ETorchState.LIT) {
                            attempt = true;
                            if (success) {
                                ((AbstractHardcoreTorchBlock)block).light(world, pos);
                            }
                        }
                        break block16;
                    }
                    if (!(block instanceof AbstractLanternBlock) || !((Boolean)Config.starterLightLanterns.get()).booleanValue()) break block19;
                    if (((AbstractLanternBlock)block).canLight(world, pos)) {
                        attempt = true;
                        if (success) {
                            ((AbstractLanternBlock)block).light(world, pos);
                        }
                    }
                    break block16;
                }
                if (((Boolean)Config.starterStartFires.get()).booleanValue()) {
                    attempt = true;
                    if (success) {
                        simulateFlintAndSteel = true;
                    }
                }
            }
            if (simulateFlintAndSteel) {
                Items.FLINT_AND_STEEL.useOn(new UseOnContext((Player)entity, entity.getUsedItemHand(), hit));
            }
        }
        if (attempt) {
            stack.grow(-1);
        }
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        player.startUsingItem(hand);
        return super.use(world, player, hand);
    }
}

