/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.loot;

import com.github.wolfiewaffle.hardcore_torches.config.Config;
import com.github.wolfiewaffle.hardcore_torches.init.ItemInit;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public class ReplaceTorchModifier
extends LootModifier {
    public static final MapCodec<ReplaceTorchModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IGlobalLootModifier.LOOT_CONDITIONS_CODEC.fieldOf("conditions").forGetter(glm -> glm.conditions)).apply((Applicative)instance, ReplaceTorchModifier::new));

    public ReplaceTorchModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    @Nonnull
    public ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (!((Boolean)Config.replaceInLootTables.get()).booleanValue()) {
            return generatedLoot;
        }
        if (!context.getQueriedLootTableId().getPath().substring(0, 7).contains("blocks/")) {
            for (int i = 0; i < generatedLoot.size(); ++i) {
                if (((ItemStack)generatedLoot.get(i)).getItem() == Items.TORCH) {
                    generatedLoot.set(i, (Object)new ItemStack((ItemLike)ItemInit.UNLIT_TORCH.get(), ((ItemStack)generatedLoot.get(i)).getCount()));
                    continue;
                }
                if (((ItemStack)generatedLoot.get(i)).getItem() == Items.SOUL_TORCH) {
                    generatedLoot.set(i, (Object)new ItemStack((ItemLike)ItemInit.UNLIT_SOUL_TORCH.get(), ((ItemStack)generatedLoot.get(i)).getCount()));
                    continue;
                }
                if (((ItemStack)generatedLoot.get(i)).getItem() != Items.LANTERN) continue;
                generatedLoot.set(i, (Object)new ItemStack((ItemLike)ItemInit.UNLIT_LANTERN.get(), ((ItemStack)generatedLoot.get(i)).getCount()));
            }
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

