/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.loot;

import com.github.wolfiewaffle.hardcore_torches.HardcoreTorches;
import com.github.wolfiewaffle.hardcore_torches.block.AbstractHardcoreTorchBlock;
import com.github.wolfiewaffle.hardcore_torches.block.AbstractLanternBlock;
import com.github.wolfiewaffle.hardcore_torches.blockentity.FuelBlockEntity;
import com.github.wolfiewaffle.hardcore_torches.blockentity.IFuelBlock;
import com.github.wolfiewaffle.hardcore_torches.component.DataTypes;
import com.github.wolfiewaffle.hardcore_torches.util.ETorchState;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class SetFuelLootFunction
extends LootItemConditionalFunction {
    public static final MapCodec<SetFuelLootFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> SetFuelLootFunction.commonFields((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, SetFuelLootFunction::new));

    public SetFuelLootFunction(List<LootItemCondition> lootConditions) {
        super(lootConditions);
    }

    public LootItemFunctionType getType() {
        return HardcoreTorches.SET_FUEL_LOOT_FUNCTION;
    }

    protected ItemStack run(ItemStack stack, LootContext context) {
        if (!(stack.getItem() instanceof BlockItem)) {
            return stack;
        }
        if (!context.hasParam(LootContextParams.BLOCK_ENTITY)) {
            return stack;
        }
        BlockEntity blockEntity = (BlockEntity)context.getParam(LootContextParams.BLOCK_ENTITY);
        Block block = ((BlockItem)stack.getItem()).getBlock();
        if (block instanceof AbstractHardcoreTorchBlock || block instanceof AbstractLanternBlock) {
            int remainingFuel;
            if (blockEntity != null && blockEntity instanceof FuelBlockEntity && (remainingFuel = ((FuelBlockEntity)blockEntity).getFuel()) != ((IFuelBlock)block).getMaxFuel()) {
                stack.set(DataTypes.FUEL, (Object)remainingFuel);
            }
            if (block instanceof AbstractHardcoreTorchBlock && ((AbstractHardcoreTorchBlock)((BlockItem)stack.getItem()).getBlock()).burnState == ETorchState.BURNT) {
                stack.remove(DataTypes.FUEL);
            }
        }
        return stack;
    }
}

