/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.loot;

import com.github.wolfiewaffle.hardcore_torches.HardcoreTorches;
import com.github.wolfiewaffle.hardcore_torches.block.AbstractHardcoreTorchBlock;
import com.github.wolfiewaffle.hardcore_torches.config.Config;
import com.github.wolfiewaffle.hardcore_torches.util.ETorchState;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class TorchLootFunction
extends LootItemConditionalFunction {
    public static final MapCodec<TorchLootFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> TorchLootFunction.commonFields((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, TorchLootFunction::new));

    public TorchLootFunction(List<LootItemCondition> lootConditions) {
        super(lootConditions);
    }

    public LootItemFunctionType getType() {
        return HardcoreTorches.HARDCORE_TORCH_LOOT_FUNCTION;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ItemStack run(ItemStack stack, LootContext context) {
        ETorchState torchState;
        BlockState state = (BlockState)context.getParam(LootContextParams.BLOCK_STATE);
        ItemStack itemStack = new ItemStack((ItemLike)state.getBlock().asItem());
        Block block = state.getBlock();
        if (!(block instanceof AbstractHardcoreTorchBlock)) return itemStack;
        AbstractHardcoreTorchBlock torch = (AbstractHardcoreTorchBlock)block;
        ETorchState dropTorchState = torchState = torch.burnState;
        if (torch.group == HardcoreTorches.soulTorches) {
            return this.getSoulTorch(torch);
        }
        if (((Boolean)Config.torchesBurnWhenDropped.get()).booleanValue()) {
            if (dropTorchState != ETorchState.BURNT) {
                dropTorchState = ETorchState.BURNT;
            }
        } else if (((Boolean)Config.torchesExtinguishWhenBroken.get()).booleanValue() && dropTorchState != ETorchState.BURNT) {
            dropTorchState = ETorchState.UNLIT;
        }
        if (dropTorchState == ETorchState.SMOLDERING) {
            dropTorchState = ETorchState.UNLIT;
        }
        if (dropTorchState != ETorchState.BURNT) return this.getChangedStack(state, dropTorchState);
        if ((Integer)Config.burntDrop.get() == 0) {
            return this.getChangedStack(state, dropTorchState);
        }
        if ((Integer)Config.burntDrop.get() != 1) return ItemStack.EMPTY;
        return new ItemStack((ItemLike)Items.STICK, 1);
    }

    private ItemStack getSoulTorch(AbstractHardcoreTorchBlock torch) {
        return new ItemStack((ItemLike)torch.asItem());
    }

    private ItemStack getChangedStack(BlockState state, ETorchState torchState) {
        return new ItemStack((ItemLike)((AbstractHardcoreTorchBlock)state.getBlock()).group.getStandingTorch(torchState).asItem());
    }
}

