/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.util;

import com.github.wolfiewaffle.hardcore_torches.blockentity.IFuelBlock;
import com.github.wolfiewaffle.hardcore_torches.blockentity.IFuelBlockEntity;
import com.github.wolfiewaffle.hardcore_torches.config.Config;
import com.github.wolfiewaffle.hardcore_torches.init.ItemInit;
import com.github.wolfiewaffle.hardcore_torches.item.OilCanItem;
import com.github.wolfiewaffle.hardcore_torches.util.ETorchState;
import com.github.wolfiewaffle.hardcore_torches.util.SoulAttunement;
import com.github.wolfiewaffle.hardcore_torches.util.TorchTools;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class LanternTools {
    public static ItemInteractionResult basicAttemptLight(Level world, BlockPos pos, Player player, ItemStack stack, InteractionHand hand) {
        boolean isSoul = false;
        Block block = world.getBlockState(pos).getBlock();
        if (block instanceof IFuelBlock) {
            IFuelBlock lantern = (IFuelBlock)block;
            isSoul = lantern.isSoulVariant();
        }
        if ((block = world.getBlockState(pos).getBlock()) instanceof IFuelBlock) {
            IFuelBlock block2 = (IFuelBlock)block;
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof IFuelBlockEntity) {
                IFuelBlockEntity fuelBlockEntity = (IFuelBlockEntity)blockEntity;
                if (!world.isClientSide) {
                    if (fuelBlockEntity.getFuel() < (Integer)Config.minLanternIgnitionFuel.get()) {
                        world.playSound(null, pos, SoundEvents.LANTERN_HIT, SoundSource.BLOCKS, 1.0f, 1.0f);
                        if (!isSoul) {
                            player.displayClientMessage((Component)Component.literal((String)"Needs fuel from an Oil Can"), true);
                        } else {
                            player.displayClientMessage((Component)Component.literal((String)"Needs XP from an Amethyst Shard"), true);
                        }
                    } else if (block2.attemptUseItem(stack, player, hand, ETorchState.LIT)) {
                        block2.light(world, pos);
                    }
                }
            }
        }
        player.swing(hand);
        return ItemInteractionResult.SUCCESS;
    }

    public static InteractionResult interactLanternEmpty(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand) {
        boolean showFuel;
        ItemStack stack = player.getItemInHand(hand);
        if (!(world.getBlockEntity(pos) instanceof IFuelBlockEntity)) {
            return InteractionResult.FAIL;
        }
        IFuelBlockEntity fuelBlockEntity = (IFuelBlockEntity)world.getBlockEntity(pos);
        if (!(state.getBlock() instanceof IFuelBlock)) {
            return InteractionResult.FAIL;
        }
        IFuelBlock block = (IFuelBlock)state.getBlock();
        if (player.isCrouching() && ((Boolean)Config.pickUpLanterns.get()).booleanValue()) {
            LanternTools.pickup(player, world, pos, block, hand);
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)Config.handUnlightLantern.get()).booleanValue() && block.isLit() && !TorchTools.canLight(stack.getItem(), state.getBlock().defaultBlockState())) {
            block.extinguish(world, pos, state, true);
            return InteractionResult.SUCCESS;
        }
        boolean bl = showFuel = (stack.isEmpty() || stack.getItem() == ItemInit.OIL_CAN.get()) && (Boolean)Config.fuelMessage.get() != false;
        if (hand == InteractionHand.MAIN_HAND && !world.isClientSide && showFuel) {
            player.displayClientMessage((Component)Component.literal((String)("Fuel: " + fuelBlockEntity.getFuel())), true);
        }
        return InteractionResult.PASS;
    }

    public static ItemInteractionResult interactLantern(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand) {
        boolean showFuel;
        ItemStack stack = player.getItemInHand(hand);
        if (!(world.getBlockEntity(pos) instanceof IFuelBlockEntity)) {
            return ItemInteractionResult.FAIL;
        }
        IFuelBlockEntity fuelBlockEntity = (IFuelBlockEntity)world.getBlockEntity(pos);
        if (!(state.getBlock() instanceof IFuelBlock)) {
            return ItemInteractionResult.FAIL;
        }
        IFuelBlock block = (IFuelBlock)state.getBlock();
        boolean isSoul = false;
        Block block2 = state.getBlock();
        if (block2 instanceof IFuelBlock) {
            IFuelBlock lantern = (IFuelBlock)block2;
            isSoul = lantern.isSoulVariant();
        }
        if (player.isCrouching() && ((Boolean)Config.pickUpLanterns.get()).booleanValue()) {
            LanternTools.pickup(player, world, pos, block, hand);
            return ItemInteractionResult.SUCCESS;
        }
        if (!block.isLit() && block.itemValid(stack, ETorchState.LIT)) {
            return block.attemptLight(world, pos, state, player, stack, hand);
        }
        if (((Boolean)Config.handUnlightLantern.get()).booleanValue() && block.isLit() && !TorchTools.canLight(stack.getItem(), state.getBlock().defaultBlockState())) {
            block.extinguish(world, pos, state, true);
            return ItemInteractionResult.SUCCESS;
        }
        boolean bl = showFuel = (stack.isEmpty() || stack.getItem() == ItemInit.OIL_CAN.get()) && (Boolean)Config.fuelMessage.get() != false;
        if (hand == InteractionHand.MAIN_HAND && !world.isClientSide && showFuel) {
            player.displayClientMessage((Component)Component.literal((String)("Fuel: " + fuelBlockEntity.getFuel())), true);
        }
        if (isSoul) {
            return SoulAttunement.soulAttune(world, pos, fuelBlockEntity, block, player, hand);
        }
        if (stack.is(ItemTags.COALS) && !((Boolean)Config.lanternsNeedCan.get()).booleanValue()) {
            if (!world.isClientSide) {
                int oldFuel = fuelBlockEntity.getFuel();
                if (fuelBlockEntity.canAddFuel()) {
                    if (oldFuel + (Integer)Config.defLanternFuelItem.get() < block.getMaxFuel()) {
                        world.playSound(null, pos, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                    } else {
                        world.playSound(null, pos, SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    stack.grow(-1);
                    fuelBlockEntity.setFuel(Math.min(oldFuel + (Integer)Config.defLanternFuelItem.get(), block.getMaxFuel()));
                }
            }
            player.swing(hand);
            return ItemInteractionResult.SUCCESS;
        }
        if (stack.getItem() instanceof OilCanItem && ((Boolean)Config.lanternsNeedCan.get()).booleanValue()) {
            if (!world.isClientSide && OilCanItem.fuelBlock(fuelBlockEntity, world, stack)) {
                world.playSound(null, pos, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            player.swing(hand);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public static void pickup(Player player, Level world, BlockPos pos, IFuelBlock block, InteractionHand hand) {
        if (!world.isClientSide) {
            player.addItem(block.getStack(world, pos));
            world.playSound(null, pos, SoundEvents.LANTERN_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        player.swing(hand);
    }
}

