/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.util;

import com.github.wolfiewaffle.hardcore_torches.HardcoreTorches;
import com.github.wolfiewaffle.hardcore_torches.blockentity.IFuelBlock;
import com.github.wolfiewaffle.hardcore_torches.blockentity.IFuelBlockEntity;
import com.github.wolfiewaffle.hardcore_torches.config.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ExperienceBottleItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SoulAttunement {
    public static ItemInteractionResult soulAttune(Level world, BlockPos pos, IFuelBlockEntity fuelBlockEntity, IFuelBlock fuelBlock, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.getItem() instanceof ExperienceBottleItem) {
            if (!world.isClientSide) {
                int oldFuel = fuelBlockEntity.getFuel();
                if (fuelBlockEntity.canAddFuel()) {
                    if (oldFuel + (Integer)Config.defLanternFuelItem.get() < fuelBlock.getMaxFuel()) {
                        world.playSound(null, pos, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                    } else {
                        world.playSound(null, pos, SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    stack.grow(-1);
                    fuelBlockEntity.setFuel((int)((double)oldFuel + (double)((Integer)Config.bottleExpAmount.get()).intValue() * (Double)Config.soulExpRatio.get()));
                    SoulAttunement.displaySpirit(player, fuelBlockEntity.getFuel());
                }
            }
            player.swing(hand);
            return ItemInteractionResult.SUCCESS;
        }
        if (stack.is(HardcoreTorches.SOUL_ITEMS)) {
            if (!world.isClientSide) {
                int xp = SoulAttunement.getTotalXP(player);
                int maxIncrement = Math.min(xp, (Integer)Config.expIncrement.get());
                int emptySpace = Math.max(0, fuelBlockEntity.getMaxFuel() - fuelBlockEntity.getFuel());
                int addAmount = Math.min(emptySpace, (int)((double)maxIncrement * (Double)Config.soulExpRatio.get()));
                int takeAmount = (int)Math.max(0.0, Math.ceil((double)addAmount / (Double)Config.soulExpRatio.get()));
                if (xp > 0) {
                    if (addAmount > 0 && fuelBlockEntity.canAddFuel()) {
                        fuelBlockEntity.setFuel(fuelBlockEntity.getFuel() + addAmount);
                        player.giveExperiencePoints(-takeAmount);
                        world.playSound(null, pos, SoundEvents.BOTTLE_FILL_DRAGONBREATH, SoundSource.BLOCKS, 1.0f, 1.0f);
                        SoulAttunement.displaySpirit(player, fuelBlockEntity.getFuel());
                    }
                } else {
                    player.displayClientMessage((Component)Component.literal((String)"You don't have enough XP!"), true);
                }
            }
            player.swing(hand);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.SUCCESS;
    }

    public static void displaySpirit(Player player, int amount) {
        player.displayClientMessage((Component)Component.literal((String)("Spirit: " + amount)), true);
    }

    private static int getTotalXP(Player player) {
        int level = player.experienceLevel;
        int levelTotal = 0;
        if (level >= 1 && level <= 16) {
            levelTotal = (int)(Math.pow(level, 2.0) + (double)(6 * level));
        } else if (level >= 17 && level <= 31) {
            levelTotal = (int)(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0);
        } else if (level >= 32) {
            levelTotal = (int)(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0);
        }
        return levelTotal + player.totalExperience;
    }
}

