/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.core;

import forestry.api.ForestryTags;
import java.util.List;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;

public enum HumidityType {
    ARID(ForestryTags.Biomes.ARID_HUMIDITY, 11194587),
    NORMAL(ForestryTags.Biomes.NORMAL_HUMIDITY, 4946943),
    DAMP(ForestryTags.Biomes.DAMP_HUMIDITY, 7231155);

    public static final List<HumidityType> VALUES;
    public final TagKey<Biome> tag;
    public final int color;

    private HumidityType(TagKey<Biome> tag, int color) {
        this.tag = tag;
        this.color = color;
    }

    public HumidityType up() {
        return this.up(1);
    }

    public HumidityType up(int steps) {
        return VALUES.get(Mth.m_14045_((int)(this.ordinal() + steps), (int)0, (int)2));
    }

    public HumidityType down() {
        return this.down(1);
    }

    public HumidityType down(int steps) {
        return VALUES.get(Mth.m_14045_((int)(this.ordinal() - steps), (int)0, (int)2));
    }

    public boolean isWetterOrEqual(HumidityType other) {
        return this.ordinal() >= other.ordinal();
    }

    public boolean isDrierOrEqual(HumidityType other) {
        return this.ordinal() <= other.ordinal();
    }

    public static HumidityType getFromValue(float downfall) {
        if (downfall > 0.85f) {
            return DAMP;
        }
        if (downfall >= 0.3f) {
            return NORMAL;
        }
        return ARID;
    }

    static {
        VALUES = List.of(HumidityType.values());
    }
}

