/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.genetics;

import forestry.api.core.HumidityType;
import forestry.api.core.TemperatureType;
import forestry.api.core.ToleranceType;
import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ClimateHelper {
    public static int getColor(TemperatureType temperature) {
        return switch (temperature) {
            default -> throw new IncompatibleClassChangeError();
            case TemperatureType.ICY -> 15132410;
            case TemperatureType.COLD -> 3238282;
            case TemperatureType.NORMAL -> 15788492;
            case TemperatureType.WARM -> 13474589;
            case TemperatureType.HOT -> 14635310;
            case TemperatureType.HELLISH -> 10240830;
        };
    }

    public static boolean isWithinLimits(TemperatureType temperature, HumidityType humidity, TemperatureType idealTemp, ToleranceType temperatureTolerance, HumidityType idealHumidity, ToleranceType humidityTolerance) {
        return ClimateHelper.isWithinLimits(temperature, idealTemp, temperatureTolerance) && ClimateHelper.isWithinLimits(humidity, idealHumidity, humidityTolerance);
    }

    public static boolean isWithinLimits(TemperatureType temperature, TemperatureType idealTemp, ToleranceType tolerance) {
        TemperatureType max = idealTemp.up(tolerance.up);
        TemperatureType min = idealTemp.down(tolerance.down);
        return temperature.isWarmerOrEqual(min) && temperature.isCoolerOrEqual(max);
    }

    public static boolean isWithinLimits(HumidityType humidity, HumidityType idealHumidity, ToleranceType tolerance) {
        HumidityType max = idealHumidity.up(tolerance.up);
        HumidityType min = idealHumidity.down(tolerance.down);
        return humidity.isWetterOrEqual(min) && humidity.isDrierOrEqual(max);
    }

    public static MutableComponent toDisplay(TemperatureType temperature) {
        return Component.m_237115_((String)("for.gui." + temperature.toString().toLowerCase(Locale.ENGLISH)));
    }

    public static MutableComponent toDisplay(HumidityType humidity) {
        return Component.m_237115_((String)("for.gui." + humidity.toString().toLowerCase(Locale.ENGLISH)));
    }
}

