/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.commands;

import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.IApiaristTracker;
import forestry.api.apiculture.genetics.IBeeSpecies;
import forestry.api.apiculture.genetics.IBeeSpeciesType;
import forestry.api.genetics.IBreedingTracker;
import forestry.core.commands.IStatsSaveHelper;
import forestry.core.utils.SpeciesUtil;
import java.util.Collection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class BeeStatsSaveHelper
implements IStatsSaveHelper {
    @Override
    public String getTranslationKey() {
        return "for.chat.command.forestry.bee.save.stats";
    }

    @Override
    public void addExtraInfo(Collection<Component> statistics, IBreedingTracker breedingTracker) {
        IApiaristTracker tracker = (IApiaristTracker)breedingTracker;
        MutableComponent discoveredLine = Component.m_237115_((String)"for.chat.command.forestry.stats.save.key.discovered").m_130946_(":");
        statistics.add((Component)discoveredLine);
        MutableComponent queen = Component.m_237115_((String)"for.bees.grammar.queen.type");
        MutableComponent princess = Component.m_237115_((String)"for.bees.grammar.princess.type");
        MutableComponent drone = Component.m_237115_((String)"for.bees.grammar.drone.type");
        statistics.add((Component)queen.m_130946_(":\t\t" + tracker.getQueenCount()));
        statistics.add((Component)princess.m_130946_(":\t" + tracker.getPrincessCount()));
        statistics.add((Component)drone.m_130946_(":\t\t" + tracker.getDroneCount()));
        statistics.add((Component)Component.m_237113_((String)""));
    }

    public Collection<IBeeSpecies> getSpecies() {
        return SpeciesUtil.getAllBeeSpecies();
    }

    @Override
    public String getFileSuffix() {
        return "bees";
    }

    @Override
    public IBreedingTracker getBreedingTracker(Level level, GameProfile gameProfile) {
        return ((IBeeSpeciesType)SpeciesUtil.BEE_TYPE.get()).getBreedingTracker((LevelAccessor)level, gameProfile);
    }
}

