/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.compat;

import forestry.api.genetics.ISpecies;
import forestry.api.genetics.ISpeciesType;
import forestry.apiculture.compat.MutationsRecipeCategory;
import forestry.apiculture.compat.ProductRecipe;
import forestry.core.utils.JeiUtil;
import forestry.core.utils.ModUtil;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenCustomHashMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class ProductsRecipeCategory
implements IRecipeCategory<ProductRecipe> {
    private static final int SPECIES_SLOT_X = 30;
    private static final int SPECIES_SLOT_Y = 16;
    private static final int PRODUCT_SLOTS_X = 93;
    private static final int PRODUCT_SLOTS_Y = 5;
    private static final int SPECIALTY_SLOTS_Y = 33;
    private final IDrawable icon;
    private final IDrawable background;
    private final RecipeType<ProductRecipe> type;
    private final Component title;
    final ISpeciesType<? extends ISpecies<?>, ?> speciesType;

    ProductsRecipeCategory(ISpeciesType<?, ?> type, IDrawable background, IDrawable icon) {
        this.background = background;
        this.icon = icon;
        this.speciesType = type;
        this.type = new RecipeType(ModUtil.withSuffix(type.id(), "_products"), ProductRecipe.class);
        this.title = Component.m_237115_((String)("for.jei.products." + type.id().m_135827_() + "." + type.id().m_135815_()));
    }

    public RecipeType<ProductRecipe> getRecipeType() {
        return this.type;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ProductRecipe recipe, IFocusGroup focuses) {
        builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStacks(recipe.inputs);
        builder.addSlot(RecipeIngredientRole.INPUT, 30, 16).addItemStack(MutationsRecipeCategory.createAnalyzedStack(this.speciesType.getTypeForMutation(2), recipe.species, null));
        if (recipe.products != null) {
            ProductsRecipeCategory.setProductsList(builder, recipe.products, 5);
        }
        if (recipe.specialties != null) {
            ProductsRecipeCategory.setProductsList(builder, recipe.specialties, 33);
        }
    }

    private static void setProductsList(IRecipeLayoutBuilder builder, Object2FloatOpenCustomHashMap<ItemStack> productStacks, int slotsY) {
        IRecipeSlotTooltipCallback callback = (view, tooltip) -> view.getDisplayedItemStack().ifPresent(stack -> {
            if (productStacks.containsKey(stack)) {
                tooltip.add(JeiUtil.formatChance(productStacks.getFloat(stack)));
            }
        });
        int products = productStacks.size();
        LinkedList<ItemStack> productsList = new LinkedList<ItemStack>((Collection<ItemStack>)productStacks.keySet());
        productsList.sort(Comparator.comparingDouble(productStacks).reversed());
        if (products <= 3) {
            for (int i = 0; i < products; ++i) {
                ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 93 + i * 22, slotsY).addItemStack((ItemStack)productsList.get(i))).addTooltipCallback(callback);
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 93 + i * 22, slotsY).addItemStacks(productsList)).addTooltipCallback(callback);
                productsList.addLast((ItemStack)productsList.removeFirst());
            }
        }
    }

    public void draw(ProductRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        JeiUtil.drawCenteredMulti(graphics, (Component)recipe.species.getDisplayName(), 39.0f, 38.0f, 0xFFFFFF);
    }
}

