/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.effects;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IGenome;
import forestry.apiculture.genetics.effects.ThrottledBeeEffect;
import forestry.core.render.ParticleRender;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class IgnitionBeeEffect
extends ThrottledBeeEffect {
    private static final int ignitionChance = 50;
    private static final int fireDuration = 500;

    public IgnitionBeeEffect() {
        super(false, 20, false, true);
    }

    @Override
    public IEffectData doEffectThrottled(IGenome genome, IEffectData storedData, IBeeHousing housing) {
        Level level = housing.getWorldObj();
        List<LivingEntity> entities = ThrottledBeeEffect.getEntitiesInRange(genome, housing, LivingEntity.class);
        for (LivingEntity entity : entities) {
            int chance = 50;
            int duration = 500;
            int count = BeeManager.armorApiaristHelper.wearsItems(entity, this, true);
            if (count > 3) continue;
            if (count > 2) {
                chance = 5;
                duration = 50;
            } else if (count > 1) {
                chance = 20;
                duration = 200;
            } else if (count > 0) {
                chance = 35;
                duration = 350;
            }
            if (level.f_46441_.m_188503_(1000) >= chance) continue;
            entity.m_20254_(duration);
        }
        return storedData;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IEffectData doFX(IGenome genome, IEffectData storedData, IBeeHousing housing) {
        ClientLevel level = (ClientLevel)housing.getWorldObj();
        if (level.f_46441_.m_188503_(2) != 0) {
            super.doFX(genome, storedData, housing);
        } else {
            Vec3 beeFXCoordinates = housing.getBeeFXCoordinates();
            ParticleRender.addEntityIgnitionFX(level, beeFXCoordinates.f_82479_, beeFXCoordinates.f_82480_ + 0.5, beeFXCoordinates.f_82481_);
        }
        return storedData;
    }
}

