/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.effects;

import forestry.api.apiculture.IBeeHousing;
import forestry.api.core.TemperatureType;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IGenome;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.effects.ThrottledBeeEffect;
import forestry.core.render.ParticleRender;
import forestry.core.utils.VecUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SnowingBeeEffect
extends ThrottledBeeEffect {
    public SnowingBeeEffect() {
        super(false, 20, true, true);
    }

    @Override
    public IEffectData doEffectThrottled(IGenome genome, IEffectData storedData, IBeeHousing housing) {
        Level level = housing.getWorldObj();
        if (housing.temperature().isWarmerOrEqual(TemperatureType.WARM)) {
            return storedData;
        }
        Vec3i area = Bee.getParticleArea(genome, housing);
        BlockPos randomPos = VecUtil.getRandomPositionInArea(level.f_46441_, area);
        BlockPos posBlock = randomPos.m_121955_((Vec3i)housing.getCoordinates()).m_121955_(VecUtil.center(area));
        if (level.m_46805_(posBlock)) {
            BlockState state = level.m_8055_(posBlock);
            Block block = state.m_60734_();
            if (!state.m_60795_() && block != Blocks.f_50125_ || !Blocks.f_50125_.m_49966_().m_60710_((LevelReader)level, posBlock)) {
                return storedData;
            }
            if (block == Blocks.f_50125_) {
                int layers = (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_);
                if (layers < 7) {
                    BlockState moreSnow = (BlockState)state.m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(layers + 1));
                    level.m_46597_(posBlock, moreSnow);
                } else {
                    level.m_46597_(posBlock, Blocks.f_50125_.m_49966_());
                }
            } else if (block.m_49966_().m_247087_()) {
                level.m_46597_(posBlock, Blocks.f_50125_.m_49966_());
            }
        }
        return storedData;
    }

    @Override
    public IEffectData doFX(IGenome genome, IEffectData storedData, IBeeHousing housing) {
        Level level = housing.getWorldObj();
        if (level.f_46441_.m_188503_(3) == 0) {
            Vec3i area = Bee.getParticleArea(genome, housing);
            BlockPos coordinates = housing.getCoordinates();
            BlockPos spawn = VecUtil.getRandomPositionInArea(level.f_46441_, area).m_121955_((Vec3i)coordinates).m_121955_(VecUtil.center(area));
            ParticleRender.addEntitySnowFX(level, spawn.m_123341_(), spawn.m_123342_(), spawn.m_123343_());
            return storedData;
        }
        return super.doFX(genome, storedData, housing);
    }
}

