/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.hives;

import forestry.api.IForestryApi;
import forestry.api.apiculture.hives.IHive;
import forestry.api.core.HumidityType;
import forestry.api.core.TemperatureType;
import forestry.core.config.ForestryConfig;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class HiveDecorator
extends Feature<NoneFeatureConfiguration> {
    public HiveDecorator() {
        super(NoneFeatureConfiguration.f_67815_);
    }

    public static boolean tryGenHive(WorldGenLevel world, RandomSource rand, int posX, int posZ, IHive hive) {
        BlockPos hivePos = hive.getPosForHive(world, rand, posX, posZ);
        if (hivePos == null) {
            return false;
        }
        if (!hive.canReplace(world, hivePos)) {
            return false;
        }
        Holder biome = world.m_204166_(hivePos);
        TemperatureType temperature = IForestryApi.INSTANCE.getClimateManager().getTemperature((Holder<Biome>)biome);
        HumidityType humidity = IForestryApi.INSTANCE.getClimateManager().getHumidity((Holder<Biome>)biome);
        if (temperature == null) {
            System.out.println(biome.getClass());
            System.out.println(biome.m_203543_());
            System.out.println(biome.get());
        }
        if (!(hive.isGoodBiome((Holder<Biome>)biome) && hive.isGoodTemperature(temperature) && hive.isGoodHumidity(humidity))) {
            return false;
        }
        if (!hive.isValidLocation(world, hivePos)) {
            return false;
        }
        return HiveDecorator.setHive(world, rand, hivePos, hive);
    }

    private static boolean setHive(WorldGenLevel level, RandomSource rand, BlockPos pos, IHive hive) {
        BlockState hiveState = hive.getHiveBlockState();
        Block hiveBlock = hiveState.m_60734_();
        boolean placed = level.m_7731_(pos, hiveState, 2);
        if (!placed) {
            return false;
        }
        BlockState state = level.m_8055_(pos);
        Block placedBlock = state.m_60734_();
        if (hiveBlock != placedBlock) {
            return false;
        }
        hive.postGen(level, rand, pos);
        return true;
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        RandomSource rand = context.m_225041_();
        BlockPos pos = context.m_159777_();
        ObjectArrayList hives = new ObjectArrayList(IForestryApi.INSTANCE.getHiveManager().getHives());
        int numTries = (int)Math.ceil((float)hives.size() / 2.0f);
        double baseChance = (Double)ForestryConfig.SERVER.wildHiveSpawnRate.get() * (double)hives.size() / 8.0;
        Util.m_214673_((ObjectArrayList)hives, (RandomSource)rand);
        for (int tries = 0; tries < numTries; ++tries) {
            for (IHive hive : hives) {
                int posZ;
                int posX;
                if (!((double)hive.genChance() * baseChance >= (double)(rand.m_188501_() * 100.0f)) || !HiveDecorator.tryGenHive(level, rand, posX = pos.m_123341_() + rand.m_188503_(16), posZ = pos.m_123343_() + rand.m_188503_(16), hive)) continue;
                return true;
            }
        }
        return false;
    }
}

