/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.arboriculture.IWoodTyped;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class BlockForestryFenceGate
extends FenceGateBlock
implements IWoodTyped {
    private final boolean fireproof;
    private final IWoodType woodType;

    public BlockForestryFenceGate(boolean fireproof, IWoodType woodType) {
        super(BlockBehaviour.Properties.m_284310_().m_60913_(woodType.getHardness(), woodType.getHardness() * 1.5f).m_60918_(SoundType.f_56736_), woodType.getFenceGateOpenSound(), woodType.getFenceGateCloseSound());
        this.fireproof = fireproof;
        this.woodType = woodType;
    }

    @Override
    public boolean isFireproof() {
        return this.fireproof;
    }

    @Override
    public IWoodType getWoodType() {
        return this.woodType;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (this.fireproof) {
            return 0;
        }
        return 20;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (this.fireproof) {
            return 0;
        }
        return 5;
    }

    @Override
    public WoodBlockKind getBlockKind() {
        return WoodBlockKind.FENCE_GATE;
    }
}

