/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.charcoal.jei;

import forestry.api.ForestryConstants;
import forestry.api.arboriculture.ICharcoalPileWall;
import forestry.arboriculture.charcoal.jei.CharcoalJeiPlugin;
import forestry.arboriculture.features.CharcoalBlocks;
import forestry.core.features.CoreItems;
import forestry.core.recipes.jei.ForestryRecipeCategory;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class CharcoalPileWallCategory
extends ForestryRecipeCategory<ICharcoalPileWall> {
    private final IDrawableStatic slot;
    private final IDrawableStatic arrow;
    private final IDrawableAnimated arrowAnimated;
    private final IDrawableStatic flame;
    private final IDrawableAnimated flameAnimated;
    private final IDrawable icon;

    public CharcoalPileWallCategory(IGuiHelper helper) {
        super((IDrawable)helper.createBlankDrawable(120, 38), "for.jei.charcoal.pile");
        ResourceLocation resourceLocation = ForestryConstants.forestry("textures/gui/jei/recipes.png");
        this.arrow = helper.createDrawable(resourceLocation, 0, 14, 22, 16);
        IDrawableStatic arrowAnimated = helper.createDrawable(resourceLocation, 22, 14, 22, 16);
        this.arrowAnimated = helper.createAnimatedDrawable(arrowAnimated, 160, IDrawableAnimated.StartDirection.LEFT, false);
        this.flame = helper.createDrawable(resourceLocation, 0, 0, 14, 14);
        IDrawableStatic flameAnimated = helper.createDrawable(resourceLocation, 14, 0, 14, 14);
        this.flameAnimated = helper.createAnimatedDrawable(flameAnimated, 260, IDrawableAnimated.StartDirection.TOP, true);
        this.slot = helper.getSlotDrawable();
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)CharcoalBlocks.LOG_PILE.stack());
    }

    public RecipeType<ICharcoalPileWall> getRecipeType() {
        return CharcoalJeiPlugin.RECIPE_TYPE;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(ICharcoalPileWall recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        this.flame.draw(graphics, 52, 0);
        this.flameAnimated.draw(graphics, 52, 0);
        this.arrow.draw(graphics, 50, 16);
        this.arrowAnimated.draw(graphics, 50, 16);
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, ICharcoalPileWall recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 17).setBackground((IDrawable)this.slot, -1, -1).addItemStacks(recipe.getDisplayItems());
        builder.addSlot(RecipeIngredientRole.INPUT, 21, 17).setBackground((IDrawable)this.slot, -1, -1).addItemStack(CharcoalBlocks.LOG_PILE.stack());
        int amount = 9 + recipe.getCharcoalAmount();
        ItemStack coal = new ItemStack((ItemLike)Items.f_42414_, amount);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 85, 17).setBackground((IDrawable)this.slot, -1, -1).addItemStack(coal);
        ItemStack ash = CoreItems.ASH.stack(amount / 4);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 105, 17).setBackground((IDrawable)this.slot, -1, -1).addItemStack(ash);
    }
}

