/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.arboriculture.ITreeGenData;
import forestry.arboriculture.worldgen.FeatureTree;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.TreeContour;
import forestry.core.worldgen.FeatureHelper;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;

public class FeatureChestnut
extends FeatureTree {
    public FeatureChestnut(ITreeGenData tree) {
        super(tree, 7, 3);
    }

    @Override
    public Set<BlockPos> generateTrunk(LevelAccessor level, RandomSource rand, TreeBlockTypeLog wood, BlockPos startPos) {
        FeatureHelper.generateTreeTrunk(level, rand, wood, startPos, this.height, this.girth, 0, 0.0f, null, 0.0f);
        int branchHeight = 4;
        if (rand.m_188499_()) {
            --branchHeight;
        }
        int branchRadius = this.height / 2;
        return FeatureHelper.generateBranches(level, rand, wood, startPos.m_7918_(0, branchHeight, 0), this.girth, 0.5f, 0.5f, branchRadius, 2, 1.0f);
    }

    @Override
    protected void generateLeaves(LevelAccessor level, RandomSource rand, TreeBlockTypeLeaf leaf, TreeContour contour, BlockPos startPos) {
        int leafSpawn = this.height + 1;
        FeatureHelper.generateCylinderFromTreeStartPos(level, leaf, startPos.m_7918_(0, leafSpawn--, 0), this.girth, this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        FeatureHelper.generateCylinderFromTreeStartPos(level, leaf, startPos.m_7918_(0, leafSpawn--, 0), this.girth, 0.5f + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        while (leafSpawn > 4) {
            FeatureHelper.generateCylinderFromTreeStartPos(level, leaf, startPos.m_7918_(0, leafSpawn--, 0), this.girth, 2.0f + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        }
        if (rand.m_188499_()) {
            FeatureHelper.generateCylinderFromTreeStartPos(level, leaf, startPos.m_7918_(0, leafSpawn--, 0), this.girth, 2.0f + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        }
        for (BlockPos branchEnd : contour.getBranchEnds()) {
            FeatureHelper.generateCylinderFromPos(level, leaf, branchEnd, 1.0f + (float)this.girth, 2, FeatureHelper.EnumReplaceMode.AIR, contour);
        }
        FeatureHelper.generateCylinderFromTreeStartPos(level, leaf, startPos.m_7918_(0, leafSpawn, 0), this.girth, 1.5f + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
    }
}

