/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.arboriculture.ITreeGenData;
import forestry.arboriculture.worldgen.FeatureTree;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.TreeContour;
import forestry.core.worldgen.FeatureHelper;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;

public class FeatureSequoia
extends FeatureTree {
    public FeatureSequoia(ITreeGenData tree) {
        this(tree, 20, 5);
    }

    protected FeatureSequoia(ITreeGenData tree, int baseHeight, int heightVariation) {
        super(tree, baseHeight, heightVariation);
    }

    @Override
    public Set<BlockPos> generateTrunk(LevelAccessor level, RandomSource rand, TreeBlockTypeLog wood, BlockPos startPos) {
        FeatureHelper.generateTreeTrunk(level, rand, wood, startPos, this.height, this.girth, 0, 0.0f, null, 0.0f);
        FeatureHelper.generateSupportStems(wood, level, rand, startPos, this.height, this.girth, 0.4f, 0.4f);
        int topHeight = this.height / 3 + rand.m_188503_(this.height / 6);
        HashSet<BlockPos> branchCoords = new HashSet<BlockPos>();
        for (int yBranch = topHeight; yBranch < this.height; ++yBranch) {
            int branchLength = Math.round(this.height - yBranch) / 2;
            if (branchLength > 4) {
                branchLength = 4;
            }
            branchCoords.addAll(FeatureHelper.generateBranches(level, rand, wood, startPos.m_7918_(0, yBranch, 0), this.girth, 0.05f, 0.25f, branchLength, 1, 0.5f));
        }
        return branchCoords;
    }

    @Override
    protected void generateLeaves(LevelAccessor level, RandomSource rand, TreeBlockTypeLeaf leaf, TreeContour contour, BlockPos startPos) {
        for (BlockPos branchEnd : contour.getBranchEnds()) {
            FeatureHelper.generateCylinderFromPos(level, leaf, branchEnd, 1.0f + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.AIR, contour);
        }
        int leafSpawn = this.height + 2;
        FeatureHelper.generateCylinderFromTreeStartPos(level, leaf, startPos.m_7918_(0, leafSpawn--, 0), this.girth, this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        FeatureHelper.generateCylinderFromTreeStartPos(level, leaf, startPos.m_7918_(0, leafSpawn--, 0), this.girth, 1 + this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        FeatureHelper.generateCylinderFromTreeStartPos(level, leaf, startPos.m_7918_(0, leafSpawn--, 0), this.girth, 1 + this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        int topHeight = this.height / 3 + rand.m_188503_(this.height / 6);
        while (leafSpawn > topHeight) {
            FeatureHelper.generateCylinderFromTreeStartPos(level, leaf, startPos.m_7918_(0, leafSpawn--, 0), this.girth, 1 + this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        }
        FeatureHelper.generateCylinderFromTreeStartPos(level, leaf, startPos.m_7918_(0, leafSpawn, 0), this.girth, this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
    }
}

