/*
 * Decompiled with CFR 0.152.
 */
package forestry.compat.patchouli.component;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.ICustomComponent;
import vazkii.patchouli.api.IVariable;

public class FluidComponent
implements ICustomComponent {
    public IVariable fluid;
    public IVariable amount;
    public IVariable max;
    public IVariable width;
    public IVariable height;
    private transient int x;
    private transient int y;
    private transient int w;
    private transient int h;
    private transient int level;
    private transient int maxLevel;
    private transient FluidStack fluidStack;

    public void build(int componentX, int componentY, int pageNum) {
        this.x = componentX;
        this.y = componentY;
    }

    public void render(GuiGraphics graphics, IComponentRenderContext context, float pticks, int mouseX, int mouseY) {
        PoseStack stack = graphics.m_280168_();
        stack.m_85836_();
        IClientFluidTypeExtensions fluidAttributes = IClientFluidTypeExtensions.of((Fluid)this.fluidStack.getFluid());
        ResourceLocation fluidStill = fluidAttributes.getStillTexture(this.fluidStack);
        if (fluidStill != null) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidStill);
            ResourceLocation spriteLocation = sprite.m_245424_().m_246162_();
            ResourceLocation fluidTexture = new ResourceLocation(spriteLocation.m_135827_(), "textures/" + spriteLocation.m_135815_() + ".png");
            FluidComponent.setGLColorFromInt(fluidAttributes.getTintColor(this.fluidStack));
            graphics.m_280163_(fluidTexture, this.x, (int)((double)(this.y + this.h) - Math.floor((float)this.h * ((float)this.level / (float)this.maxLevel))), sprite.m_118409_(), sprite.m_118411_(), this.w, this.h * this.level / this.maxLevel, 8, 8);
            if (context.isAreaHovered(mouseX, mouseY, this.x, this.y, this.w, this.h)) {
                ArrayList<Object> toolTips = new ArrayList<Object>();
                toolTips.add(this.fluidStack.getDisplayName());
                toolTips.add(Component.m_237110_((String)"for.gui.tooltip.liquid.amount", (Object[])new Object[]{this.level, this.maxLevel}));
                context.setHoverTooltipComponents(toolTips);
            }
        }
        stack.m_85849_();
    }

    public void onVariablesAvailable(UnaryOperator<IVariable> lookup) {
        ResourceLocation id = new ResourceLocation(((IVariable)lookup.apply(this.fluid)).asString());
        int mb = ((IVariable)lookup.apply(this.amount)).asNumber().intValue();
        try {
            this.fluidStack = new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(id), mb);
        }
        catch (Exception e) {
            this.fluidStack = FluidStack.EMPTY;
        }
        this.w = ((IVariable)lookup.apply(this.width)).asNumber().intValue();
        this.h = ((IVariable)lookup.apply(this.height)).asNumber().intValue();
        this.level = ((IVariable)lookup.apply(this.amount)).asNumber().intValue();
        this.maxLevel = ((IVariable)lookup.apply(this.max)).asNumber().intValue();
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)1.0f);
    }
}

