/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.alleles.AllelePair;
import forestry.api.genetics.alleles.IAllele;
import forestry.api.genetics.alleles.IChromosome;
import forestry.api.genetics.alleles.IKaryotype;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.api.plugin.IGenomeBuilder;
import forestry.core.commands.AlleleArgument;
import forestry.core.commands.ChromosomeArgument;
import forestry.core.commands.CommandHelpers;
import forestry.core.commands.LifeStageArgument;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class ModifyGenomeCommand {
    private static final DynamicCommandExceptionType ERROR_NO_GENETICS = new DynamicCommandExceptionType(found -> Component.m_237113_((String)("The following item does not contain genetic data: " + found)));

    public static LiteralArgumentBuilder<CommandSourceStack> register(ISpeciesType<?, ?> type) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"modify").requires(CommandHelpers.ADMIN)).then(Commands.m_82129_((String)"chromosome", (ArgumentType)new ChromosomeArgument(type)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"allele", (ArgumentType)new AlleleArgument(type)).suggests((ctx, builder) -> ModifyGenomeCommand.suggestAlleles(type, (CommandContext<CommandSourceStack>)ctx, builder)).executes(ctx -> ModifyGenomeCommand.execute(type, (CommandContext<CommandSourceStack>)ctx, true, true))).then(Commands.m_82127_((String)"both").executes(ctx -> ModifyGenomeCommand.execute(type, (CommandContext<CommandSourceStack>)ctx, true, true)))).then(Commands.m_82127_((String)"dominant").executes(ctx -> ModifyGenomeCommand.execute(type, (CommandContext<CommandSourceStack>)ctx, true, false)))).then(Commands.m_82127_((String)"recessive").executes(ctx -> ModifyGenomeCommand.execute(type, (CommandContext<CommandSourceStack>)ctx, false, true)))));
    }

    private static int execute(ISpeciesType<?, ?> type, CommandContext<CommandSourceStack> ctx, boolean active, boolean inactive) throws CommandSyntaxException {
        IChromosome chromosome;
        IKaryotype karyotype = type.getKaryotype();
        if (karyotype.isChromosomeValid(chromosome = (IChromosome)ctx.getArgument("chromosome", IChromosome.class))) {
            IAllele allele = (IAllele)ctx.getArgument("allele", IAllele.class);
            if (karyotype.isAlleleValid(chromosome, allele.cast())) {
                CommandSourceStack source = (CommandSourceStack)ctx.getSource();
                ServerPlayer player = source.m_81375_();
                ItemStack stack = player.m_21205_();
                IIndividualHandlerItem handler = IIndividualHandlerItem.get(stack);
                if (handler != null) {
                    IIndividual individual = handler.getIndividual();
                    if (individual.getType() != type) {
                        throw LifeStageArgument.INVALID_VALUE.create((Object)individual.getClass().getSimpleName());
                    }
                    IGenome oldGenome = individual.getGenome();
                    IGenomeBuilder builder = karyotype.createGenomeBuilder();
                    for (Map.Entry entry : oldGenome.getChromosomes().entrySet()) {
                        IChromosome key = (IChromosome)entry.getKey();
                        AllelePair<IAllele> pair = (AllelePair<IAllele>)entry.getValue();
                        if (key == chromosome) {
                            pair = new AllelePair<IAllele>(active ? allele : pair.active(), inactive ? allele : pair.inactive());
                        }
                        builder.setUnchecked(key, pair);
                    }
                    IGenome newGenome = builder.build();
                    IIndividual newIndividual = individual.copyWithGenome(newGenome);
                    newIndividual.analyze();
                    ItemStack newStack = newIndividual.createStack(handler.getStage());
                    newStack.m_41764_(stack.m_41613_());
                    player.m_21008_(InteractionHand.MAIN_HAND, newStack);
                    source.m_288197_(() -> Component.m_237113_((String)"Modified genome of ").m_7220_(newStack.m_41611_()), true);
                    return 1;
                }
                throw ERROR_NO_GENETICS.create((Object)stack.m_41611_().getString());
            }
            throw LifeStageArgument.INVALID_VALUE.create((Object)allele.alleleId().toString());
        }
        throw LifeStageArgument.INVALID_VALUE.create((Object)chromosome.id().toString());
    }

    private static CompletableFuture<Suggestions> suggestAlleles(ISpeciesType<?, ?> type, CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        IChromosome chromosome = (IChromosome)ctx.getArgument("chromosome", IChromosome.class);
        return SharedSuggestionProvider.m_82957_(type.getKaryotype().getAlleles(chromosome).stream().map(IAllele::alleleId), (SuggestionsBuilder)builder);
    }
}

