/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import forestry.factory.features.FactoryRecipeTypes;
import forestry.factory.recipes.RecipeSerializers;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ImpossibleTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.mutable.MutableObject;

public class FabricatorRecipeBuilder {
    private Ingredient plan;
    private FluidStack molten;
    private ShapedRecipeBuilder.Result recipe;

    public FabricatorRecipeBuilder setPlan(Ingredient plan) {
        this.plan = plan;
        return this;
    }

    public FabricatorRecipeBuilder setMolten(FluidStack molten) {
        this.molten = molten;
        return this;
    }

    public FabricatorRecipeBuilder recipe(ShapedRecipeBuilder recipe) {
        MutableObject holder = new MutableObject();
        recipe.m_126132_("impossible", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance()).m_176498_(arg_0 -> ((MutableObject)holder).setValue(arg_0));
        this.recipe = (ShapedRecipeBuilder.Result)holder.getValue();
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this.plan, this.molten, this.recipe));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient plan;
        private final FluidStack molten;
        private final ShapedRecipeBuilder.Result recipe;

        public Result(ResourceLocation id, Ingredient plan, FluidStack molten, ShapedRecipeBuilder.Result recipe) {
            this.id = id;
            this.plan = plan;
            this.molten = molten;
            this.recipe = recipe;
        }

        public void m_7917_(JsonObject json) {
            json.add("plan", this.plan.m_43942_());
            json.add("molten", (JsonElement)RecipeSerializers.serializeFluid(this.molten));
            json.add("recipe", (JsonElement)this.recipe.m_125966_());
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return FactoryRecipeTypes.FABRICATOR.serializer();
        }

        public JsonObject m_5860_() {
            return null;
        }

        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

