/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data.recipe;

import forestry.api.ForestryTags;
import forestry.api.IForestryApi;
import forestry.api.arboriculture.IWoodAccess;
import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.api.circuits.ICircuit;
import forestry.apiculture.blocks.BlockAlveary;
import forestry.apiculture.blocks.BlockAlvearyType;
import forestry.apiculture.blocks.BlockTypeApiculture;
import forestry.apiculture.blocks.NaturalistChestBlockType;
import forestry.apiculture.features.ApicultureBlocks;
import forestry.apiculture.features.ApicultureItems;
import forestry.apiculture.items.EnumHoneyComb;
import forestry.apiculture.items.EnumPollenCluster;
import forestry.apiculture.items.EnumPropolis;
import forestry.apiculture.items.ItemBeesWax;
import forestry.arboriculture.ForestryWoodType;
import forestry.arboriculture.VanillaWoodType;
import forestry.arboriculture.WoodAccess;
import forestry.arboriculture.features.ArboricultureBlocks;
import forestry.arboriculture.features.ArboricultureItems;
import forestry.arboriculture.features.CharcoalBlocks;
import forestry.core.blocks.BlockTypeCoreTesr;
import forestry.core.blocks.EnumResourceType;
import forestry.core.circuits.EnumCircuitBoardType;
import forestry.core.circuits.ItemCircuitBoard;
import forestry.core.data.builder.CarpenterRecipeBuilder;
import forestry.core.data.builder.CentrifugeRecipeBuilder;
import forestry.core.data.builder.FabricatorRecipeBuilder;
import forestry.core.data.builder.FabricatorSmeltingRecipeBuilder;
import forestry.core.data.builder.FermenterRecipeBuilder;
import forestry.core.data.builder.HygroregulatorRecipeBuilder;
import forestry.core.data.builder.MoistenerRecipeBuilder;
import forestry.core.data.builder.SqueezerContainerRecipeBuilder;
import forestry.core.data.builder.SqueezerRecipeBuilder;
import forestry.core.data.builder.StillRecipeBuilder;
import forestry.core.features.CoreBlocks;
import forestry.core.features.CoreItems;
import forestry.core.features.FluidsItems;
import forestry.core.fluids.ForestryFluids;
import forestry.core.items.definitions.EnumContainerType;
import forestry.core.items.definitions.EnumCraftingMaterial;
import forestry.core.items.definitions.EnumElectronTube;
import forestry.core.utils.ModUtil;
import forestry.cultivation.blocks.BlockTypePlanter;
import forestry.cultivation.features.CultivationBlocks;
import forestry.energy.blocks.EngineBlockType;
import forestry.energy.features.EnergyBlocks;
import forestry.factory.blocks.BlockTypeFactoryPlain;
import forestry.factory.blocks.BlockTypeFactoryTesr;
import forestry.factory.features.FactoryBlocks;
import forestry.farming.blocks.EnumFarmBlockType;
import forestry.farming.blocks.EnumFarmMaterial;
import forestry.farming.features.FarmingBlocks;
import forestry.lepidopterology.features.LepidopterologyItems;
import forestry.lepidopterology.features.LepidopterologyRecipes;
import forestry.mail.blocks.BlockTypeMail;
import forestry.mail.features.MailBlocks;
import forestry.mail.features.MailItems;
import forestry.mail.items.EnumStampDefinition;
import forestry.mail.items.ItemLetter;
import forestry.modules.features.FeatureBlock;
import forestry.modules.features.FeatureItem;
import forestry.sorting.features.SortingBlocks;
import forestry.storage.features.BackpackItems;
import forestry.storage.features.CrateItems;
import forestry.storage.items.ItemCrated;
import forestry.worktable.features.WorktableBlocks;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.StrictNBTIngredient;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import thedarkcolour.modkit.data.MKRecipeProvider;

public class ForestryRecipeProvider {
    public static final int STILL_DESTILLATION_DURATION = 100;
    public static final int STILL_DESTILLATION_INPUT = 10;
    public static final int STILL_DESTILLATION_OUTPUT = 3;

    public static ItemStack getContainer(EnumContainerType type, ForestryFluids fluid) {
        return ForestryRecipeProvider.getContainer(type, fluid.getFluid());
    }

    public static ItemStack getContainer(EnumContainerType type, Fluid fluid) {
        ItemStack container = FluidsItems.CONTAINERS.stack(type);
        LazyOptional fluidHandlerCap = FluidUtil.getFluidHandler((ItemStack)container);
        return fluidHandlerCap.map(handler -> {
            handler.fill(new FluidStack(fluid, Integer.MAX_VALUE), IFluidHandler.FluidAction.EXECUTE);
            return container;
        }).orElse(ItemStack.f_41583_);
    }

    public static void addRecipes(Consumer<FinishedRecipe> consumer, MKRecipeProvider recipes) {
        ForestryRecipeProvider.registerArboricultureRecipes(recipes);
        ForestryRecipeProvider.registerApicultureRecipes(recipes);
        ForestryRecipeProvider.registerFoodRecipes(recipes);
        ForestryRecipeProvider.registerBackpackRecipes(recipes);
        ForestryRecipeProvider.registerCharcoalRecipes(recipes);
        ForestryRecipeProvider.registerCoreRecipes(recipes);
        ForestryRecipeProvider.registerCultivationRecipes(recipes);
        ForestryRecipeProvider.registerFactoryRecipes(recipes);
        ForestryRecipeProvider.registerFarmingRecipes(recipes);
        ForestryRecipeProvider.registerFluidsRecipes(recipes);
        ForestryRecipeProvider.registerLepidopterologyRecipes(recipes);
        ForestryRecipeProvider.registerMailRecipes(recipes);
        ForestryRecipeProvider.registerSortingRecipes(recipes);
        ForestryRecipeProvider.registerWorktableRecipes(recipes);
        ForestryRecipeProvider.registerEnergyRecipes(recipes);
        ForestryRecipeProvider.registerCarpenter(consumer);
        ForestryRecipeProvider.registerCentrifuge(consumer);
        ForestryRecipeProvider.registerFabricator(consumer);
        ForestryRecipeProvider.registerFabricatorSmelting(consumer);
        ForestryRecipeProvider.registerFermenter(consumer);
        ForestryRecipeProvider.registerHygroregulator(consumer);
        ForestryRecipeProvider.registerMoistener(consumer);
        ForestryRecipeProvider.registerSqueezerContainer(consumer);
        ForestryRecipeProvider.registerSqueezer(consumer);
        ForestryRecipeProvider.registerStill(consumer);
    }

    private static void registerApicultureRecipes(MKRecipeProvider recipes) {
        ForestryRecipeProvider.registerCombRecipes(recipes);
        BlockAlveary plain = (BlockAlveary)((Object)((FeatureBlock)ApicultureBlocks.ALVEARY.get(BlockAlvearyType.PLAIN)).block());
        ItemLike goldElectronTube = (ItemLike)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.GOLD);
        recipes.shapedCrafting(RecipeCategory.BUILDING_BLOCKS, (ItemLike)plain, recipe -> {
            recipe.define('X', CoreItems.IMPREGNATED_CASING);
            recipe.define('#', (ItemLike)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.SCENTED_PANELING));
            recipe.pattern("###");
            recipe.pattern("#X#");
            recipe.pattern("###");
            recipe.m_126145_("alveary");
        });
        recipes.shapedCrafting(RecipeCategory.BUILDING_BLOCKS, ((FeatureBlock)ApicultureBlocks.ALVEARY.get(BlockAlvearyType.FAN)).block(), recipe -> {
            recipe.define('#', goldElectronTube);
            recipe.define('X', (ItemLike)plain);
            recipe.define('I', Tags.Items.INGOTS_IRON);
            recipe.pattern("I I");
            recipe.pattern(" X ");
            recipe.pattern("I#I");
            recipe.m_126145_("alveary");
        });
        recipes.shapedCrafting(RecipeCategory.BUILDING_BLOCKS, ((FeatureBlock)ApicultureBlocks.ALVEARY.get(BlockAlvearyType.HEATER)).block(), recipe -> {
            recipe.define('#', goldElectronTube);
            recipe.define('I', Tags.Items.INGOTS_IRON);
            recipe.define('X', (ItemLike)plain);
            recipe.define('S', Tags.Items.STONE);
            recipe.pattern("#I#");
            recipe.pattern(" X ");
            recipe.pattern("SSS");
            recipe.m_126145_("alveary");
        });
        recipes.shapedCrafting(RecipeCategory.BUILDING_BLOCKS, ((FeatureBlock)ApicultureBlocks.ALVEARY.get(BlockAlvearyType.HYGRO)).block(), recipe -> {
            recipe.define('G', Tags.Items.GLASS);
            recipe.define('X', (ItemLike)plain);
            recipe.define('I', Tags.Items.INGOTS_IRON);
            recipe.pattern("GIG");
            recipe.pattern("GXG");
            recipe.pattern("GIG");
            recipe.m_126145_("alveary");
        });
        recipes.shapedCrafting(RecipeCategory.BUILDING_BLOCKS, ((FeatureBlock)ApicultureBlocks.ALVEARY.get(BlockAlvearyType.SIEVE)).block(), recipe -> {
            recipe.define('W', (ItemLike)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.WOVEN_SILK));
            recipe.define('X', (ItemLike)plain);
            recipe.define('I', Tags.Items.INGOTS_IRON);
            recipe.pattern("III");
            recipe.pattern(" X ");
            recipe.pattern("WWW");
            recipe.m_126145_("alveary");
        });
        recipes.shapedCrafting(RecipeCategory.BUILDING_BLOCKS, ((FeatureBlock)ApicultureBlocks.ALVEARY.get(BlockAlvearyType.STABILISER)).block(), recipe -> {
            recipe.define('X', (ItemLike)plain);
            recipe.define('G', Tags.Items.GEMS_QUARTZ);
            recipe.pattern("G G");
            recipe.pattern("GXG");
            recipe.pattern("G G");
            recipe.m_126145_("alveary");
        });
        recipes.shapedCrafting(RecipeCategory.BUILDING_BLOCKS, ((FeatureBlock)ApicultureBlocks.ALVEARY.get(BlockAlvearyType.SWARMER)).block(), recipe -> {
            recipe.define('#', (ItemLike)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.DIAMOND));
            recipe.define('X', (ItemLike)plain);
            recipe.define('G', Tags.Items.INGOTS_GOLD);
            recipe.pattern("#G#");
            recipe.pattern(" X ");
            recipe.pattern("#G#");
            recipe.m_126145_("alveary");
        });
        ItemLike wovenSilk = (ItemLike)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.WOVEN_SILK);
        recipes.shapedCrafting(RecipeCategory.COMBAT, ApicultureItems.APIARIST_HELMET, recipe -> {
            recipe.define('#', wovenSilk);
            recipe.pattern("###");
            recipe.pattern("# #");
            recipe.m_126145_("apiarist_armour");
        });
        recipes.shapedCrafting(RecipeCategory.COMBAT, ApicultureItems.APIARIST_CHEST, recipe -> {
            recipe.define('#', wovenSilk);
            recipe.pattern("# #");
            recipe.pattern("###");
            recipe.pattern("###");
            recipe.m_126145_("apiarist_armour");
        });
        recipes.shapedCrafting(RecipeCategory.COMBAT, ApicultureItems.APIARIST_LEGS, recipe -> {
            recipe.define('#', wovenSilk);
            recipe.pattern("###");
            recipe.pattern("# #");
            recipe.pattern("# #");
            recipe.m_126145_("apiarist_armour");
        });
        recipes.shapedCrafting(RecipeCategory.COMBAT, ApicultureItems.APIARIST_BOOTS, recipe -> {
            recipe.define('#', wovenSilk);
            recipe.pattern("# #");
            recipe.pattern("# #");
            recipe.m_126145_("apiarist_armour");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, ((FeatureBlock)ApicultureBlocks.BASE.get(BlockTypeApiculture.APIARY)).block(), recipe -> {
            recipe.define('S', ItemTags.f_13175_);
            recipe.define('P', ItemTags.f_13168_);
            recipe.define('C', CoreItems.IMPREGNATED_CASING);
            recipe.pattern("SSS");
            recipe.pattern("PCP");
            recipe.pattern("PPP");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, ((FeatureBlock)ApicultureBlocks.BASE.get(BlockTypeApiculture.BEE_HOUSE)).block(), recipe -> {
            recipe.define('S', ItemTags.f_13175_);
            recipe.define('P', ItemTags.f_13168_);
            recipe.define('C', ForestryTags.Items.BEE_COMBS);
            recipe.pattern("SSS");
            recipe.pattern("PCP");
            recipe.pattern("PPP");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)CoreBlocks.NATURALIST_CHEST.get(NaturalistChestBlockType.APIARIST_CHEST), recipe -> {
            recipe.define('G', Tags.Items.GLASS);
            recipe.define('X', ForestryTags.Items.BEE_COMBS);
            recipe.define('Y', Tags.Items.CHESTS_WOODEN);
            recipe.pattern(" G ");
            recipe.pattern("XYX");
            recipe.pattern("XXX");
        });
        ItemLike propolis = (ItemLike)ApicultureItems.PROPOLIS.get(EnumPropolis.NORMAL);
        recipes.shapedCrafting(RecipeCategory.MISC, CoreItems.BITUMINOUS_PEAT, recipe -> {
            recipe.define('#', ForestryTags.Items.DUSTS_ASH);
            recipe.define('X', CoreItems.PEAT);
            recipe.define('Y', propolis);
            recipe.pattern(" # ");
            recipe.pattern("XYX");
            recipe.pattern(" # ");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, ApicultureItems.FRAME_IMPREGNATED, recipe -> {
            recipe.define('#', (ItemLike)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.IMPREGNATED_STICK));
            recipe.define('S', Tags.Items.STRING);
            recipe.pattern("###");
            recipe.pattern("#S#");
            recipe.pattern("###");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, ApicultureItems.FRAME_UNTREATED, recipe -> {
            recipe.define('#', Tags.Items.RODS_WOODEN);
            recipe.define('S', Tags.Items.STRING);
            recipe.pattern("###");
            recipe.pattern("#S#");
            recipe.pattern("###");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.PULSATING_MESH), recipe -> {
            recipe.define('#', (ItemLike)ApicultureItems.PROPOLIS.get(EnumPropolis.PULSATING));
            recipe.pattern("# #");
            recipe.pattern(" # ");
            recipe.pattern("# #");
        });
        recipes.shapedCrafting(RecipeCategory.TOOLS, ApicultureItems.SCOOP, recipe -> {
            recipe.define('#', Tags.Items.RODS_WOODEN);
            recipe.define('X', ItemTags.f_13167_);
            recipe.pattern("#X#");
            recipe.pattern("###");
            recipe.pattern(" # ");
        });
        recipes.shapedCrafting("slime_from_propolis", RecipeCategory.MISC, (ItemLike)Items.f_42518_, recipe -> {
            recipe.define('#', propolis);
            recipe.define('X', (ItemLike)ApicultureItems.POLLEN_CLUSTER.get(EnumPollenCluster.NORMAL));
            recipe.pattern("#X#");
            recipe.pattern("#X#");
            recipe.pattern("#X#");
        });
        recipes.shapedCrafting(RecipeCategory.TOOLS, ApicultureItems.SMOKER, recipe -> {
            recipe.define('#', ForestryTags.Items.INGOTS_TIN);
            recipe.define('S', Tags.Items.RODS_WOODEN);
            recipe.define('F', (ItemLike)Items.f_42409_);
            recipe.define('L', Tags.Items.LEATHER);
            recipe.pattern("LS#");
            recipe.pattern("LF#");
            recipe.pattern("###");
        });
        recipes.shapedCrafting("glistering_melon_slice", RecipeCategory.MISC, (ItemLike)Items.f_42546_, recipe -> {
            recipe.define('#', ApicultureItems.HONEY_DROP);
            recipe.define('X', ApicultureItems.HONEYDEW);
            recipe.define('Y', (ItemLike)Items.f_42575_);
            recipe.pattern("#X#");
            recipe.pattern("#Y#");
            recipe.pattern("#X#");
        });
        FeatureItem<ItemBeesWax> beesWax = CoreItems.BEESWAX;
        recipes.shapedCrafting("torch_from_wax", RecipeCategory.MISC, (ItemLike)Items.f_42000_, 3, recipe -> {
            recipe.define('#', beesWax);
            recipe.define('Y', Tags.Items.RODS_WOODEN);
            recipe.pattern(" # ");
            recipe.pattern(" # ");
            recipe.pattern(" Y ");
        });
        recipes.shapelessCrafting("exp_bottle_from_exp_drop", RecipeCategory.MISC, (ItemLike)Items.f_42612_, 1, new Object[]{Items.f_42590_, ApicultureItems.EXPERIENCE_DROP.item()});
    }

    private static void registerCombRecipes(MKRecipeProvider recipes) {
        for (EnumHoneyComb honeyComb : EnumHoneyComb.VALUES) {
            ItemLike comb = (ItemLike)ApicultureItems.BEE_COMBS.get(honeyComb);
            Object combBlock = ((FeatureBlock)ApicultureBlocks.BEE_COMB.get(honeyComb)).block();
            recipes.grid2x2(RecipeCategory.BUILDING_BLOCKS, combBlock, 1, Ingredient.m_43929_((ItemLike[])new ItemLike[]{comb}), "combs");
        }
    }

    private static void registerArboricultureRecipes(MKRecipeProvider recipes) {
        ForestryRecipeProvider.registerWoodRecipes(recipes);
        recipes.shapedCrafting(RecipeCategory.TOOLS, ArboricultureItems.GRAFTER, recipe -> {
            recipe.define('B', ForestryTags.Items.INGOTS_BRONZE);
            recipe.define('#', Tags.Items.RODS_WOODEN);
            recipe.pattern("  B");
            recipe.pattern(" # ");
            recipe.pattern("#  ");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)CoreBlocks.NATURALIST_CHEST.get(NaturalistChestBlockType.ARBORIST_CHEST), recipe -> {
            recipe.define('X', ItemTags.f_13180_);
            recipe.define('Y', Tags.Items.CHESTS_WOODEN);
            recipe.define('#', Tags.Items.GLASS);
            recipe.pattern(" # ");
            recipe.pattern("XYX");
            recipe.pattern("XXX");
        });
    }

    private static void registerWoodRecipes(MKRecipeProvider recipes) {
        WoodAccess woodAccess = WoodAccess.INSTANCE;
        List<IWoodType> woodTypes = woodAccess.getRegisteredWoodTypes();
        for (IWoodType woodType : woodTypes) {
            Block planks = woodAccess.getBlock(woodType, WoodBlockKind.PLANKS, false).m_60734_();
            Block fireproofPlanks = woodAccess.getBlock(woodType, WoodBlockKind.PLANKS, true).m_60734_();
            Block log = woodAccess.getBlock(woodType, WoodBlockKind.LOG, false).m_60734_();
            Block fireproofLog = woodAccess.getBlock(woodType, WoodBlockKind.LOG, true).m_60734_();
            Block wood = woodAccess.getBlock(woodType, WoodBlockKind.WOOD, false).m_60734_();
            Block fireproofWood = woodAccess.getBlock(woodType, WoodBlockKind.WOOD, true).m_60734_();
            Block strippedLog = woodAccess.getBlock(woodType, WoodBlockKind.STRIPPED_LOG, false).m_60734_();
            Block fireproofStrippedLog = woodAccess.getBlock(woodType, WoodBlockKind.STRIPPED_LOG, true).m_60734_();
            Block strippedWood = woodAccess.getBlock(woodType, WoodBlockKind.STRIPPED_WOOD, false).m_60734_();
            Block fireproofStrippedWood = woodAccess.getBlock(woodType, WoodBlockKind.STRIPPED_WOOD, true).m_60734_();
            Block door = woodAccess.getBlock(woodType, WoodBlockKind.DOOR, false).m_60734_();
            Block trapdoor = woodAccess.getBlock(woodType, WoodBlockKind.TRAPDOOR, false).m_60734_();
            Block fence = woodAccess.getBlock(woodType, WoodBlockKind.FENCE, false).m_60734_();
            Block fireproofFence = woodAccess.getBlock(woodType, WoodBlockKind.FENCE, true).m_60734_();
            Block fenceGate = woodAccess.getBlock(woodType, WoodBlockKind.FENCE_GATE, false).m_60734_();
            Block fireproofFenceGate = woodAccess.getBlock(woodType, WoodBlockKind.FENCE_GATE, true).m_60734_();
            Block slab = woodAccess.getBlock(woodType, WoodBlockKind.SLAB, false).m_60734_();
            Block fireproofSlab = woodAccess.getBlock(woodType, WoodBlockKind.SLAB, true).m_60734_();
            Block stairs = woodAccess.getBlock(woodType, WoodBlockKind.STAIRS, false).m_60734_();
            Block fireproofStairs = woodAccess.getBlock(woodType, WoodBlockKind.STAIRS, true).m_60734_();
            TagKey<Item> logTag = woodAccess.getLogItemTag(woodType, false);
            TagKey<Item> fireproofLogTag = woodAccess.getLogItemTag(woodType, true);
            recipes.woodenDoor((ItemLike)door, woodType instanceof VanillaWoodType ? Ingredient.m_43929_((ItemLike[])new ItemLike[]{fireproofPlanks}) : Ingredient.m_43929_((ItemLike[])new ItemLike[]{planks, fireproofPlanks}));
            if (woodType instanceof ForestryWoodType) {
                ForestryWoodType type = (ForestryWoodType)woodType;
                ForestryRecipeProvider.makeCommonWoodenSet(recipes, planks, log, logTag, wood, strippedLog, strippedWood, fence, fenceGate, slab, stairs);
                recipes.shapelessCrafting(RecipeCategory.MISC, (ItemLike)ArboricultureItems.CHEST_BOAT.item(type), 1, new Object[]{ArboricultureItems.BOAT.item(type), Tags.Items.CHESTS_WOODEN});
                recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)ArboricultureItems.BOAT.item(type), recipe -> {
                    recipe.define('P', Ingredient.m_43929_((ItemLike[])new ItemLike[]{planks, fireproofPlanks}));
                    recipe.pattern("P P");
                    recipe.pattern("PPP");
                });
                recipes.woodenTrapdoor((ItemLike)trapdoor, Ingredient.m_43929_((ItemLike[])new ItemLike[]{planks, fireproofPlanks}));
                recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)ArboricultureBlocks.SIGN.get(type), recipe -> {
                    recipe.define('P', Ingredient.m_43929_((ItemLike[])new ItemLike[]{planks, fireproofPlanks}));
                    recipe.define('S', Tags.Items.RODS_WOODEN);
                    recipe.pattern("PPP");
                    recipe.pattern("PPP");
                    recipe.pattern(" S ");
                });
                recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)ArboricultureBlocks.HANGING_SIGN.get(type), recipe -> {
                    recipe.define('X', (ItemLike)Items.f_42026_);
                    recipe.define('#', Ingredient.m_43929_((ItemLike[])new ItemLike[]{strippedLog, fireproofStrippedLog}));
                    recipe.pattern("X X");
                    recipe.pattern("###");
                    recipe.pattern("###");
                });
                recipes.shapelessCrafting(RecipeCategory.REDSTONE, (ItemLike)ArboricultureBlocks.BUTTON.get(type), 1, new Object[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{planks, fireproofPlanks})});
                recipes.shapedCrafting(RecipeCategory.REDSTONE, (ItemLike)ArboricultureBlocks.PRESSURE_PLATE.get(type), recipe -> {
                    recipe.define('P', Ingredient.m_43929_((ItemLike[])new ItemLike[]{planks, fireproofPlanks}));
                    recipe.pattern("PP");
                });
            }
            ForestryRecipeProvider.makeCommonWoodenSet(recipes, fireproofPlanks, fireproofLog, fireproofLogTag, fireproofWood, fireproofStrippedLog, fireproofStrippedWood, fireproofFence, fireproofFenceGate, fireproofSlab, fireproofStairs);
        }
    }

    private static void makeCommonWoodenSet(MKRecipeProvider recipes, Block planks, Block log, TagKey<Item> logTag, Block wood, Block strippedLog, Block strippedWood, Block fence, Block fenceGate, Block slab, Block stairs) {
        recipes.shapelessCrafting(RecipeCategory.BUILDING_BLOCKS, (ItemLike)planks, 4, "planks", new Object[]{logTag});
        recipes.woodenFence((ItemLike)fence, (ItemLike)planks);
        recipes.woodenFenceGate((ItemLike)fenceGate, (ItemLike)planks);
        recipes.woodenSlab((ItemLike)slab, (ItemLike)planks);
        recipes.woodenStairs((ItemLike)stairs, (ItemLike)planks);
        recipes.grid2x2(RecipeCategory.BUILDING_BLOCKS, (ItemLike)wood, 3, Ingredient.m_43929_((ItemLike[])new ItemLike[]{log}), "bark");
        recipes.grid2x2(RecipeCategory.BUILDING_BLOCKS, (ItemLike)strippedWood, 3, Ingredient.m_43929_((ItemLike[])new ItemLike[]{strippedLog}), "bark");
    }

    private static void registerFoodRecipes(MKRecipeProvider recipes) {
        ItemLike waxCapsule = (ItemLike)FluidsItems.CONTAINERS.get(EnumContainerType.CAPSULE);
        FeatureItem<Item> honeyDrop = ApicultureItems.HONEY_DROP;
        recipes.shapedCrafting(RecipeCategory.FOOD, ApicultureItems.AMBROSIA, recipe -> {
            recipe.define('#', ApicultureItems.HONEYDEW);
            recipe.define('X', ApicultureItems.ROYAL_JELLY);
            recipe.define('Y', waxCapsule);
            recipe.pattern("#Y#");
            recipe.pattern("XXX");
            recipe.pattern("###");
        });
        recipes.shapedCrafting(RecipeCategory.FOOD, ApicultureItems.HONEYED_SLICE, recipe -> {
            recipe.define('#', honeyDrop);
            recipe.define('X', (ItemLike)Items.f_42406_);
            recipe.pattern("###");
            recipe.pattern("#X#");
            recipe.pattern("###");
        });
        recipes.shapelessCrafting("bottled_honey_drops", RecipeCategory.FOOD, (ItemLike)Items.f_42787_, 1, new Object[]{Items.f_42590_, honeyDrop, honeyDrop});
    }

    private static void registerBackpackRecipes(MKRecipeProvider recipes) {
        recipes.shapedCrafting(RecipeCategory.TOOLS, BackpackItems.ADVENTURER_BACKPACK, recipe -> {
            recipe.define('#', ItemTags.f_13167_);
            recipe.define('V', Tags.Items.BONES);
            recipe.define('X', Tags.Items.STRING);
            recipe.define('Y', Tags.Items.CHESTS_WOODEN);
            recipe.pattern("X#X");
            recipe.pattern("VYV");
            recipe.pattern("X#X");
        });
        recipes.shapedCrafting(RecipeCategory.TOOLS, BackpackItems.BUILDER_BACKPACK, recipe -> {
            recipe.define('#', ItemTags.f_13167_);
            recipe.define('V', (ItemLike)Items.f_42461_);
            recipe.define('X', Tags.Items.STRING);
            recipe.define('Y', Tags.Items.CHESTS_WOODEN);
            recipe.pattern("X#X");
            recipe.pattern("VYV");
            recipe.pattern("X#X");
        });
        recipes.shapedCrafting(RecipeCategory.TOOLS, BackpackItems.DIGGER_BACKPACK, recipe -> {
            recipe.define('#', ItemTags.f_13167_);
            recipe.define('V', Tags.Items.STONE);
            recipe.define('X', Tags.Items.STRING);
            recipe.define('Y', Tags.Items.CHESTS_WOODEN);
            recipe.pattern("X#X");
            recipe.pattern("VYV");
            recipe.pattern("X#X");
        });
        recipes.shapedCrafting(RecipeCategory.TOOLS, BackpackItems.FORESTER_BACKPACK, recipe -> {
            recipe.define('#', ItemTags.f_13167_);
            recipe.define('V', ItemTags.f_13182_);
            recipe.define('X', Tags.Items.STRING);
            recipe.define('Y', Tags.Items.CHESTS_WOODEN);
            recipe.pattern("X#X");
            recipe.pattern("VYV");
            recipe.pattern("X#X");
        });
        recipes.shapedCrafting(RecipeCategory.TOOLS, BackpackItems.HUNTER_BACKPACK, recipe -> {
            recipe.define('#', ItemTags.f_13167_);
            recipe.define('V', Tags.Items.FEATHERS);
            recipe.define('X', Tags.Items.STRING);
            recipe.define('Y', Tags.Items.CHESTS_WOODEN);
            recipe.pattern("X#X");
            recipe.pattern("VYV");
            recipe.pattern("X#X");
        });
        recipes.shapedCrafting(RecipeCategory.TOOLS, BackpackItems.MINER_BACKPACK, recipe -> {
            recipe.define('#', ItemTags.f_13167_);
            recipe.define('V', Tags.Items.INGOTS_IRON);
            recipe.define('X', Tags.Items.STRING);
            recipe.define('Y', Tags.Items.CHESTS_WOODEN);
            recipe.pattern("X#X");
            recipe.pattern("VYV");
            recipe.pattern("X#X");
        });
        ForestryRecipeProvider.naturalistBackpack(recipes, BackpackItems.APIARIST_BACKPACK, (ItemLike)CoreBlocks.NATURALIST_CHEST.get(NaturalistChestBlockType.APIARIST_CHEST));
        ForestryRecipeProvider.naturalistBackpack(recipes, BackpackItems.LEPIDOPTERIST_BACKPACK, (ItemLike)CoreBlocks.NATURALIST_CHEST.get(NaturalistChestBlockType.LEPIDOPTERIST_CHEST));
        ForestryRecipeProvider.naturalistBackpack(recipes, BackpackItems.ARBORIST_BACKPACK, (ItemLike)CoreBlocks.NATURALIST_CHEST.get(NaturalistChestBlockType.ARBORIST_CHEST));
    }

    private static void naturalistBackpack(MKRecipeProvider recipes, ItemLike backpack, ItemLike chest) {
        recipes.shapedCrafting(RecipeCategory.TOOLS, backpack, recipe -> {
            recipe.define('#', ItemTags.f_13167_);
            recipe.define('V', Tags.Items.RODS_WOODEN);
            recipe.define('X', Tags.Items.STRING);
            recipe.define('Y', chest);
            recipe.pattern("X#X");
            recipe.pattern("VYV");
            recipe.pattern("X#X");
        });
    }

    private static void registerCharcoalRecipes(MKRecipeProvider recipes) {
        recipes.shapedCrafting(RecipeCategory.BUILDING_BLOCKS, (ItemLike)CharcoalBlocks.CHARCOAL.block(), recipe -> {
            recipe.define('#', (ItemLike)Items.f_42414_);
            recipe.pattern("###");
            recipe.pattern("###");
            recipe.pattern("###");
        });
        recipes.shapelessCrafting("charcoal_from_block", RecipeCategory.MISC, (ItemLike)Items.f_42414_, 9, new Object[]{ForestryTags.Items.CHARCOAL_BLOCK});
        recipes.shapedCrafting(RecipeCategory.BUILDING_BLOCKS, (ItemLike)CharcoalBlocks.LOG_PILE.block(), recipe -> {
            recipe.define('L', ItemTags.f_13182_);
            recipe.pattern(" L ");
            recipe.pattern("L L");
            recipe.pattern(" L ");
        });
        recipes.shapelessCrafting(RecipeCategory.BUILDING_BLOCKS, (ItemLike)CharcoalBlocks.DECORATIVE_LOG_PILE.block(), 1, new Object[]{CharcoalBlocks.LOG_PILE.block()});
        recipes.shapelessCrafting("wood_pile_from_decorative", RecipeCategory.BUILDING_BLOCKS, (ItemLike)CharcoalBlocks.LOG_PILE.block(), 1, new Object[]{CharcoalBlocks.DECORATIVE_LOG_PILE.block()});
    }

    private static void registerCoreRecipes(MKRecipeProvider recipes) {
        recipes.oreSmelting(MKRecipeProvider.ingredient((ItemLike[])new ItemLike[]{CoreBlocks.APATITE_ORE.get(), CoreBlocks.DEEPSLATE_APATITE_ORE.get()}), CoreItems.APATITE, 0.5f, 200);
        recipes.oreSmelting(MKRecipeProvider.ingredient((ItemLike[])new ItemLike[]{CoreBlocks.TIN_ORE.get(), CoreBlocks.DEEPSLATE_TIN_ORE.get(), CoreItems.RAW_TIN}), CoreItems.INGOT_TIN, 0.5f, 200);
        recipes.smelting(Ingredient.m_43929_((ItemLike[])new ItemLike[]{CoreItems.PEAT.item()}), CoreItems.ASH, 0.0f, 200);
        recipes.storage3x3(CoreBlocks.RAW_TIN_BLOCK, CoreItems.RAW_TIN);
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)CoreBlocks.BASE.get(BlockTypeCoreTesr.ANALYZER), recipe -> {
            recipe.define('T', CoreItems.PORTABLE_ALYZER);
            recipe.define('X', ForestryTags.Items.INGOTS_BRONZE);
            recipe.define('Y', CoreItems.STURDY_CASING);
            recipe.pattern("XTX");
            recipe.pattern(" Y ");
            recipe.pattern("X X");
        });
        recipes.storage3x3((ItemLike)CoreBlocks.RESOURCE_STORAGE.get(EnumResourceType.APATITE), CoreItems.APATITE);
        recipes.storage3x3((ItemLike)CoreBlocks.RESOURCE_STORAGE.get(EnumResourceType.BRONZE), CoreItems.INGOT_BRONZE);
        recipes.storage3x3((ItemLike)CoreBlocks.RESOURCE_STORAGE.get(EnumResourceType.TIN), CoreItems.INGOT_TIN);
        recipes.shapedCrafting(RecipeCategory.TOOLS, CoreItems.BRONZE_PICKAXE, recipe -> {
            recipe.define('#', ForestryTags.Items.INGOTS_BRONZE);
            recipe.define('X', Tags.Items.RODS_WOODEN);
            recipe.pattern("###");
            recipe.pattern(" X ");
            recipe.pattern(" X ");
        });
        recipes.shapedCrafting(RecipeCategory.TOOLS, CoreItems.BRONZE_SHOVEL, recipe -> {
            recipe.define('#', ForestryTags.Items.INGOTS_BRONZE);
            recipe.define('X', Tags.Items.RODS_WOODEN);
            recipe.pattern(" # ");
            recipe.pattern(" X ");
            recipe.pattern(" X ");
        });
        recipes.shapedCrafting(RecipeCategory.TOOLS, CoreItems.BRONZE_AXE, recipe -> {
            recipe.define('#', ForestryTags.Items.INGOTS_BRONZE);
            recipe.define('X', Tags.Items.RODS_WOODEN);
            recipe.pattern("## ");
            recipe.pattern("#X ");
            recipe.pattern(" X ");
        });
        recipes.shapedCrafting(RecipeCategory.TOOLS, CoreItems.BRONZE_SWORD, recipe -> {
            recipe.define('#', ForestryTags.Items.INGOTS_BRONZE);
            recipe.define('X', Tags.Items.RODS_WOODEN);
            recipe.pattern(" # ");
            recipe.pattern(" # ");
            recipe.pattern(" X ");
        });
        recipes.shapedCrafting(RecipeCategory.TOOLS, CoreItems.BRONZE_HOE, recipe -> {
            recipe.define('#', ForestryTags.Items.INGOTS_BRONZE);
            recipe.define('X', Tags.Items.RODS_WOODEN);
            recipe.pattern("## ");
            recipe.pattern(" X ");
            recipe.pattern(" X ");
        });
        ForestryRecipeProvider.gear(recipes, CoreItems.GEAR_BRONZE, ForestryTags.Items.INGOTS_BRONZE);
        ForestryRecipeProvider.gear(recipes, CoreItems.GEAR_TIN, ForestryTags.Items.INGOTS_TIN);
        ForestryRecipeProvider.gear(recipes, CoreItems.GEAR_COPPER, (TagKey<Item>)Tags.Items.INGOTS_COPPER);
        recipes.shapelessCrafting("ingot_bronze_alloying", RecipeCategory.MISC, CoreItems.INGOT_BRONZE, 4, new Object[]{ForestryTags.Items.INGOTS_TIN, ObjectIntPair.of((Object)Items.f_151052_, (int)3)});
        recipes.shapelessCrafting(RecipeCategory.TOOLS, CoreItems.KIT_PICKAXE, 1, new Object[]{CoreItems.BRONZE_PICKAXE, CoreItems.CARTON});
        recipes.shapelessCrafting(RecipeCategory.TOOLS, CoreItems.KIT_SHOVEL, 1, new Object[]{CoreItems.BRONZE_SHOVEL, CoreItems.CARTON});
        recipes.shapelessCrafting(RecipeCategory.TOOLS, CoreItems.KIT_AXE, 1, new Object[]{CoreItems.BRONZE_AXE, CoreItems.CARTON});
        recipes.shapelessCrafting(RecipeCategory.TOOLS, CoreItems.KIT_SWORD, 1, new Object[]{CoreItems.BRONZE_SWORD, CoreItems.CARTON});
        recipes.shapelessCrafting(RecipeCategory.TOOLS, CoreItems.KIT_HOE, 1, new Object[]{CoreItems.BRONZE_HOE, CoreItems.CARTON});
        recipes.shapedCrafting(RecipeCategory.TOOLS, CoreItems.SPECTACLES, recipe -> {
            recipe.define('X', ForestryTags.Items.INGOTS_BRONZE);
            recipe.define('Y', Tags.Items.GLASS_PANES);
            recipe.pattern(" X ");
            recipe.pattern("Y Y");
        });
        recipes.shapedCrafting(RecipeCategory.TOOLS, CoreItems.PIPETTE, recipe -> {
            recipe.define('#', ItemTags.f_13167_);
            recipe.define('X', Tags.Items.GLASS_PANES);
            recipe.pattern("  #");
            recipe.pattern(" X ");
            recipe.pattern("X  ");
        });
        recipes.shapedCrafting(RecipeCategory.TOOLS, CoreItems.PORTABLE_ALYZER, recipe -> {
            recipe.define('#', Tags.Items.GLASS_PANES);
            recipe.define('X', ForestryTags.Items.INGOTS_TIN);
            recipe.define('R', Tags.Items.DUSTS_REDSTONE);
            recipe.define('D', Tags.Items.GEMS_DIAMOND);
            recipe.pattern("X#X");
            recipe.pattern("X#X");
            recipe.pattern("RDR");
        });
        recipes.shapedCrafting("string_from_wisp", RecipeCategory.MISC, (ItemLike)Items.f_42401_, recipe -> {
            recipe.define('#', (ItemLike)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.SILK_WISP));
            recipe.pattern(" # ");
            recipe.pattern(" # ");
            recipe.pattern(" # ");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, CoreItems.STURDY_CASING, recipe -> {
            recipe.define('#', ForestryTags.Items.INGOTS_BRONZE);
            recipe.pattern("###");
            recipe.pattern("# #");
            recipe.pattern("###");
        });
        recipes.shapedCrafting("cobweb_from_wisp", RecipeCategory.MISC, (ItemLike)Items.f_41863_, 4, recipe -> {
            recipe.define('#', (ItemLike)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.SILK_WISP));
            recipe.pattern("# #");
            recipe.pattern(" # ");
            recipe.pattern("# #");
        });
        recipes.shapedCrafting(RecipeCategory.TOOLS, CoreItems.WRENCH, recipe -> {
            recipe.define('#', ForestryTags.Items.INGOTS_BRONZE);
            recipe.pattern("# #");
            recipe.pattern(" # ");
            recipe.pattern(" # ");
        });
        recipes.shapedCrafting("compost_wheat", RecipeCategory.MISC, CoreItems.COMPOST, 4, recipe -> {
            recipe.define('#', (ItemLike)Blocks.f_50493_);
            recipe.define('X', Tags.Items.CROPS_WHEAT);
            recipe.pattern(" X ");
            recipe.pattern("X#X");
            recipe.pattern(" X ");
        });
        recipes.shapedCrafting("compost_ash", RecipeCategory.MISC, CoreItems.COMPOST, 1, recipe -> {
            recipe.define('#', (ItemLike)Blocks.f_50493_);
            recipe.define('X', ForestryTags.Items.DUSTS_ASH);
            recipe.pattern(" X ");
            recipe.pattern("X#X");
            recipe.pattern(" X ");
        });
        recipes.shapedCrafting("fertilizer_apatite", RecipeCategory.MISC, CoreItems.FERTILIZER_COMPOUND, 8, recipe -> {
            recipe.define('#', ItemTags.f_13137_);
            recipe.define('X', ForestryTags.Items.GEMS_APATITE);
            recipe.pattern(" # ");
            recipe.pattern(" X ");
            recipe.pattern(" # ");
        });
        recipes.shapedCrafting("fertilizer_ash", RecipeCategory.MISC, CoreItems.FERTILIZER_COMPOUND, 16, recipe -> {
            recipe.define('#', ForestryTags.Items.DUSTS_ASH);
            recipe.define('X', ForestryTags.Items.GEMS_APATITE);
            recipe.pattern("###");
            recipe.pattern("#X#");
            recipe.pattern("###");
        });
        recipes.shapedCrafting("humus_compost", RecipeCategory.BUILDING_BLOCKS, CoreBlocks.HUMUS, 8, recipe -> {
            recipe.define('#', (ItemLike)Blocks.f_50493_);
            recipe.define('X', CoreItems.COMPOST);
            recipe.pattern("###");
            recipe.pattern("#X#");
            recipe.pattern("###");
        });
        recipes.shapedCrafting("humus_fertilizer", RecipeCategory.BUILDING_BLOCKS, CoreBlocks.HUMUS, 8, recipe -> {
            recipe.define('#', (ItemLike)Blocks.f_50493_);
            recipe.define('X', CoreItems.FERTILIZER_COMPOUND);
            recipe.pattern("###");
            recipe.pattern("#X#");
            recipe.pattern("###");
        });
        ForestryRecipeProvider.bogRecipe(recipes, 8, ForestryRecipeProvider.getContainer(EnumContainerType.CAN, (Fluid)Fluids.f_76193_), "can");
        ForestryRecipeProvider.bogRecipe(recipes, 8, ForestryRecipeProvider.getContainer(EnumContainerType.CAPSULE, (Fluid)Fluids.f_76193_), "wax_capsule");
        ForestryRecipeProvider.bogRecipe(recipes, 8, ForestryRecipeProvider.getContainer(EnumContainerType.REFRACTORY, (Fluid)Fluids.f_76193_), "refractory");
        ForestryRecipeProvider.bogRecipe(recipes, 6, new ItemStack((ItemLike)Items.f_42447_), "bucket");
        recipes.shapedCrafting("can", RecipeCategory.MISC, (ItemLike)FluidsItems.CONTAINERS.get(EnumContainerType.CAN), 12, recipe -> {
            recipe.define('#', ForestryTags.Items.INGOTS_TIN);
            recipe.pattern(" # ");
            recipe.pattern("# #");
        });
        recipes.shapedCrafting("capsule", RecipeCategory.MISC, (ItemLike)FluidsItems.CONTAINERS.get(EnumContainerType.CAPSULE), 4, recipe -> {
            recipe.define('#', CoreItems.BEESWAX);
            recipe.pattern(" # ");
            recipe.pattern("# #");
        });
        recipes.shapedCrafting("refractory_capsule", RecipeCategory.MISC, (ItemLike)FluidsItems.CONTAINERS.get(EnumContainerType.REFRACTORY), 4, recipe -> {
            recipe.define('#', CoreItems.REFRACTORY_WAX);
            recipe.pattern(" # ");
            recipe.pattern("# #");
        });
        recipes.shapedCrafting("compressed_ice_shards", RecipeCategory.MISC, (ItemLike)Items.f_41980_, 1, recipe -> {
            recipe.define('#', (ItemLike)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.ICE_SHARD));
            recipe.pattern("##");
            recipe.pattern("##");
        });
        recipes.shapedCrafting("honey_drop_block", RecipeCategory.MISC, (ItemLike)Items.f_42788_, 1, recipe -> {
            recipe.define('V', ApicultureItems.HONEY_DROP);
            recipe.pattern("VVV");
            recipe.pattern("V V");
            recipe.pattern("VVV");
        });
        recipes.shapedCrafting("phosphor_torches", RecipeCategory.MISC, (ItemLike)Items.f_42000_, 6, recipe -> {
            recipe.define('P', (ItemLike)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.PHOSPHOR));
            recipe.define('|', Tags.Items.RODS_WOODEN);
            recipe.pattern(" P ");
            recipe.pattern(" | ");
        });
        recipes.shapedCrafting("beeswax_candles", RecipeCategory.MISC, (ItemLike)Items.f_151065_, 1, recipe -> {
            recipe.define('|', Tags.Items.STRING);
            recipe.define('^', CoreItems.BEESWAX);
            recipe.pattern(" | ");
            recipe.pattern(" ^ ");
        });
        recipes.shapelessCrafting("foresters_manual_honeydrop", RecipeCategory.MISC, CoreItems.FORESTERS_MANUAL, 1, new Object[]{Items.f_42517_, ApicultureItems.HONEY_DROP});
        recipes.shapelessCrafting("foresters_manual_sapling", RecipeCategory.MISC, CoreItems.FORESTERS_MANUAL, 1, new Object[]{Items.f_42517_, ItemTags.f_13180_});
        recipes.shapelessCrafting("foresters_manual_butterfly", RecipeCategory.MISC, CoreItems.FORESTERS_MANUAL, 1, new Object[]{Items.f_42517_, LepidopterologyItems.BUTTERFLY_GE});
    }

    private static void bogRecipe(MKRecipeProvider recipes, int amount, ItemStack container, String name) {
        recipes.shapedCrafting("bog_earth_" + name, RecipeCategory.BUILDING_BLOCKS, CoreBlocks.BOG_EARTH, amount, recipe -> {
            recipe.define('#', (ItemLike)Blocks.f_50493_);
            recipe.define('X', (Ingredient)StrictNBTIngredient.of((ItemStack)container));
            recipe.define('Y', ItemTags.f_13137_);
            recipe.pattern("#Y#");
            recipe.pattern("YXY");
            recipe.pattern("#Y#");
        });
    }

    private static void gear(MKRecipeProvider recipes, ItemLike gear, TagKey<Item> ingot) {
        recipes.shapedCrafting(RecipeCategory.MISC, gear, recipe -> {
            recipe.define('#', ingot);
            recipe.define('X', Tags.Items.NUGGETS_IRON);
            recipe.pattern(" # ");
            recipe.pattern("#X#");
            recipe.pattern(" # ");
        });
    }

    private static EnumElectronTube getElectronTube(BlockTypePlanter planter) {
        return switch (planter) {
            default -> throw new IncompatibleClassChangeError();
            case BlockTypePlanter.ARBORETUM -> EnumElectronTube.GOLD;
            case BlockTypePlanter.FARM_CROPS -> EnumElectronTube.BRONZE;
            case BlockTypePlanter.PEAT_POG -> EnumElectronTube.OBSIDIAN;
            case BlockTypePlanter.FARM_MUSHROOM -> EnumElectronTube.APATITE;
            case BlockTypePlanter.FARM_GOURD -> EnumElectronTube.LAPIS;
            case BlockTypePlanter.FARM_NETHER -> EnumElectronTube.BLAZE;
            case BlockTypePlanter.FARM_ENDER -> EnumElectronTube.ENDER;
        };
    }

    private static void registerCultivationRecipes(MKRecipeProvider recipes) {
        for (BlockTypePlanter planter : BlockTypePlanter.VALUES) {
            Object managed = ((FeatureBlock)CultivationBlocks.MANAGED_PLANTER.get(planter)).block();
            Object manual = ((FeatureBlock)CultivationBlocks.MANUAL_PLANTER.get(planter)).block();
            recipes.shapedCrafting(RecipeCategory.MISC, managed, recipe -> {
                recipe.define('G', Tags.Items.GLASS);
                recipe.define('T', (ItemLike)CoreItems.ELECTRON_TUBES.get(ForestryRecipeProvider.getElectronTube(planter)));
                recipe.define('C', CoreItems.FLEXIBLE_CASING);
                recipe.define('B', (ItemLike)CoreItems.CIRCUITBOARDS.get(EnumCircuitBoardType.BASIC));
                recipe.pattern("GTG");
                recipe.pattern("TCT");
                recipe.pattern("GBG");
            });
            recipes.shapelessCrafting(RecipeCategory.MISC, manual, 1, new Object[]{managed});
            recipes.shapelessCrafting(MKRecipeProvider.path(managed) + "_from_manual", RecipeCategory.MISC, managed, 1, new Object[]{manual});
        }
    }

    private static void registerFactoryRecipes(MKRecipeProvider recipes) {
        recipes.shapedCrafting(RecipeCategory.MISC, ((FeatureBlock)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.BOTTLER)).block(), recipe -> {
            recipe.define('#', Tags.Items.GLASS);
            recipe.define('X', (ItemLike)FluidsItems.CONTAINERS.get(EnumContainerType.CAN));
            recipe.define('Y', CoreItems.STURDY_CASING);
            recipe.pattern("X#X");
            recipe.pattern("#Y#");
            recipe.pattern("X#X");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, ((FeatureBlock)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.CARPENTER)).block(), recipe -> {
            recipe.define('#', Tags.Items.GLASS);
            recipe.define('X', ForestryTags.Items.INGOTS_BRONZE);
            recipe.define('Y', CoreItems.STURDY_CASING);
            recipe.pattern("X#X");
            recipe.pattern("XYX");
            recipe.pattern("X#X");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, ((FeatureBlock)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.CENTRIFUGE)).block(), recipe -> {
            recipe.define('#', Tags.Items.GLASS);
            recipe.define('X', Tags.Items.INGOTS_COPPER);
            recipe.define('Y', CoreItems.STURDY_CASING);
            recipe.pattern("X#X");
            recipe.pattern("XYX");
            recipe.pattern("X#X");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, ((FeatureBlock)FactoryBlocks.PLAIN.get(BlockTypeFactoryPlain.FABRICATOR)).block(), recipe -> {
            recipe.define('#', Tags.Items.GLASS);
            recipe.define('X', Tags.Items.INGOTS_GOLD);
            recipe.define('Y', CoreItems.STURDY_CASING);
            recipe.define('Z', Tags.Items.CHESTS_WOODEN);
            recipe.pattern("X#X");
            recipe.pattern("#Y#");
            recipe.pattern("XZX");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, ((FeatureBlock)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.FERMENTER)).block(), recipe -> {
            recipe.define('#', Tags.Items.GLASS);
            recipe.define('X', ForestryTags.Items.GEARS_BRONZE);
            recipe.define('Y', CoreItems.STURDY_CASING);
            recipe.pattern("X#X");
            recipe.pattern("#Y#");
            recipe.pattern("X#X");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, ((FeatureBlock)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.MOISTENER)).block(), recipe -> {
            recipe.define('#', Tags.Items.GLASS);
            recipe.define('X', ForestryTags.Items.GEARS_COPPER);
            recipe.define('Y', CoreItems.STURDY_CASING);
            recipe.pattern("X#X");
            recipe.pattern("#Y#");
            recipe.pattern("X#X");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, ((FeatureBlock)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.RAINMAKER)).block(), recipe -> {
            recipe.define('#', Tags.Items.GLASS);
            recipe.define('X', ForestryTags.Items.GEARS_TIN);
            recipe.define('Y', CoreItems.STURDY_CASING);
            recipe.pattern("X#X");
            recipe.pattern("#Y#");
            recipe.pattern("X#X");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, ((FeatureBlock)FactoryBlocks.PLAIN.get(BlockTypeFactoryPlain.RAINTANK)).block(), recipe -> {
            recipe.define('#', Tags.Items.GLASS);
            recipe.define('X', Tags.Items.INGOTS_IRON);
            recipe.define('Y', CoreItems.STURDY_CASING);
            recipe.pattern("X#X");
            recipe.pattern("XYX");
            recipe.pattern("X#X");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, ((FeatureBlock)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.SQUEEZER)).block(), recipe -> {
            recipe.define('#', Tags.Items.GLASS);
            recipe.define('X', ForestryTags.Items.INGOTS_TIN);
            recipe.define('Y', CoreItems.STURDY_CASING);
            recipe.pattern("X#X");
            recipe.pattern("XYX");
            recipe.pattern("X#X");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, ((FeatureBlock)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.STILL)).block(), recipe -> {
            recipe.define('#', Tags.Items.GLASS);
            recipe.define('X', Tags.Items.DUSTS_REDSTONE);
            recipe.define('Y', CoreItems.STURDY_CASING);
            recipe.pattern("X#X");
            recipe.pattern("#Y#");
            recipe.pattern("X#X");
        });
    }

    private static void registerFarmingRecipes(MKRecipeProvider recipes) {
        for (EnumFarmMaterial material : EnumFarmMaterial.values()) {
            Item base = material.getBase().m_5456_();
            recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)FarmingBlocks.FARM.get(EnumFarmBlockType.PLAIN, material), recipe -> {
                recipe.define('I', Tags.Items.INGOTS_COPPER);
                recipe.define('#', (ItemLike)base);
                recipe.define('C', (ItemLike)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.TIN));
                recipe.define('W', ItemTags.f_13175_);
                recipe.pattern("I#I");
                recipe.pattern("WCW");
            });
            recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)FarmingBlocks.FARM.get(EnumFarmBlockType.GEARBOX, material), recipe -> {
                recipe.define('T', ForestryTags.Items.GEARS_TIN);
                recipe.define('#', (ItemLike)base);
                recipe.pattern(" # ");
                recipe.pattern("TTT");
            });
            recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)FarmingBlocks.FARM.get(EnumFarmBlockType.HATCH, material), recipe -> {
                recipe.define('T', ForestryTags.Items.GEARS_TIN);
                recipe.define('#', (ItemLike)base);
                recipe.define('D', ItemTags.f_13178_);
                recipe.pattern(" # ");
                recipe.pattern("TDT");
            });
            recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)FarmingBlocks.FARM.get(EnumFarmBlockType.VALVE, material), recipe -> {
                recipe.define('T', ForestryTags.Items.GEARS_TIN);
                recipe.define('#', (ItemLike)base);
                recipe.define('X', Tags.Items.GLASS);
                recipe.pattern(" # ");
                recipe.pattern("XTX");
            });
            recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)FarmingBlocks.FARM.get(EnumFarmBlockType.CONTROL, material), recipe -> {
                recipe.define('T', (ItemLike)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.GOLD));
                recipe.define('#', (ItemLike)base);
                recipe.define('X', Tags.Items.DUSTS_REDSTONE);
                recipe.pattern(" # ");
                recipe.pattern("XTX");
            });
        }
    }

    private static void registerFluidsRecipes(MKRecipeProvider recipes) {
        for (EnumContainerType containerType : EnumContainerType.values()) {
            recipes.shapedCrafting("cake_" + containerType.m_7912_(), RecipeCategory.FOOD, (ItemLike)Items.f_42502_, recipe -> {
                recipe.define('A', (Ingredient)StrictNBTIngredient.of((ItemStack)ForestryRecipeProvider.getContainer(containerType, (Fluid)ForgeMod.MILK.get())));
                recipe.define('B', (ItemLike)Items.f_42501_);
                recipe.define('C', (ItemLike)Items.f_42405_);
                recipe.define('E', (ItemLike)Items.f_42521_);
                recipe.pattern("AAA");
                recipe.pattern("BEB");
                recipe.pattern("CCC");
            });
        }
    }

    private static void registerLepidopterologyRecipes(MKRecipeProvider recipes) {
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)CoreBlocks.NATURALIST_CHEST.get(NaturalistChestBlockType.LEPIDOPTERIST_CHEST), recipe -> {
            recipe.define('#', Tags.Items.GLASS);
            recipe.define('X', LepidopterologyItems.BUTTERFLY_GE);
            recipe.define('Y', Tags.Items.CHESTS_WOODEN);
            recipe.pattern(" # ");
            recipe.pattern("XYX");
            recipe.pattern("XXX");
        });
        recipes.special("butterfly_mating", LepidopterologyRecipes.MATING_SERIALIZER);
    }

    private static void registerMailRecipes(MKRecipeProvider recipes) {
        recipes.shapelessCrafting(RecipeCategory.MISC, MailItems.CATALOGUE, 1, new Object[]{Items.f_42517_, ForestryTags.Items.STAMPS});
        Ingredient sealant = Ingredient.merge(List.of(Ingredient.m_204132_(ForestryTags.Items.PROPOLIS), Ingredient.m_204132_((TagKey)Tags.Items.SLIMEBALLS)));
        recipes.shapelessCrafting(RecipeCategory.MISC, (ItemLike)MailItems.LETTERS.get(ItemLetter.Size.EMPTY, ItemLetter.State.FRESH), 1, new Object[]{Items.f_42516_, sealant});
        recipes.shapedCrafting(RecipeCategory.MISC, ((FeatureBlock)MailBlocks.BASE.get(BlockTypeMail.MAILBOX)).block(), recipe -> {
            recipe.define('#', ForestryTags.Items.INGOTS_TIN);
            recipe.define('X', Tags.Items.CHESTS_WOODEN);
            recipe.define('Y', CoreItems.STURDY_CASING);
            recipe.pattern(" # ");
            recipe.pattern("#Y#");
            recipe.pattern("XXX");
        });
        Item[] emptiedLetter = (Item[])MailItems.LETTERS.getRowFeatures(ItemLetter.Size.EMPTY).stream().map(FeatureItem::item).toArray(Item[]::new);
        recipes.shapedCrafting("paper_from_letters", RecipeCategory.MISC, (ItemLike)Items.f_42516_, recipe -> {
            recipe.define('#', Ingredient.m_43929_((ItemLike[])emptiedLetter));
            recipe.pattern(" # ");
            recipe.pattern(" # ");
            recipe.pattern(" # ");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, ((FeatureBlock)MailBlocks.BASE.get(BlockTypeMail.TRADE_STATION)).block(), recipe -> {
            recipe.define('#', (ItemLike)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.BRONZE));
            recipe.define('X', Tags.Items.CHESTS_WOODEN);
            recipe.define('Y', CoreItems.STURDY_CASING);
            recipe.define('Z', (ItemLike)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.IRON));
            recipe.define('W', (Ingredient)StrictNBTIngredient.of((ItemStack)ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.REFINED, null, new ICircuit[0])));
            recipe.pattern("Z#Z");
            recipe.pattern("#Y#");
            recipe.pattern("XWX");
        });
        Ingredient glue = Ingredient.merge(List.of(Ingredient.m_204132_(ForestryTags.Items.DROP_HONEY), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42518_})));
        for (EnumStampDefinition stampDefinition : EnumStampDefinition.VALUES) {
            recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)MailItems.STAMPS.get(stampDefinition), 9, recipe -> {
                recipe.define('X', stampDefinition.getCraftingIngredient());
                recipe.define('#', (ItemLike)Items.f_42516_);
                recipe.define('Z', glue);
                recipe.pattern("XXX");
                recipe.pattern("###");
                recipe.pattern("ZZZ");
            });
        }
    }

    private static void registerSortingRecipes(MKRecipeProvider recipes) {
        Ingredient ing = Ingredient.merge(List.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{LepidopterologyItems.CATERPILLAR_GE, (ItemLike)ApicultureItems.PROPOLIS.get(EnumPropolis.NORMAL)}), Ingredient.m_204132_(ForestryTags.Items.FORESTRY_FRUITS)));
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)SortingBlocks.FILTER.block(), 2, recipe -> {
            recipe.define('B', ForestryTags.Items.GEARS_BRONZE);
            recipe.define('D', Tags.Items.GEMS_DIAMOND);
            recipe.define('F', ing);
            recipe.define('W', ItemTags.f_13168_);
            recipe.define('G', Tags.Items.GLASS);
            recipe.pattern("WDW");
            recipe.pattern("FGF");
            recipe.pattern("BDB");
        });
    }

    private static void registerWorktableRecipes(MKRecipeProvider recipes) {
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)WorktableBlocks.WORKTABLE.block(), recipe -> {
            recipe.define('B', (ItemLike)Items.f_42517_);
            recipe.define('T', ForestryTags.Items.CRAFTING_TABLES);
            recipe.define('C', Tags.Items.CHESTS_WOODEN);
            recipe.pattern("B");
            recipe.pattern("T");
            recipe.pattern("C");
        });
    }

    private static void registerEnergyRecipes(MKRecipeProvider recipes) {
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)EnergyBlocks.ENGINES.get(EngineBlockType.CLOCKWORK), recipe -> {
            recipe.define('P', ItemTags.f_13168_);
            recipe.define('I', Tags.Items.GLASS);
            recipe.define('Q', ForestryTags.Items.GEARS_COPPER);
            recipe.define('D', (ItemLike)Items.f_41869_);
            recipe.define('C', (ItemLike)Items.f_42524_);
            recipe.pattern("PPP");
            recipe.pattern(" I ");
            recipe.pattern("QDC");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)EnergyBlocks.ENGINES.get(EngineBlockType.BIOGAS), recipe -> {
            recipe.define('P', ForestryTags.Items.INGOTS_BRONZE);
            recipe.define('I', Tags.Items.GLASS);
            recipe.define('Q', ForestryTags.Items.GEARS_BRONZE);
            recipe.define('D', (ItemLike)Items.f_41869_);
            recipe.pattern("PPP");
            recipe.pattern(" I ");
            recipe.pattern("QDQ");
        });
        recipes.shapedCrafting(RecipeCategory.MISC, (ItemLike)EnergyBlocks.ENGINES.get(EngineBlockType.PEAT), recipe -> {
            recipe.define('P', Tags.Items.INGOTS_COPPER);
            recipe.define('I', Tags.Items.GLASS);
            recipe.define('Q', ForestryTags.Items.GEARS_COPPER);
            recipe.define('D', (ItemLike)Items.f_41869_);
            recipe.pattern("PPP");
            recipe.pattern(" I ");
            recipe.pattern("QDQ");
        });
    }

    private static void registerCarpenter(Consumer<FinishedRecipe> consumer) {
        new CarpenterRecipeBuilder().setPackagingTime(50).setLiquid(ForestryFluids.SEED_OIL.getFluid(250)).setBox(Ingredient.f_43901_).recipe(ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, CoreItems.IMPREGNATED_CASING).m_126130_("###").m_126130_("# #").m_126130_("###").m_206416_(Character.valueOf('#'), ItemTags.f_13182_)).build(consumer, ForestryRecipeProvider.id("carpenter", "impregnated_casing"));
        new CarpenterRecipeBuilder().setPackagingTime(50).setLiquid(ForestryFluids.SEED_OIL.getFluid(500)).setBox(Ingredient.f_43901_).recipe(ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, ((FeatureBlock)CoreBlocks.BASE.get(BlockTypeCoreTesr.ESCRITOIRE)).item()).m_126130_("#  ").m_126130_("###").m_126130_("# #").m_206416_(Character.valueOf('#'), ItemTags.f_13168_)).build(consumer, ForestryRecipeProvider.id("carpenter", "escritoire"));
        new CarpenterRecipeBuilder().setPackagingTime(50).setLiquid(ForestryFluids.SEED_OIL.getFluid(100)).setBox(Ingredient.f_43901_).recipe(ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)CoreItems.CRAFTING_MATERIALS.item(EnumCraftingMaterial.IMPREGNATED_STICK), (int)2).m_126130_("#").m_126130_("#").m_206416_(Character.valueOf('#'), ItemTags.f_13182_)).build(consumer, ForestryRecipeProvider.id("carpenter", "impregnated_stick"));
        new CarpenterRecipeBuilder().setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 250)).setBox(Ingredient.f_43901_).recipe(ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)CoreItems.CRAFTING_MATERIALS.item(EnumCraftingMaterial.WOOD_PULP), (int)4).m_206419_(ItemTags.f_13182_)).build(consumer, ForestryRecipeProvider.id("carpenter", "wood_pulp"));
        new CarpenterRecipeBuilder().setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 1000)).setBox(Ingredient.f_43901_).recipe(ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, CoreBlocks.HUMUS, (int)9).m_126130_("###").m_126130_("#X#").m_126130_("###").m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42329_).m_126127_(Character.valueOf('X'), CoreItems.MULCH)).build(consumer, ForestryRecipeProvider.id("carpenter", "humus"));
        new CarpenterRecipeBuilder().setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 1000)).setBox(Ingredient.f_43901_).recipe(ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, CoreBlocks.BOG_EARTH, (int)8).m_126130_("#X#").m_126130_("XYX").m_126130_("#X#").m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42329_).m_206416_(Character.valueOf('X'), Tags.Items.SAND).m_126127_(Character.valueOf('Y'), CoreItems.MULCH)).build(consumer, ForestryRecipeProvider.id("carpenter", "bog_earth"));
        new CarpenterRecipeBuilder().setPackagingTime(75).setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 5000)).setBox(Ingredient.f_43901_).recipe(ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, CoreItems.HARDENED_CASING).m_126130_("X X").m_126130_(" Y ").m_126130_("X X").m_206416_(Character.valueOf('X'), Tags.Items.GEMS_DIAMOND).m_126127_(Character.valueOf('Y'), CoreItems.STURDY_CASING)).build(consumer, ForestryRecipeProvider.id("carpenter", "hardened_casing"));
        new CarpenterRecipeBuilder().setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 1000)).setBox(Ingredient.f_43901_).recipe(ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, CoreItems.IODINE_CHARGE).m_126130_("Z#Z").m_126130_("#Y#").m_126130_("X#X").m_126127_(Character.valueOf('#'), (ItemLike)ApicultureItems.POLLEN_CLUSTER.get(EnumPollenCluster.NORMAL)).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42403_).m_126127_(Character.valueOf('Y'), (ItemLike)FluidsItems.CONTAINERS.get(EnumContainerType.CAN)).m_126127_(Character.valueOf('Z'), ApicultureItems.HONEY_DROP)).build(consumer, ForestryRecipeProvider.id("carpenter", "iodine_charge"));
        new CarpenterRecipeBuilder().setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 1000)).setBox(Ingredient.f_43901_).recipe(ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, CoreItems.DISSIPATION_CHARGE).m_126130_("Z#Z").m_126130_("#Y#").m_126130_("X#X").m_126127_(Character.valueOf('#'), ApicultureItems.ROYAL_JELLY).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42403_).m_126127_(Character.valueOf('Y'), (ItemLike)FluidsItems.CONTAINERS.get(EnumContainerType.CAN)).m_126127_(Character.valueOf('Z'), ApicultureItems.HONEYDEW)).build(consumer, ForestryRecipeProvider.id("carpenter", "dissipation_charge"));
        new CarpenterRecipeBuilder().setPackagingTime(100).setBox(Ingredient.f_43901_).recipe(ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.f_42584_).m_126130_(" # ").m_126130_("###").m_126130_(" # ").m_126127_(Character.valueOf('#'), (ItemLike)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.PULSATING_MESH))).build(consumer, ForestryRecipeProvider.id("carpenter", "ender_pearl"));
        new CarpenterRecipeBuilder().setPackagingTime(10).setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 500)).setBox(Ingredient.f_43901_).recipe(ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.WOVEN_SILK))).m_126130_("XX").m_126130_("XX").m_126127_(Character.valueOf('X'), (ItemLike)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.SILK_WISP))).build(consumer, ForestryRecipeProvider.id("carpenter", "woven_silk"));
        new CarpenterRecipeBuilder().setBox(Ingredient.f_43901_).recipe(ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, CoreItems.INGOT_BRONZE, (int)2).m_126209_(CoreItems.BROKEN_BRONZE_PICKAXE)).build(consumer, ForestryRecipeProvider.id("carpenter", "reclaim_bronze_pickaxe"));
        new CarpenterRecipeBuilder().setBox(Ingredient.f_43901_).recipe(ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, CoreItems.INGOT_BRONZE, (int)1).m_126209_(CoreItems.BROKEN_BRONZE_SHOVEL)).build(consumer, ForestryRecipeProvider.id("carpenter", "reclaim_bronze_shovel"));
        new CarpenterRecipeBuilder().setBox(Ingredient.f_43901_).recipe(ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, CoreItems.INGOT_BRONZE, (int)2).m_126209_(CoreItems.BROKEN_BRONZE_AXE)).build(consumer, ForestryRecipeProvider.id("carpenter", "reclaim_bronze_axe"));
        new CarpenterRecipeBuilder().setBox(Ingredient.f_43901_).recipe(ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, CoreItems.INGOT_BRONZE, (int)1).m_126209_(CoreItems.BROKEN_BRONZE_SWORD)).build(consumer, ForestryRecipeProvider.id("carpenter", "reclaim_bronze_sword"));
        new CarpenterRecipeBuilder().setBox(Ingredient.f_43901_).recipe(ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, CoreItems.INGOT_BRONZE, (int)1).m_126209_(CoreItems.BROKEN_BRONZE_HOE)).build(consumer, ForestryRecipeProvider.id("carpenter", "reclaim_bronze_hoe"));
        new CarpenterRecipeBuilder().setPackagingTime(50).setLiquid(ForestryFluids.HONEY.getFluid(500)).setBox(Ingredient.f_43901_).recipe(ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.SCENTED_PANELING))).m_126130_(" J ").m_126130_("###").m_126130_("WPW").m_206416_(Character.valueOf('#'), ItemTags.f_13168_).m_126127_(Character.valueOf('J'), ApicultureItems.ROYAL_JELLY).m_126127_(Character.valueOf('W'), CoreItems.BEESWAX).m_126127_(Character.valueOf('P'), (ItemLike)ApicultureItems.POLLEN_CLUSTER.get(EnumPollenCluster.NORMAL))).build(consumer, ForestryRecipeProvider.id("carpenter", "scented_paneling"));
        new CarpenterRecipeBuilder().setPackagingTime(100).setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 2000)).setBox(Ingredient.f_43901_).recipe(ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, CoreItems.PORTABLE_ALYZER).m_126130_("X#X").m_126130_("X#X").m_126130_("RDR").m_206416_(Character.valueOf('#'), Tags.Items.GLASS_PANES).m_206416_(Character.valueOf('X'), ForestryTags.Items.INGOTS_TIN).m_206416_(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND)).build(consumer, ForestryRecipeProvider.id("carpenter", "portable_analyzer"));
        new CarpenterRecipeBuilder().setPackagingTime(20).setBox(Ingredient.m_43929_((ItemLike[])new ItemLike[]{CoreItems.CARTON})).recipe(ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, CoreItems.KIT_PICKAXE).m_126130_("###").m_126130_(" X ").m_126130_(" X ").m_206416_(Character.valueOf('#'), ForestryTags.Items.INGOTS_BRONZE).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42398_)).build(consumer, ForestryRecipeProvider.id("carpenter", "kit_pickaxe"));
        new CarpenterRecipeBuilder().setPackagingTime(20).setBox(Ingredient.m_43929_((ItemLike[])new ItemLike[]{CoreItems.CARTON})).recipe(ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, CoreItems.KIT_SHOVEL).m_126130_(" # ").m_126130_(" X ").m_126130_(" X ").m_206416_(Character.valueOf('#'), ForestryTags.Items.INGOTS_BRONZE).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42398_)).build(consumer, ForestryRecipeProvider.id("carpenter", "kit_shovel"));
        new CarpenterRecipeBuilder().setPackagingTime(20).setBox(Ingredient.m_43929_((ItemLike[])new ItemLike[]{CoreItems.CARTON})).recipe(ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, CoreItems.KIT_AXE).m_126130_("## ").m_126130_("#X ").m_126130_(" X ").m_206416_(Character.valueOf('#'), ForestryTags.Items.INGOTS_BRONZE).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42398_)).build(consumer, ForestryRecipeProvider.id("carpenter", "kit_axe"));
        new CarpenterRecipeBuilder().setPackagingTime(20).setBox(Ingredient.m_43929_((ItemLike[])new ItemLike[]{CoreItems.CARTON})).recipe(ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, CoreItems.KIT_SWORD).m_126130_(" # ").m_126130_(" # ").m_126130_(" X ").m_206416_(Character.valueOf('#'), ForestryTags.Items.INGOTS_BRONZE).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42398_)).build(consumer, ForestryRecipeProvider.id("carpenter", "kit_sword"));
        new CarpenterRecipeBuilder().setPackagingTime(20).setBox(Ingredient.m_43929_((ItemLike[])new ItemLike[]{CoreItems.CARTON})).recipe(ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, CoreItems.KIT_HOE).m_126130_("## ").m_126130_(" X ").m_126130_(" X ").m_206416_(Character.valueOf('#'), ForestryTags.Items.INGOTS_BRONZE).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42398_)).build(consumer, ForestryRecipeProvider.id("carpenter", "kit_hoe"));
        new CarpenterRecipeBuilder().setPackagingTime(40).setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 1000)).setBox(Ingredient.f_43901_).recipe(ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, CoreItems.SOLDERING_IRON).m_126130_(" # ").m_126130_("# #").m_126130_("  B").m_206416_(Character.valueOf('#'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('B'), ForestryTags.Items.INGOTS_BRONZE)).build(consumer, ForestryRecipeProvider.id("carpenter", "soldering_iron"));
        new CarpenterRecipeBuilder().setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 250)).setBox(Ingredient.f_43901_).recipe(ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.f_42516_).m_126130_("#").m_126130_("#").m_126127_(Character.valueOf('#'), (ItemLike)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.WOOD_PULP))).build(consumer, ForestryRecipeProvider.id("carpenter", "paper"));
        new CarpenterRecipeBuilder().setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 1000)).setBox(Ingredient.f_43901_).recipe(ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, CoreItems.CARTON, (int)2).m_126130_(" # ").m_126130_("# #").m_126130_(" # ").m_126127_(Character.valueOf('#'), (ItemLike)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.WOOD_PULP))).build(consumer, ForestryRecipeProvider.id("carpenter", "carton"));
        for (EnumStampDefinition stamp : EnumStampDefinition.VALUES) {
            FeatureItem item = (FeatureItem)MailItems.STAMPS.get(stamp);
            new CarpenterRecipeBuilder().setLiquid(ForestryFluids.SEED_OIL.getFluid(300)).setBox(Ingredient.f_43901_).recipe(ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)item, (int)9).m_126130_("###").m_126130_("PPP").m_126124_(Character.valueOf('#'), stamp.getCraftingIngredient()).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42516_)).build(consumer, ForestryRecipeProvider.id("carpenter", item.getName()));
        }
        ItemStack basic = ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.BASIC, null, new ICircuit[0]);
        ItemStack enhanced = ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.ENHANCED, null, new ICircuit[0]);
        ItemStack refined = ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.REFINED, null, new ICircuit[0]);
        ItemStack intricate = ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.INTRICATE, null, new ICircuit[0]);
        new CarpenterRecipeBuilder().setPackagingTime(20).setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 1000)).setBox(Ingredient.f_43901_).override(basic).recipe(ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)CoreItems.CIRCUITBOARDS.get(EnumCircuitBoardType.BASIC))).m_126130_("R R").m_126130_("R#R").m_126130_("R R").m_206416_(Character.valueOf('#'), ForestryTags.Items.INGOTS_TIN).m_206416_(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE)).build(consumer, ForestryRecipeProvider.id("carpenter", "circuits", "basic"));
        new CarpenterRecipeBuilder().setPackagingTime(40).setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 1000)).setBox(Ingredient.f_43901_).override(enhanced).recipe(ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)CoreItems.CIRCUITBOARDS.get(EnumCircuitBoardType.ENHANCED))).m_126130_("R#R").m_126130_("R#R").m_126130_("R#R").m_206416_(Character.valueOf('#'), ForestryTags.Items.INGOTS_BRONZE).m_206416_(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE)).build(consumer, ForestryRecipeProvider.id("carpenter", "circuits", "enhanced"));
        new CarpenterRecipeBuilder().setPackagingTime(80).setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 1000)).setBox(Ingredient.f_43901_).override(refined).recipe(ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)CoreItems.CIRCUITBOARDS.get(EnumCircuitBoardType.REFINED))).m_126130_("R#R").m_126130_("R#R").m_126130_("R#R").m_206416_(Character.valueOf('#'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE)).build(consumer, ForestryRecipeProvider.id("carpenter", "circuits", "refined"));
        new CarpenterRecipeBuilder().setPackagingTime(80).setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 1000)).setBox(Ingredient.f_43901_).override(intricate).recipe(ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)CoreItems.CIRCUITBOARDS.get(EnumCircuitBoardType.INTRICATE))).m_126130_("R#R").m_126130_("R#R").m_126130_("R#R").m_206416_(Character.valueOf('#'), Tags.Items.INGOTS_GOLD).m_206416_(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE)).build(consumer, ForestryRecipeProvider.id("carpenter", "circuits", "intricate"));
        new CarpenterRecipeBuilder().setBox(Ingredient.f_43901_).recipe(ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Items.f_151065_, (int)4).m_126130_("# #").m_126130_(" X ").m_126130_("# #").m_126127_(Character.valueOf('#'), CoreItems.BEESWAX).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42401_)).build(consumer, ForestryRecipeProvider.id("carpenter", "candles"));
        new CarpenterRecipeBuilder().setPackagingTime(20).setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 1000)).setBox(Ingredient.f_43901_).recipe(ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, CrateItems.CRATE, (int)24).m_126130_(" # ").m_126130_("# #").m_126130_(" # ").m_206416_(Character.valueOf('#'), ItemTags.f_13182_)).build(consumer, ForestryRecipeProvider.id("carpenter", "crates", "empty"));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_PEAT.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{CoreItems.PEAT}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_APATITE.get(), Ingredient.m_204132_(ForestryTags.Items.GEMS_APATITE));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_FERTILIZER_COMPOUND.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{CoreItems.FERTILIZER_COMPOUND}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_MULCH.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{CoreItems.MULCH}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_PHOSPHOR.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{CoreItems.CRAFTING_MATERIALS.item(EnumCraftingMaterial.PHOSPHOR)}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_ASH.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{CoreItems.ASH}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_TIN.get(), Ingredient.m_204132_(ForestryTags.Items.INGOTS_TIN));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_COPPER.get(), Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_COPPER));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_BRONZE.get(), Ingredient.m_204132_(ForestryTags.Items.INGOTS_BRONZE));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_HUMUS.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{CoreBlocks.HUMUS}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_BOG_EARTH.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{CoreBlocks.BOG_EARTH}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_WHEAT.get(), Ingredient.m_204132_((TagKey)Tags.Items.CROPS_WHEAT));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_COOKIE.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42572_}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_REDSTONE.get(), Ingredient.m_204132_((TagKey)Tags.Items.DUSTS_REDSTONE));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_LAPIS.get(), Ingredient.m_204132_((TagKey)Tags.Items.GEMS_LAPIS));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_SUGAR_CANE.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41909_}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_CLAY_BALL.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42461_}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_GLOWSTONE.get(), Ingredient.m_204132_((TagKey)Tags.Items.DUSTS_GLOWSTONE));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_APPLE.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42410_}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_COAL.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42413_}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_CHARCOAL.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42414_}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_SEEDS.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42404_}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_POTATO.get(), Ingredient.m_204132_((TagKey)Tags.Items.CROPS_POTATO));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_CARROT.get(), Ingredient.m_204132_((TagKey)Tags.Items.CROPS_CARROT));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_BEETROOT.get(), Ingredient.m_204132_((TagKey)Tags.Items.CROPS_BEETROOT));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_NETHER_WART.get(), Ingredient.m_204132_((TagKey)Tags.Items.CROPS_NETHER_WART));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_OAK_LOG.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41837_}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_BIRCH_LOG.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41839_}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_JUNGLE_LOG.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41840_}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_SPRUCE_LOG.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41838_}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_ACACIA_LOG.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41841_}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_DARK_OAK_LOG.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41842_}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_COBBLESTONE.get(), Ingredient.m_204132_((TagKey)Tags.Items.COBBLESTONE));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_DIRT.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42329_}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_GRASS_BLOCK.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42276_}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_STONE.get(), Ingredient.m_204132_((TagKey)Tags.Items.STONE));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_GRANITE.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41958_}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_DIORITE.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42064_}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_ANDESITE.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42170_}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_PRISMARINE.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42192_}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_PRISMARINE_BRICKS.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42193_}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_DARK_PRISMARINE.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42194_}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_BRICKS.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41995_}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_CACTUS.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41982_}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_SAND.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41830_}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_RED_SAND.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41831_}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_OBSIDIAN.get(), Ingredient.m_204132_((TagKey)Tags.Items.OBSIDIAN));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_NETHERRACK.get(), Ingredient.m_204132_((TagKey)Tags.Items.NETHERRACK));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_SOUL_SAND.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42049_}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_SANDSTONE.get(), Ingredient.m_204132_((TagKey)Tags.Items.SANDSTONE));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_NETHER_BRICKS.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42095_}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_MYCELIUM.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42093_}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_GRAVEL.get(), Ingredient.m_204132_((TagKey)Tags.Items.GRAVEL));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_OAK_SAPLING.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42799_}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_BIRCH_SAPLING.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42801_}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_JUNGLE_SAPLING.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41826_}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_SPRUCE_SAPLING.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42800_}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_ACACIA_SAPLING.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41827_}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_DARK_OAK_SAPLING.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41828_}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_BEESWAX.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{CoreItems.BEESWAX}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_REFRACTORY_WAX.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{CoreItems.REFRACTORY_WAX}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_POLLEN_CLUSTER_NORMAL.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.POLLEN_CLUSTER.get(EnumPollenCluster.NORMAL)}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_POLLEN_CLUSTER_CRYSTALLINE.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.POLLEN_CLUSTER.get(EnumPollenCluster.CRYSTALLINE)}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_PROPOLIS.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.PROPOLIS.get(EnumPropolis.NORMAL)}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_HONEYDEW.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{ApicultureItems.HONEYDEW}));
        ForestryRecipeProvider.crate(consumer, (ItemCrated)CrateItems.CRATED_ROYAL_JELLY.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{ApicultureItems.ROYAL_JELLY}));
        for (EnumHoneyComb comb : EnumHoneyComb.VALUES) {
            ForestryRecipeProvider.crate(consumer, (ItemCrated)((FeatureItem)CrateItems.CRATED_BEE_COMBS.get(comb)).get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.BEE_COMBS.get(comb)}));
        }
        new CarpenterRecipeBuilder().setPackagingTime(10).setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 250)).setBox(Ingredient.f_43901_).recipe(ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, ((FeatureItem)MailItems.LETTERS.get(ItemLetter.Size.EMPTY, ItemLetter.State.FRESH)).item()).m_126130_("###").m_126130_("###").m_126127_(Character.valueOf('#'), (ItemLike)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.WOOD_PULP))).build(consumer, ForestryRecipeProvider.id("carpenter", "letter_pulp"));
        ForestryRecipeProvider.wovenBackpack(consumer, "miner", BackpackItems.MINER_BACKPACK, BackpackItems.MINER_BACKPACK_T_2);
        ForestryRecipeProvider.wovenBackpack(consumer, "digger", BackpackItems.DIGGER_BACKPACK, BackpackItems.DIGGER_BACKPACK_T_2);
        ForestryRecipeProvider.wovenBackpack(consumer, "forester", BackpackItems.FORESTER_BACKPACK, BackpackItems.FORESTER_BACKPACK_T_2);
        ForestryRecipeProvider.wovenBackpack(consumer, "hunter", BackpackItems.HUNTER_BACKPACK, BackpackItems.HUNTER_BACKPACK_T_2);
        ForestryRecipeProvider.wovenBackpack(consumer, "adventurer", BackpackItems.ADVENTURER_BACKPACK, BackpackItems.ADVENTURER_BACKPACK_T_2);
        ForestryRecipeProvider.wovenBackpack(consumer, "builder", BackpackItems.BUILDER_BACKPACK, BackpackItems.BUILDER_BACKPACK_T_2);
    }

    private static void wovenBackpack(Consumer<FinishedRecipe> consumer, String id, FeatureItem<?> tier1, FeatureItem<?> tier2) {
        new CarpenterRecipeBuilder().setPackagingTime(200).setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 1000)).setBox(Ingredient.f_43901_).recipe(ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, tier2).m_126130_("WXW").m_126130_("WTW").m_126130_("WWW").m_126127_(Character.valueOf('W'), (ItemLike)CoreItems.CRAFTING_MATERIALS.stack(EnumCraftingMaterial.WOVEN_SILK).m_41720_()).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42415_).m_126127_(Character.valueOf('T'), tier1)).build(consumer, ForestryRecipeProvider.id("woven_backpack", id));
    }

    private static void crate(Consumer<FinishedRecipe> consumer, ItemCrated crated, Ingredient ingredient) {
        ItemStack contained = crated.getContained();
        ResourceLocation name = ModUtil.getRegistryName(contained.m_41720_());
        new CarpenterRecipeBuilder().setPackagingTime(5).setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 100)).setBox(Ingredient.m_43929_((ItemLike[])new ItemLike[]{CrateItems.CRATE})).recipe(ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)crated, (int)1).m_126130_("###").m_126130_("###").m_126130_("###").m_126124_(Character.valueOf('#'), ingredient)).build(consumer, ForestryRecipeProvider.id("carpenter", "crates", "pack", name.m_135827_(), name.m_135815_()));
        new CarpenterRecipeBuilder().setPackagingTime(5).setBox(Ingredient.f_43901_).recipe(ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)contained.m_41720_(), (int)9).m_126209_((ItemLike)crated)).build(consumer, ForestryRecipeProvider.id("carpenter", "crates", "unpack", name.m_135827_(), name.m_135815_()));
    }

    private static void registerCentrifuge(Consumer<FinishedRecipe> consumer) {
        ItemStack honeyDrop = ApicultureItems.HONEY_DROP.stack();
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.HONEY)})).product(1.0f, CoreItems.BEESWAX.stack()).product(0.9f, honeyDrop).build(consumer, ForestryRecipeProvider.id("centrifuge", "honey_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.COCOA)})).product(1.0f, CoreItems.BEESWAX.stack()).product(0.5f, new ItemStack((ItemLike)Items.f_42533_)).build(consumer, ForestryRecipeProvider.id("centrifuge", "cocoa_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.SIMMERING)})).product(1.0f, CoreItems.REFRACTORY_WAX.stack()).product(0.7f, honeyDrop).build(consumer, ForestryRecipeProvider.id("centrifuge", "simmering_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.STRINGY)})).product(1.0f, ApicultureItems.PROPOLIS.stack(EnumPropolis.NORMAL, 1)).product(0.4f, honeyDrop).build(consumer, ForestryRecipeProvider.id("centrifuge", "stringy_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.DRIPPING)})).product(1.0f, ApicultureItems.HONEYDEW.stack()).product(0.4f, honeyDrop).build(consumer, ForestryRecipeProvider.id("centrifuge", "dripping_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.FROZEN)})).product(0.8f, CoreItems.BEESWAX.stack()).product(0.7f, honeyDrop).product(0.4f, new ItemStack((ItemLike)Items.f_42452_)).product(0.2f, ApicultureItems.POLLEN_CLUSTER.stack(EnumPollenCluster.CRYSTALLINE, 1)).build(consumer, ForestryRecipeProvider.id("centrifuge", "frozen_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.SILKY)})).product(1.0f, honeyDrop).product(0.8f, ApicultureItems.PROPOLIS.stack(EnumPropolis.SILKY, 1)).build(consumer, ForestryRecipeProvider.id("centrifuge", "silky_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.PARCHED)})).product(1.0f, CoreItems.BEESWAX.stack()).product(0.9f, honeyDrop).build(consumer, ForestryRecipeProvider.id("centrifuge", "parched_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.MYSTERIOUS)})).product(1.0f, ApicultureItems.PROPOLIS.stack(EnumPropolis.PULSATING, 1)).product(0.4f, honeyDrop).build(consumer, ForestryRecipeProvider.id("centrifuge", "mysterious_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.POWDERY)})).product(0.2f, honeyDrop).product(0.2f, CoreItems.BEESWAX.stack()).product(0.9f, new ItemStack((ItemLike)Items.f_42403_)).build(consumer, ForestryRecipeProvider.id("centrifuge", "powdery_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.WHEATEN)})).product(0.2f, honeyDrop).product(0.2f, CoreItems.BEESWAX.stack()).product(0.8f, new ItemStack((ItemLike)Items.f_42405_)).build(consumer, ForestryRecipeProvider.id("centrifuge", "wheaten_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.MOSSY)})).product(1.0f, CoreItems.BEESWAX.stack()).product(0.9f, honeyDrop).build(consumer, ForestryRecipeProvider.id("centrifuge", "mossy_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.KAOLIN)})).product(1.0f, new ItemStack((ItemLike)Items.f_42461_)).product(0.9f, honeyDrop).build(consumer, ForestryRecipeProvider.id("centrifuge", "kaolin_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.MELLOW)})).product(0.6f, ApicultureItems.HONEYDEW.stack()).product(0.2f, CoreItems.BEESWAX.stack()).product(0.3f, new ItemStack((ItemLike)Items.f_42692_)).build(consumer, ForestryRecipeProvider.id("centrifuge", "mellow_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.VINTAGE)})).product(1.0f, CoreItems.BEESWAX.stack()).product(0.9f, ApicultureItems.HONEYDEW.stack()).build(consumer, ForestryRecipeProvider.id("centrifuge", "vintage_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.SCULKEN)})).product(1.0f, CoreItems.BEESWAX.stack()).product(0.9f, ApicultureItems.EXPERIENCE_DROP.stack()).product(0.2f, new ItemStack((ItemLike)Items.f_220192_)).build(consumer, ForestryRecipeProvider.id("centrifuge", "sculken_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(5).setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.PROPOLIS.get(EnumPropolis.SILKY)})).product(0.6f, CoreItems.CRAFTING_MATERIALS.stack(EnumCraftingMaterial.SILK_WISP, 1)).product(0.1f, ApicultureItems.PROPOLIS.stack(EnumPropolis.NORMAL, 1)).build(consumer, ForestryRecipeProvider.id("centrifuge", "silky_propolis"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42784_})).product(1.0f, CoreItems.BEESWAX.stack()).build(consumer, ForestryRecipeProvider.id("centrifuge", "comb_to_wax"));
    }

    private static void registerFabricator(Consumer<FinishedRecipe> consumer) {
        FluidStack liquidGlass = ForestryFluids.GLASS.getFluid(500);
        new FabricatorRecipeBuilder().setPlan(Ingredient.f_43901_).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.IRON)), (int)4).m_126130_(" X ").m_126130_("#X#").m_126130_("XXX").m_206416_(Character.valueOf('#'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('X'), Tags.Items.INGOTS_IRON)).build(consumer, ForestryRecipeProvider.id("fabricator", "electron_tubes", "iron"));
        new FabricatorRecipeBuilder().setPlan(Ingredient.f_43901_).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.GOLD)), (int)4).m_126130_(" X ").m_126130_("#X#").m_126130_("XXX").m_206416_(Character.valueOf('#'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('X'), Tags.Items.INGOTS_GOLD)).build(consumer, ForestryRecipeProvider.id("fabricator", "electron_tubes", "gold"));
        new FabricatorRecipeBuilder().setPlan(Ingredient.f_43901_).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.DIAMOND)), (int)4).m_126130_(" X ").m_126130_("#X#").m_126130_("XXX").m_206416_(Character.valueOf('#'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('X'), Tags.Items.GEMS_DIAMOND)).build(consumer, ForestryRecipeProvider.id("fabricator", "electron_tubes", "diamond"));
        new FabricatorRecipeBuilder().setPlan(Ingredient.f_43901_).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.OBSIDIAN)), (int)4).m_126130_(" X ").m_126130_("#X#").m_126130_("XXX").m_206416_(Character.valueOf('#'), Tags.Items.DUSTS_REDSTONE).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_41999_)).build(consumer, ForestryRecipeProvider.id("fabricator", "electron_tubes", "obsidian"));
        new FabricatorRecipeBuilder().setPlan(Ingredient.f_43901_).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.BLAZE)), (int)4).m_126130_(" X ").m_126130_("#X#").m_126130_("XXX").m_206416_(Character.valueOf('#'), Tags.Items.DUSTS_REDSTONE).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42593_)).build(consumer, ForestryRecipeProvider.id("fabricator", "electron_tubes", "blaze"));
        new FabricatorRecipeBuilder().setPlan(Ingredient.f_43901_).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.EMERALD)), (int)4).m_126130_(" X ").m_126130_("#X#").m_126130_("XXX").m_206416_(Character.valueOf('#'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('X'), Tags.Items.GEMS_EMERALD)).build(consumer, ForestryRecipeProvider.id("fabricator", "electron_tubes", "emerald"));
        new FabricatorRecipeBuilder().setPlan(Ingredient.f_43901_).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.LAPIS)), (int)4).m_126130_(" X ").m_126130_("#X#").m_126130_("XXX").m_206416_(Character.valueOf('#'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('X'), Tags.Items.GEMS_LAPIS)).build(consumer, ForestryRecipeProvider.id("fabricator", "electron_tubes", "lapis"));
        new FabricatorRecipeBuilder().setPlan(Ingredient.f_43901_).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.ENDER)), (int)4).m_126130_(" X ").m_126130_("#X#").m_126130_("XXX").m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42545_).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42102_)).build(consumer, ForestryRecipeProvider.id("fabricator", "electron_tubes", "ender"));
        new FabricatorRecipeBuilder().setPlan(Ingredient.f_43901_).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.COPPER)), (int)4).m_126130_(" X ").m_126130_("#X#").m_126130_("XXX").m_206416_(Character.valueOf('#'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('X'), Tags.Items.INGOTS_COPPER)).build(consumer, ForestryRecipeProvider.id("fabricator", "electron_tubes", "copper"));
        new FabricatorRecipeBuilder().setPlan(Ingredient.f_43901_).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.TIN)), (int)4).m_126130_(" X ").m_126130_("#X#").m_126130_("XXX").m_206416_(Character.valueOf('#'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('X'), ForestryTags.Items.INGOTS_TIN)).build(consumer, ForestryRecipeProvider.id("fabricator", "electron_tubes", "tin"));
        new FabricatorRecipeBuilder().setPlan(Ingredient.f_43901_).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.BRONZE)), (int)4).m_126130_(" X ").m_126130_("#X#").m_126130_("XXX").m_206416_(Character.valueOf('#'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('X'), ForestryTags.Items.INGOTS_BRONZE)).build(consumer, ForestryRecipeProvider.id("fabricator", "electron_tubes", "bronze"));
        new FabricatorRecipeBuilder().setPlan(Ingredient.f_43901_).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.APATITE)), (int)4).m_126130_(" X ").m_126130_("#X#").m_126130_("XXX").m_206416_(Character.valueOf('#'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('X'), ForestryTags.Items.GEMS_APATITE)).build(consumer, ForestryRecipeProvider.id("fabricator", "electron_tubes", "apatite"));
        new FabricatorRecipeBuilder().setPlan(Ingredient.f_43901_).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, CoreItems.FLEXIBLE_CASING).m_126130_("#E#").m_126130_("B B").m_126130_("#E#").m_206416_(Character.valueOf('#'), ForestryTags.Items.INGOTS_BRONZE).m_206416_(Character.valueOf('B'), Tags.Items.SLIMEBALLS).m_206416_(Character.valueOf('E'), Tags.Items.GEMS_EMERALD)).build(consumer, ForestryRecipeProvider.id("fabricator", "electron_tubes", "flexible_casing"));
        for (ForestryWoodType forestryWoodType : ForestryWoodType.values()) {
            ForestryRecipeProvider.addFireproofRecipes(consumer, forestryWoodType);
        }
        for (Enum enum_ : VanillaWoodType.values()) {
            ForestryRecipeProvider.addFireproofRecipes(consumer, (IWoodType)((Object)enum_));
        }
    }

    private static void addFireproofRecipes(Consumer<FinishedRecipe> consumer, IWoodType type) {
        FluidStack liquidGlass = ForestryFluids.GLASS.getFluid(500);
        List<WoodBlockKind> logLike = List.of(WoodBlockKind.LOG, WoodBlockKind.WOOD, WoodBlockKind.STRIPPED_LOG, WoodBlockKind.STRIPPED_WOOD);
        IWoodAccess woodAccess = IForestryApi.INSTANCE.getTreeManager().getWoodAccess();
        for (WoodBlockKind woodKind : logLike) {
            try {
                new FabricatorRecipeBuilder().setPlan(Ingredient.f_43901_).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)woodAccess.getBlock(type, woodKind, true).m_60734_(), (int)2).m_126130_("   ").m_126130_("X#X").m_126130_("   ").m_126127_(Character.valueOf('#'), CoreItems.REFRACTORY_WAX).m_126127_(Character.valueOf('X'), (ItemLike)woodAccess.getBlock(type, woodKind, false).m_60734_())).build(consumer, ForestryRecipeProvider.id("fabricator", "fireproof", woodKind.m_7912_(), type.toString()));
            }
            catch (IllegalStateException illegalStateException) {}
        }
        new FabricatorRecipeBuilder().setPlan(Ingredient.f_43901_).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)woodAccess.getBlock(type, WoodBlockKind.PLANKS, true).m_60734_(), (int)8).m_126130_("XXX").m_126130_("X#X").m_126130_("XXX").m_126127_(Character.valueOf('#'), CoreItems.REFRACTORY_WAX).m_126127_(Character.valueOf('X'), (ItemLike)woodAccess.getBlock(type, WoodBlockKind.PLANKS, false).m_60734_())).build(consumer, ForestryRecipeProvider.id("fabricator", "fireproof", "planks", type.toString()));
    }

    private static void registerFabricatorSmelting(Consumer<FinishedRecipe> consumer) {
        FluidStack liquidGlassBucket = ForestryFluids.GLASS.getFluid(1000);
        FluidStack liquidGlassX4 = ForestryFluids.GLASS.getFluid(4000);
        FluidStack liquidGlass375 = ForestryFluids.GLASS.getFluid(375);
        new FabricatorSmeltingRecipeBuilder().setResource(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41904_})).setProduct(liquidGlassBucket).setMeltingPoint(1000).build(consumer, ForestryRecipeProvider.id("fabricator", "smelting", "glass"));
        new FabricatorSmeltingRecipeBuilder().setResource(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42027_})).setProduct(liquidGlass375).setMeltingPoint(1000).build(consumer, ForestryRecipeProvider.id("fabricator", "smelting", "glass_pane"));
        new FabricatorSmeltingRecipeBuilder().setResource(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41830_, Items.f_41831_})).setProduct(liquidGlassBucket).setMeltingPoint(3000).build(consumer, ForestryRecipeProvider.id("fabricator", "smelting", "sand"));
        new FabricatorSmeltingRecipeBuilder().setResource(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41856_, Items.f_41993_, Items.f_41857_})).setProduct(liquidGlassX4).setMeltingPoint(4800).build(consumer, ForestryRecipeProvider.id("fabricator", "smelting", "sandstone"));
    }

    private static void registerFermenter(Consumer<FinishedRecipe> consumer) {
        new FermenterRecipeBuilder().setResource(Ingredient.m_43929_((ItemLike[])new ItemLike[]{ApicultureItems.HONEYDEW})).setFermentationValue(500).setOutput(ForestryFluids.SHORT_MEAD.getFluid()).setFluidResource(ForestryFluids.HONEY.getFluid(1)).build(consumer, ForestryRecipeProvider.id("fermenter", "honeydew"));
        ForestryRecipeProvider.addFermenterRecipes(consumer, "sapling", Ingredient.m_204132_((TagKey)ItemTags.f_13180_), 250, ForestryFluids.BIOMASS);
        ForestryRecipeProvider.addFermenterRecipes(consumer, "cactus", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41982_}), 50, ForestryFluids.BIOMASS);
        ForestryRecipeProvider.addFermenterRecipes(consumer, "wheat", Ingredient.m_204132_((TagKey)Tags.Items.CROPS_WHEAT), 50, ForestryFluids.BIOMASS);
        ForestryRecipeProvider.addFermenterRecipes(consumer, "potato", Ingredient.m_204132_((TagKey)Tags.Items.CROPS_POTATO), 100, ForestryFluids.BIOMASS);
        ForestryRecipeProvider.addFermenterRecipes(consumer, "sugar_cane", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41909_}), 50, ForestryFluids.BIOMASS);
        ForestryRecipeProvider.addFermenterRecipes(consumer, "mushroom", Ingredient.m_204132_((TagKey)Tags.Items.MUSHROOMS), 50, ForestryFluids.BIOMASS);
    }

    private static void addFermenterRecipes(Consumer<FinishedRecipe> writer, String name, Ingredient resource, int fermentationValue, ForestryFluids output) {
        Fluid outputFluid = output.getFluid();
        new FermenterRecipeBuilder().setResource(resource).setFermentationValue(fermentationValue).setFluidResource(new FluidStack((Fluid)Fluids.f_76193_, 1)).setOutput(outputFluid).build(writer, ForestryRecipeProvider.id("fermenter", name));
        new FermenterRecipeBuilder().setResource(resource).setFermentationValue(fermentationValue).setFluidResource(ForestryFluids.JUICE.getFluid(1)).setOutput(outputFluid).setModifier(1.5f).build(writer, ForestryRecipeProvider.id("fermenter", name + "_juice"));
        new FermenterRecipeBuilder().setResource(resource).setFermentationValue(fermentationValue).setFluidResource(ForestryFluids.HONEY.getFluid(1)).setOutput(outputFluid).setModifier(1.5f).build(writer, ForestryRecipeProvider.id("fermenter", name + "_honey"));
    }

    private static void registerHygroregulator(Consumer<FinishedRecipe> consumer) {
        new HygroregulatorRecipeBuilder().setLiquid(new FluidStack((Fluid)Fluids.f_76193_, 1)).setTemperatureSteps(-1).setHumiditySteps(1).build(consumer, ForestryRecipeProvider.id("hygroregulator", "water"));
        new HygroregulatorRecipeBuilder().setLiquid(new FluidStack((Fluid)Fluids.f_76195_, 1)).setTemperatureSteps(1).setHumiditySteps(-1).build(consumer, ForestryRecipeProvider.id("hygroregulator", "lava"));
        new HygroregulatorRecipeBuilder().setLiquid(ForestryFluids.ICE.getFluid(1)).setRetainTime(10).setTemperatureSteps(-2).setHumiditySteps(2).build(consumer, ForestryRecipeProvider.id("hygroregulator", "ice"));
    }

    private static void registerMoistener(Consumer<FinishedRecipe> consumer) {
        new MoistenerRecipeBuilder().setResource(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42404_})).setProduct(new ItemStack((ItemLike)Items.f_42093_)).setTimePerItem(5000).build(consumer, ForestryRecipeProvider.id("moistener", "mycelium"));
        new MoistenerRecipeBuilder().setResource(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42594_})).setProduct(new ItemStack((ItemLike)Items.f_41998_)).setTimePerItem(20000).build(consumer, ForestryRecipeProvider.id("moistener", "mossy_cobblestone"));
        new MoistenerRecipeBuilder().setResource(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42018_})).setProduct(new ItemStack((ItemLike)Items.f_42019_)).setTimePerItem(20000).build(consumer, ForestryRecipeProvider.id("moistener", "mossy_stone_bricks"));
        new MoistenerRecipeBuilder().setResource(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41897_})).setProduct(new ItemStack((ItemLike)Items.f_42435_)).setTimePerItem(5000).build(consumer, ForestryRecipeProvider.id("moistener", "podzol"));
    }

    private static void registerSqueezerContainer(Consumer<FinishedRecipe> consumer) {
        new SqueezerContainerRecipeBuilder().setProcessingTime(10).setEmptyContainer(FluidsItems.CONTAINERS.stack(EnumContainerType.CAN)).setRemnants(CoreItems.INGOT_TIN.stack()).setRemnantsChance(0.05f).build(consumer, ForestryRecipeProvider.id("squeezer", "container", "can"));
        new SqueezerContainerRecipeBuilder().setProcessingTime(10).setEmptyContainer(FluidsItems.CONTAINERS.stack(EnumContainerType.CAPSULE)).setRemnants(CoreItems.BEESWAX.stack()).setRemnantsChance(0.1f).build(consumer, ForestryRecipeProvider.id("squeezer", "container", "capsule"));
        new SqueezerContainerRecipeBuilder().setProcessingTime(10).setEmptyContainer(FluidsItems.CONTAINERS.stack(EnumContainerType.REFRACTORY)).setRemnants(CoreItems.REFRACTORY_WAX.stack()).setRemnantsChance(0.1f).build(consumer, ForestryRecipeProvider.id("squeezer", "container", "refractory"));
    }

    private static void registerSqueezer(Consumer<FinishedRecipe> consumer) {
        FluidStack honeyDropFluid = ForestryFluids.HONEY.getFluid(100);
        FluidStack honeyBlockFluid = ForestryFluids.HONEY.getFluid(800);
        new SqueezerRecipeBuilder().setProcessingTime(10).setResources((List<Ingredient>)NonNullList.m_122780_((int)1, (Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ApicultureItems.HONEY_DROP}))).setFluidOutput(honeyDropFluid).setRemnants(ApicultureItems.PROPOLIS.stack(EnumPropolis.NORMAL, 1)).setRemnantsChance(0.05f).build(consumer, ForestryRecipeProvider.id("squeezer", "honey_drop"));
        new SqueezerRecipeBuilder().setProcessingTime(10).setResources((List<Ingredient>)NonNullList.m_122780_((int)1, (Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.SPONGE)}))).setFluidOutput(honeyDropFluid).setRemnants(new ItemStack((ItemLike)Items.f_41902_)).setRemnantsChance(0.02f).build(consumer, ForestryRecipeProvider.id("squeezer", "sponge_comb"));
        new SqueezerRecipeBuilder().setProcessingTime(60).setResources((List<Ingredient>)NonNullList.m_122780_((int)1, (Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42788_}))).setFluidOutput(honeyBlockFluid).build(consumer, ForestryRecipeProvider.id("squeezer", "honey_block"));
        new SqueezerRecipeBuilder().setProcessingTime(10).setResources((List<Ingredient>)NonNullList.m_122780_((int)1, (Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ApicultureItems.HONEYDEW}))).setFluidOutput(honeyDropFluid).build(consumer, ForestryRecipeProvider.id("squeezer", "honey_dew"));
        new SqueezerRecipeBuilder().setProcessingTime(20).setResources((List)Util.m_137469_((Object)NonNullList.m_122779_(), ingredients -> {
            ingredients.add((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.PROPOLIS.get(EnumPropolis.VOLCANIC)}));
            ingredients.add((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41830_, Items.f_41831_}));
        })).setFluidOutput(new FluidStack((Fluid)Fluids.f_76195_, 500)).build(consumer, ForestryRecipeProvider.id("squeezer", "lava_sand"));
        new SqueezerRecipeBuilder().setProcessingTime(30).setResources((List)Util.m_137469_((Object)NonNullList.m_122779_(), ingredients -> {
            ingredients.add((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.PROPOLIS.get(EnumPropolis.VOLCANIC)}));
            ingredients.add((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42594_}));
        })).setFluidOutput(new FluidStack((Fluid)Fluids.f_76195_, 500)).build(consumer, ForestryRecipeProvider.id("squeezer", "lava"));
        new SqueezerRecipeBuilder().setProcessingTime(20).setResources((List)Util.m_137469_((Object)NonNullList.m_122779_(), ingredients -> {
            ingredients.add((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ApicultureItems.PROPOLIS.get(EnumPropolis.VOLCANIC)}));
            ingredients.add((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42258_}));
        })).setFluidOutput(new FluidStack((Fluid)Fluids.f_76195_, 1000)).build(consumer, ForestryRecipeProvider.id("squeezer", "lava_magma"));
        int seedOilAmount = 10;
        new SqueezerRecipeBuilder().setProcessingTime(10).setResources((List<Ingredient>)NonNullList.m_122780_((int)1, (Object)Ingredient.m_204132_((TagKey)Tags.Items.SEEDS))).setFluidOutput(ForestryFluids.SEED_OIL.getFluid(seedOilAmount)).build(consumer, ForestryRecipeProvider.id("squeezer", "seeds"));
        float mulchMultiplier = 0.2f;
        int juiceMultiplier = 200;
        new SqueezerRecipeBuilder().setProcessingTime(10).setResources((List<Ingredient>)NonNullList.m_122780_((int)1, (Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42410_, Items.f_42619_}))).setFluidOutput(ForestryFluids.JUICE.getFluid(juiceMultiplier)).setRemnants(CoreItems.MULCH.stack()).setRemnantsChance(mulchMultiplier).build(consumer, ForestryRecipeProvider.id("squeezer", "mulch"));
        new SqueezerRecipeBuilder().setProcessingTime(10).setResources((List<Ingredient>)NonNullList.m_122780_((int)1, (Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41982_}))).setFluidOutput(new FluidStack((Fluid)Fluids.f_76193_, 500)).build(consumer, ForestryRecipeProvider.id("squeezer", "cactus"));
        new SqueezerRecipeBuilder().setProcessingTime(10).setResources(List.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42452_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.ICE_SHARD)}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.ICE_SHARD)}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.ICE_SHARD)}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.ICE_SHARD)}))).setFluidOutput(ForestryFluids.ICE.getFluid(4000)).build(consumer, ForestryRecipeProvider.id("squeezer", "ice"));
        int seedOilMultiplier = 10;
        ItemStack mulch = new ItemStack(CoreItems.MULCH);
        Fluid seedOil = ForestryFluids.SEED_OIL.getFluid();
        Fluid juice = ForestryFluids.JUICE.getFluid();
        new SqueezerRecipeBuilder().setProcessingTime(20).setResources((List<Ingredient>)NonNullList.m_122780_((int)1, (Object)Ingredient.m_204132_(ForestryTags.Items.CHERRY))).setFluidOutput(new FluidStack(seedOil, seedOilMultiplier * 5)).setRemnants(mulch).setRemnantsChance(0.05f).build(consumer, ForestryRecipeProvider.id("squeezer", "fruit", "cherry"));
        new SqueezerRecipeBuilder().setProcessingTime(60).setResources((List<Ingredient>)NonNullList.m_122780_((int)1, (Object)Ingredient.m_204132_(ForestryTags.Items.WALNUT))).setFluidOutput(new FluidStack(seedOil, seedOilMultiplier * 18)).setRemnants(mulch).setRemnantsChance(0.05f).build(consumer, ForestryRecipeProvider.id("squeezer", "fruit", "walnut"));
        new SqueezerRecipeBuilder().setProcessingTime(70).setResources((List<Ingredient>)NonNullList.m_122780_((int)1, (Object)Ingredient.m_204132_(ForestryTags.Items.CHESTNUT))).setFluidOutput(new FluidStack(seedOil, seedOilMultiplier * 22)).setRemnants(mulch).setRemnantsChance(0.02f).build(consumer, ForestryRecipeProvider.id("squeezer", "fruit", "chestnut"));
        new SqueezerRecipeBuilder().setProcessingTime(10).setResources((List<Ingredient>)NonNullList.m_122780_((int)1, (Object)Ingredient.m_204132_(ForestryTags.Items.LEMON))).setFluidOutput(new FluidStack(juice, juiceMultiplier * 2)).setRemnants(mulch).setRemnantsChance(mulchMultiplier / 2.0f).build(consumer, ForestryRecipeProvider.id("squeezer", "fruit", "lemon"));
        new SqueezerRecipeBuilder().setProcessingTime(10).setResources((List<Ingredient>)NonNullList.m_122780_((int)1, (Object)Ingredient.m_204132_(ForestryTags.Items.PLUM))).setFluidOutput(new FluidStack(juice, juiceMultiplier / 2)).setRemnants(mulch).setRemnantsChance(mulchMultiplier * 3.0f).build(consumer, ForestryRecipeProvider.id("squeezer", "fruit", "plum"));
        new SqueezerRecipeBuilder().setProcessingTime(10).setResources((List<Ingredient>)NonNullList.m_122780_((int)1, (Object)Ingredient.m_204132_(ForestryTags.Items.PAPAYA))).setFluidOutput(new FluidStack(juice, juiceMultiplier * 3)).setRemnants(mulch).setRemnantsChance(mulchMultiplier / 2.0f).build(consumer, ForestryRecipeProvider.id("squeezer", "fruit", "papaya"));
        new SqueezerRecipeBuilder().setProcessingTime(10).setResources((List<Ingredient>)NonNullList.m_122780_((int)1, (Object)Ingredient.m_204132_(ForestryTags.Items.DATE))).setFluidOutput(new FluidStack(juice, juiceMultiplier / 4)).setRemnants(mulch).setRemnantsChance(mulchMultiplier).build(consumer, ForestryRecipeProvider.id("squeezer", "fruit", "dates"));
    }

    private static void registerStill(Consumer<FinishedRecipe> consumer) {
        FluidStack biomass = ForestryFluids.BIOMASS.getFluid(10);
        FluidStack ethanol = ForestryFluids.BIO_ETHANOL.getFluid(3);
        new StillRecipeBuilder().setTimePerUnit(100).setInput(biomass).setOutput(ethanol).build(consumer, ForestryRecipeProvider.id("still", "ethanol"));
    }

    private static ResourceLocation id(String ... path) {
        return new ResourceLocation("forestry", String.join((CharSequence)"/", path));
    }
}

