/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.errors;

import com.google.common.collect.ImmutableMap;
import forestry.api.core.IError;
import forestry.api.core.IErrorLogic;
import forestry.api.core.IErrorManager;
import forestry.core.errors.ErrorLogic;
import it.unimi.dsi.fastutil.objects.Object2ShortOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public class ErrorManager
implements IErrorManager {
    private final Short2ObjectOpenHashMap<IError> byNumericId;
    private final Object2ShortOpenHashMap<IError> numericIdLookup;
    private final ImmutableMap<ResourceLocation, IError> byId;

    public ErrorManager(Short2ObjectOpenHashMap<IError> byNumericId, Object2ShortOpenHashMap<IError> numericIdLookup, ImmutableMap<ResourceLocation, IError> byId) {
        this.byNumericId = byNumericId;
        this.numericIdLookup = numericIdLookup;
        this.byId = byId;
    }

    @Override
    public IError getError(short id) {
        return (IError)this.byNumericId.get(id);
    }

    @Override
    @Nullable
    public IError getError(ResourceLocation errorId) {
        return (IError)this.byId.get((Object)errorId);
    }

    @Override
    public List<IError> getErrors() {
        return this.byId.values().asList();
    }

    @Override
    public IErrorLogic createErrorLogic() {
        return new ErrorLogic();
    }

    @Override
    public short getNumericId(IError error) {
        return this.numericIdLookup.getShort((Object)error);
    }
}

