/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import forestry.api.IForestryApi;
import forestry.api.core.ForestryEvent;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpecies;
import forestry.api.genetics.ISpeciesType;
import forestry.core.network.packets.PacketGenomeTrackerSync;
import forestry.core.utils.NetworkUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.eventbus.api.Event;

public abstract class BreedingTracker
extends SavedData
implements IBreedingTracker {
    private static final String SPECIES_KEY = "SD";
    private static final String MUTATIONS_KEY = "MD";
    private static final String RESEARCHED_KEY = "RD";
    private static final String MUTATION_FORMAT = "%s-%s=%s";
    public static final String TYPE_KEY = "TYPE";
    private final ResourceLocation typeId;
    private final Set<ResourceLocation> discoveredSpecies = new HashSet<ResourceLocation>();
    private final Set<String> discoveredMutations = new HashSet<String>();
    private final Set<String> researchedMutations = new HashSet<String>();
    @Nullable
    private GameProfile username;
    @Nullable
    private Level level;

    protected BreedingTracker(ResourceLocation typeId) {
        this.typeId = typeId;
    }

    public void setUsername(@Nullable GameProfile username) {
        this.username = username;
    }

    public void setLevel(@Nullable Level level) {
        this.level = level;
    }

    @Override
    public void syncToPlayer(Player player) {
        if (player instanceof ServerPlayer && !(player instanceof FakePlayer)) {
            CompoundTag nbt = new CompoundTag();
            this.writeToNbt(nbt);
            PacketGenomeTrackerSync packet = new PacketGenomeTrackerSync(nbt);
            NetworkUtil.sendToPlayer(packet, (ServerPlayer)player);
        }
    }

    private void sendUpdate(Collection<ResourceLocation> discoveredSpecies, Collection<String> discoveredMutations, Collection<String> researchedMutations) {
        Player player;
        if (this.level != null && this.username != null && this.username.getName() != null && (player = this.level.m_46003_(this.username.getId())) instanceof ServerPlayer && !(player instanceof FakePlayer)) {
            CompoundTag nbt = new CompoundTag();
            this.writeAllValues(nbt, discoveredSpecies, discoveredMutations, researchedMutations);
            this.writeUpdateData(nbt);
            PacketGenomeTrackerSync packet = new PacketGenomeTrackerSync(nbt);
            NetworkUtil.sendToPlayer(packet, (ServerPlayer)player);
        }
    }

    public final CompoundTag m_7176_(CompoundTag nbt) {
        this.writeToNbt(nbt);
        return nbt;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void writeToNbt(CompoundTag nbt) {
        this.writeAllValues(nbt, this.discoveredSpecies, this.discoveredMutations, this.researchedMutations);
    }

    protected void writeUpdateData(CompoundTag nbt) {
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void readFromNbt(CompoundTag nbt) {
        BreedingTracker.readValuesFromNBT(nbt, value -> this.discoveredSpecies.add(new ResourceLocation(value)), SPECIES_KEY);
        BreedingTracker.readValuesFromNBT(nbt, this.discoveredMutations::add, MUTATIONS_KEY);
        BreedingTracker.readValuesFromNBT(nbt, this.researchedMutations::add, RESEARCHED_KEY);
    }

    private void writeAllValues(CompoundTag nbt, Collection<ResourceLocation> discoveredSpecies, Collection<String> discoveredMutations, Collection<String> researchedMutations) {
        nbt.m_128359_(TYPE_KEY, this.typeId.toString());
        BreedingTracker.writeValuesToNBT(nbt, Iterables.transform(discoveredSpecies, ResourceLocation::toString), SPECIES_KEY);
        BreedingTracker.writeValuesToNBT(nbt, discoveredMutations, MUTATIONS_KEY);
        BreedingTracker.writeValuesToNBT(nbt, researchedMutations, RESEARCHED_KEY);
    }

    private static void writeValuesToNBT(CompoundTag nbt, Iterable<String> values, String key) {
        ListTag nbtList = new ListTag();
        for (String value : values) {
            nbtList.add((Object)StringTag.m_129297_((String)value));
        }
        nbt.m_128365_(key, (Tag)nbtList);
    }

    private static void readValuesFromNBT(CompoundTag nbt, Consumer<String> values, String key) {
        if (nbt.m_128441_(key)) {
            ListTag nbtList = nbt.m_128437_(key, 8);
            for (Tag stringTag : nbtList) {
                values.accept(stringTag.m_7916_());
            }
        }
    }

    private static String getMutationString(IMutation<?> mutation) {
        String species0 = mutation.getFirstParent().id().toString();
        String species1 = mutation.getSecondParent().id().toString();
        String resultSpecies = mutation.getResult().id().toString();
        return String.format(MUTATION_FORMAT, species0, species1, resultSpecies);
    }

    @Override
    public void registerMutation(IMutation<?> mutation) {
        String mutationString = BreedingTracker.getMutationString(mutation);
        if (!this.discoveredMutations.contains(mutationString)) {
            this.discoveredMutations.add(mutationString);
            this.m_77762_();
            ISpeciesType<?, ?> speciesRoot = IForestryApi.INSTANCE.getGeneticManager().getSpeciesType(this.typeId);
            ForestryEvent.MutationDiscovered event = new ForestryEvent.MutationDiscovered(speciesRoot, this.username, mutation, this);
            MinecraftForge.EVENT_BUS.post((Event)event);
            this.sendUpdate(List.of(), List.of(mutationString), List.of());
        }
    }

    @Override
    public boolean isDiscovered(IMutation<?> mutation) {
        String mutationString = BreedingTracker.getMutationString(mutation);
        return this.discoveredMutations.contains(mutationString) || this.researchedMutations.contains(mutationString);
    }

    @Override
    public boolean isDiscovered(ISpecies<?> species) {
        return this.discoveredSpecies.contains(species.id());
    }

    public Set<ResourceLocation> getDiscoveredSpecies() {
        return this.discoveredSpecies;
    }

    @Override
    public int getSpeciesBred() {
        return this.discoveredSpecies.size();
    }

    @Override
    public void registerBirth(ISpecies<?> species) {
        this.registerSpecies(species);
    }

    @Override
    public void registerSpecies(ISpecies<?> species) {
        ResourceLocation speciesId = species.id();
        if (!this.discoveredSpecies.contains(speciesId)) {
            this.discoveredSpecies.add(speciesId);
            ISpeciesType<?, ?> speciesType = IForestryApi.INSTANCE.getGeneticManager().getSpeciesType(this.typeId);
            ForestryEvent.SpeciesDiscovered event = new ForestryEvent.SpeciesDiscovered(speciesType, this.username, species, this);
            MinecraftForge.EVENT_BUS.post((Event)event);
            this.sendUpdate(List.of(speciesId), List.of(), List.of());
        }
    }

    @Override
    public void researchMutation(IMutation<?> mutation) {
        String mutationString = BreedingTracker.getMutationString(mutation);
        if (!this.researchedMutations.contains(mutationString)) {
            this.researchedMutations.add(mutationString);
            this.m_77762_();
            this.registerMutation(mutation);
            this.sendUpdate(List.of(), List.of(), List.of(mutationString));
        }
    }

    @Override
    public boolean isResearched(IMutation<?> mutation) {
        String mutationString = BreedingTracker.getMutationString(mutation);
        return this.researchedMutations.contains(mutationString);
    }
}

