/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.mutations;

import forestry.api.apiculture.IBeeHousing;
import forestry.api.climate.IClimateProvider;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.IMutationCondition;
import forestry.core.tiles.TileUtil;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.GameNarrator;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class MutationConditionRequiresResource
implements IMutationCondition {
    private final List<BlockState> acceptedBlockStates;

    public MutationConditionRequiresResource(BlockState ... acceptedBlockStates) {
        this.acceptedBlockStates = Arrays.asList(acceptedBlockStates);
    }

    @Override
    public float modifyChance(Level level, BlockPos pos, IMutation<?> mutation, IGenome genome0, IGenome genome1, IClimateProvider climate, float currentChance) {
        BlockEntity tile;
        while ((tile = TileUtil.getTile((BlockGetter)level, pos = pos.m_7495_())) instanceof IBeeHousing) {
        }
        BlockState blockState = level.m_8055_(pos);
        return this.acceptedBlockStates.contains(blockState) ? currentChance : 0.0f;
    }

    @Override
    public Component getDescription() {
        if (this.acceptedBlockStates.isEmpty()) {
            return GameNarrator.f_93310_;
        }
        return Component.m_237110_((String)"for.mutation.condition.resource", (Object[])new Object[]{this.acceptedBlockStates.get(0).m_60734_().m_49954_()});
    }
}

