/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.api.client.ForestrySprites;
import forestry.core.features.CoreMenuTypes;
import forestry.core.gui.ContainerTile;
import forestry.core.gui.IGuiSelectable;
import forestry.core.gui.slots.SlotFiltered;
import forestry.core.gui.slots.SlotOutput;
import forestry.core.inventory.watchers.ISlotPickupWatcher;
import forestry.core.network.packets.PacketGuiStream;
import forestry.core.tiles.EscritoireGame;
import forestry.core.tiles.TileEscritoire;
import forestry.core.tiles.TileUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.BlockGetter;

public class ContainerEscritoire
extends ContainerTile<TileEscritoire>
implements IGuiSelectable {
    private long lastUpdate;

    public ContainerEscritoire(int id, Inventory playerInv, TileEscritoire tile) {
        super(id, CoreMenuTypes.ESCRITOIRE.menuType(), playerInv, tile, 34, 153);
        int i;
        this.m_38897_(new SlotFiltered((TileEscritoire)this.tile, 0, 97, 67).setPickupWatcher((ISlotPickupWatcher)this.tile).setStackLimit(1));
        for (i = 0; i < 5; ++i) {
            this.m_38897_(new SlotFiltered((TileEscritoire)this.tile, 7 + i, 17, 49 + i * 18).setBlockedSprite(ForestrySprites.SLOT_BLOCKED_2));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.m_38897_(new SlotOutput((Container)this.tile, 1 + i * 2 + j, 177 + j * 18, 85 + i * 18));
            }
        }
    }

    public static ContainerEscritoire fromNetwork(int windowId, Inventory playerInv, FriendlyByteBuf extraData) {
        TileEscritoire tile = TileUtil.getTile((BlockGetter)playerInv.f_35978_.m_9236_(), extraData.m_130135_(), TileEscritoire.class);
        return new ContainerEscritoire(windowId, playerInv, tile);
    }

    @Override
    public void m_38946_() {
        super.m_38946_();
        long gameLastUpdate = ((TileEscritoire)this.tile).getGame().getLastUpdate();
        if (this.lastUpdate != gameLastUpdate) {
            this.lastUpdate = gameLastUpdate;
            this.sendPacketToListeners(new PacketGuiStream((TileEscritoire)this.tile));
        }
    }

    @Override
    public void handleSelectionRequest(ServerPlayer player, int primary, int secondary) {
        EscritoireGame.Status status = ((TileEscritoire)this.tile).getGame().getStatus();
        if (status != EscritoireGame.Status.PLAYING) {
            return;
        }
        if (primary == -1) {
            ((TileEscritoire)this.tile).probe();
        } else {
            ((TileEscritoire)this.tile).choose(player.m_36316_(), primary);
        }
    }
}

