/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.api.core.IToolPipette;
import forestry.core.fluids.StandardTank;
import forestry.core.gui.IContainerLiquidTanks;
import forestry.core.network.packets.PacketPipetteClick;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.utils.NetworkUtil;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class ContainerLiquidTanksHelper<T extends BlockEntity>
implements IContainerLiquidTanks {
    private final T tile;

    public ContainerLiquidTanksHelper(T tile) {
        this.tile = tile;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handlePipetteClickClient(int slot, Player player) {
        ItemStack itemstack = player.f_36096_.m_142621_();
        if (itemstack.m_41720_() instanceof IToolPipette) {
            NetworkUtil.sendToServer(new PacketPipetteClick(slot));
        }
    }

    @Override
    public void handlePipetteClick(int slot, ServerPlayer player) {
        ItemStack itemstack = player.f_36096_.m_142621_();
        Item held = itemstack.m_41720_();
        if (!(held instanceof IToolPipette)) {
            return;
        }
        IToolPipette pipette = (IToolPipette)held;
        IFluidTank tank = ((ILiquidTankTile)this.tile).getTankManager().getTank(slot);
        int liquidAmount = tank.getFluidAmount();
        LazyOptional fluidCap = FluidUtil.getFluidHandler((ItemStack)itemstack);
        fluidCap.ifPresent(fluidHandlerItem -> {
            if (pipette.canPipette(itemstack) && liquidAmount > 0) {
                if (tank instanceof StandardTank) {
                    StandardTank standard = (StandardTank)tank;
                    FluidStack fillAmount = standard.drainInternal(1000, IFluidHandler.FluidAction.SIMULATE);
                    int filled = fluidHandlerItem.fill(fillAmount, IFluidHandler.FluidAction.EXECUTE);
                    tank.drain(filled, IFluidHandler.FluidAction.EXECUTE);
                    player.f_36095_.m_142503_(fluidHandlerItem.getContainer());
                    player.f_36095_.m_38946_();
                } else {
                    FluidStack fillAmount = tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                    int filled = fluidHandlerItem.fill(fillAmount, IFluidHandler.FluidAction.EXECUTE);
                    tank.drain(filled, IFluidHandler.FluidAction.EXECUTE);
                    player.f_36096_.m_142503_(fluidHandlerItem.getContainer());
                    player.f_36096_.m_38946_();
                }
            } else {
                FluidStack potential = fluidHandlerItem.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
                if (!potential.isEmpty() && tank instanceof FluidTank) {
                    int fill = tank.fill(potential, IFluidHandler.FluidAction.EXECUTE);
                    fluidHandlerItem.drain(fill, IFluidHandler.FluidAction.EXECUTE);
                    player.f_36096_.m_142503_(fluidHandlerItem.getContainer());
                    player.f_36096_.m_38946_();
                }
            }
        });
    }

    @Override
    @Nullable
    public IFluidTank getTank(int slot) {
        return ((ILiquidTankTile)this.tile).getTankManager().getTank(slot);
    }
}

