/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.api.genetics.ISpeciesType;
import forestry.core.features.CoreMenuTypes;
import forestry.core.gui.ContainerForestry;
import forestry.core.gui.ContainerTile;
import forestry.core.gui.IGuiSelectable;
import forestry.core.gui.INaturalistMenu;
import forestry.core.gui.slots.SlotFilteredInventory;
import forestry.core.tiles.IFilterSlotDelegate;
import forestry.core.tiles.TileNaturalistChest;
import forestry.core.tiles.TileUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.level.BlockGetter;

public class ContainerNaturalistInventory
extends ContainerTile<TileNaturalistChest>
implements IGuiSelectable,
INaturalistMenu {
    public static final int MAX_PAGE = 5;
    private final int page;
    private boolean isFlipPage;

    public ContainerNaturalistInventory(int windowId, Inventory player, TileNaturalistChest tile, int page, boolean isFlipPage) {
        super(windowId, CoreMenuTypes.NATURALIST_INVENTORY.menuType(), player, tile, 18, 120);
        this.page = page;
        this.isFlipPage = isFlipPage;
        ContainerNaturalistInventory.addInventory(this, tile, page);
    }

    public static <T extends Container & IFilterSlotDelegate> void addInventory(ContainerForestry container, T inventory, int selectedPage) {
        int page = Mth.m_14045_((int)selectedPage, (int)0, (int)5);
        for (int x = 0; x < 5; ++x) {
            for (int y = 0; y < 5; ++y) {
                int slot = y + page * 25 + x * 5;
                container.m_38897_(new SlotFilteredInventory(inventory, slot, 100 + y * 18, 21 + x * 18));
            }
        }
    }

    public static ContainerNaturalistInventory fromNetwork(int windowId, Inventory playerInv, FriendlyByteBuf extraData) {
        TileNaturalistChest tile = TileUtil.getTile((BlockGetter)playerInv.f_35978_.m_9236_(), extraData.m_130135_(), TileNaturalistChest.class);
        return new ContainerNaturalistInventory(windowId, playerInv, tile, extraData.m_130242_(), extraData.readBoolean());
    }

    @Override
    public void handleSelectionRequest(ServerPlayer player, int primary, int secondary) {
        this.isFlipPage = true;
        ((TileNaturalistChest)this.tile).flipPage(player, (short)primary);
    }

    @Override
    public ISpeciesType<?, ?> getSpeciesType() {
        return ((TileNaturalistChest)this.tile).getSpeciesType();
    }

    @Override
    public int getCurrentPage() {
        return this.page;
    }

    @Override
    public void onFlipPage() {
        this.isFlipPage = true;
    }

    public void m_38893_(ContainerListener listener) {
        super.m_38893_(listener);
        if (listener.getClass().getNestHost() == ServerPlayer.class) {
            if (!this.isFlipPage) {
                ((TileNaturalistChest)this.tile).increaseNumPlayersUsing();
            } else {
                this.isFlipPage = false;
            }
        }
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (!this.isFlipPage && player instanceof ServerPlayer) {
            ((TileNaturalistChest)this.tile).decreaseNumPlayersUsing();
        }
    }
}

