/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import forestry.api.core.ToleranceType;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.IMutationManager;
import forestry.api.genetics.ISpecies;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.ITaxon;
import forestry.api.genetics.alleles.AllelePair;
import forestry.api.genetics.alleles.IChromosome;
import forestry.api.genetics.alleles.IRegistryChromosome;
import forestry.api.genetics.alleles.IValueAllele;
import forestry.api.genetics.alleles.IValueChromosome;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.core.genetics.mutations.EnumMutateChance;
import forestry.core.gui.ContainerAlyzer;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.GuiUtil;
import forestry.core.gui.widgets.ItemStackWidget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.inventory.ItemInventoryAlyzer;
import forestry.core.render.ColourProperties;
import forestry.core.utils.Translator;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;

public class GuiAlyzer
extends GuiForestry<ContainerAlyzer> {
    public static final int COLUMN_0 = 12;
    public static final int COLUMN_1 = 90;
    public static final int COLUMN_2 = 155;
    private final ItemInventoryAlyzer itemInventory;

    public GuiAlyzer(ContainerAlyzer container, Inventory playerInv, Component name) {
        super("textures/gui/portablealyzer.png", container, playerInv, (Component)Component.m_237113_((String)"GUI_ALYZER_TEST_TITLE"));
        this.itemInventory = (ItemInventoryAlyzer)container.inventory;
        this.f_97726_ = 247;
        this.f_97727_ = 238;
    }

    public static int getColorCoding(boolean dominant) {
        if (dominant) {
            return ColourProperties.INSTANCE.get("gui.beealyzer.dominant");
        }
        return ColourProperties.INSTANCE.get("gui.beealyzer.recessive");
    }

    public final void drawLine(GuiGraphics graphics, String text, int x, IIndividual individual, IChromosome<?> chromosome, boolean inactive) {
        if (!inactive) {
            this.textLayout.drawLine(graphics, text, x, GuiAlyzer.getColorCoding(individual.getGenome().getActiveAllele(chromosome).dominant()));
        } else {
            this.textLayout.drawLine(graphics, text, x, GuiAlyzer.getColorCoding(individual.getGenome().getInactiveAllele(chromosome).dominant()));
        }
    }

    public final void drawSplitLine(GuiGraphics graphics, Component component, int x, int maxWidth, IIndividual individual, IChromosome<?> chromosome, boolean inactive) {
        if (!inactive) {
            this.textLayout.drawSplitLine(graphics, component, x, maxWidth, GuiAlyzer.getColorCoding(individual.getGenome().getActiveAllele(chromosome).dominant()));
        } else {
            this.textLayout.drawSplitLine(graphics, component, x, maxWidth, GuiAlyzer.getColorCoding(individual.getGenome().getInactiveAllele(chromosome).dominant()));
        }
    }

    public final void drawRow(GuiGraphics graphics, Component text0, Component text1, Component text2, IIndividual individual, IChromosome<?> chromosome) {
        this.textLayout.drawRow(graphics, text0, text1, text2, ColourProperties.INSTANCE.get("gui.screen"), GuiAlyzer.getColorCoding(individual.getGenome().getActiveAllele(chromosome).dominant()), GuiAlyzer.getColorCoding(individual.getGenome().getInactiveAllele(chromosome).dominant()));
    }

    public final void drawChromosomeRow(GuiGraphics graphics, IIndividual individual, IChromosome<?> chromosome) {
        Object active = individual.getGenome().getActiveAllele(chromosome);
        MutableComponent activeName = chromosome.getDisplayName(active.cast());
        Object inactive = individual.getGenome().getInactiveAllele(chromosome);
        MutableComponent inactiveName = chromosome.getDisplayName(inactive.cast());
        this.textLayout.drawRow(graphics, (Component)chromosome.getChromosomeDisplayName(), (Component)activeName, (Component)inactiveName, ColourProperties.INSTANCE.get("gui.screen"), GuiAlyzer.getColorCoding(active.dominant()), GuiAlyzer.getColorCoding(inactive.dominant()));
    }

    public final void drawHaploidChromosomeRow(GuiGraphics graphics, IIndividual individual, IChromosome<?> chromosome) {
        Object active = individual.getGenome().getActiveAllele(chromosome);
        MutableComponent activeName = chromosome.getDisplayName(active.cast());
        this.textLayout.drawRow(graphics, (Component)chromosome.getChromosomeDisplayName(), (Component)activeName, ColourProperties.INSTANCE.get("gui.screen"), GuiAlyzer.getColorCoding(active.dominant()));
    }

    public <S extends ISpecies<?>> void drawSpeciesRow(GuiGraphics graphics, IIndividual individual, IRegistryChromosome<S> chromosome) {
        AllelePair<S> species = individual.getGenome().getAllelePair(chromosome);
        this.textLayout.drawLine(graphics, (Component)chromosome.getChromosomeDisplayName(), this.textLayout.column0);
        int columnwidth = this.textLayout.column2 - this.textLayout.column1 - 2;
        IValueAllele activeSpecies = (IValueAllele)species.active();
        IValueAllele inactiveSpecies = (IValueAllele)species.inactive();
        Map<ISpecies<?>, ItemStack> iconStacks = ((ISpecies)activeSpecies.value()).getType().getAlyzerPlugin().getIconStacks();
        GuiUtil.drawItemStack(graphics, this, iconStacks.get(activeSpecies.value()), this.f_97735_ + this.textLayout.column1 + columnwidth - 20, this.f_97736_ + 10);
        GuiUtil.drawItemStack(graphics, this, iconStacks.get(inactiveSpecies.value()), this.f_97735_ + this.textLayout.column2 + columnwidth - 20, this.f_97736_ + 10);
        MutableComponent primaryName = chromosome.getDisplayName(activeSpecies);
        MutableComponent secondaryName = chromosome.getDisplayName(inactiveSpecies);
        this.drawSplitLine(graphics, (Component)primaryName, this.textLayout.column1, columnwidth, individual, chromosome, false);
        this.drawSplitLine(graphics, (Component)secondaryName, this.textLayout.column2, columnwidth, individual, chromosome, true);
        this.textLayout.newLine();
    }

    public <S extends ISpecies<?>> void drawHaploidSpeciesRow(GuiGraphics graphics, IIndividual individual, IRegistryChromosome<S> chromosome) {
        AllelePair<S> species = individual.getGenome().getAllelePair(chromosome);
        this.textLayout.drawLine(graphics, (Component)chromosome.getChromosomeDisplayName(), this.textLayout.column0);
        int columnwidth = this.textLayout.column2 - this.textLayout.column1 - 2;
        IValueAllele activeSpecies = (IValueAllele)species.active();
        Map<ISpecies<?>, ItemStack> iconStacks = ((ISpecies)activeSpecies.value()).getType().getAlyzerPlugin().getIconStacks();
        GuiUtil.drawItemStack(graphics, this, iconStacks.get(activeSpecies.value()), this.f_97735_ + this.textLayout.column1 + columnwidth - 20, this.f_97736_ + 10);
        MutableComponent primaryName = chromosome.getDisplayName(activeSpecies);
        this.drawSplitLine(graphics, (Component)primaryName, this.textLayout.column1, columnwidth, individual, chromosome, false);
        this.textLayout.newLine();
    }

    @Override
    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(graphics, partialTicks, mouseX, mouseY);
        this.widgetManager.clear();
        int specimenSlot = this.getSpecimenSlot();
        if (specimenSlot < 2) {
            this.drawAnalyticsOverview(graphics);
            return;
        }
        ItemStack stackInSlot = this.itemInventory.m_8020_(specimenSlot);
        IIndividualHandlerItem.ifPresent(stackInSlot, individual -> {
            ISpeciesType<?, ?> type = individual.getType();
            switch (specimenSlot) {
                case 2: {
                    type.getAlyzerPlugin().drawAnalyticsPage1(graphics, (Screen)this, stackInSlot);
                    break;
                }
                case 3: {
                    type.getAlyzerPlugin().drawAnalyticsPage2(graphics, (Screen)this, stackInSlot);
                    break;
                }
                case 4: {
                    type.getAlyzerPlugin().drawAnalyticsPage3(graphics, (Screen)this, stackInSlot);
                    break;
                }
                case 5: {
                    this.drawAnalyticsPageMutations(graphics, individual);
                    break;
                }
                case 6: {
                    this.drawAnalyticsPageClassification(graphics, (IIndividual)individual);
                    break;
                }
                default: {
                    this.drawAnalyticsOverview(graphics);
                }
            }
        });
    }

    private int getSpecimenSlot() {
        for (int k = 1; k <= 6; ++k) {
            ItemStack stackInSlot = this.itemInventory.m_8020_(k);
            if (stackInSlot.m_41619_() || !IIndividualHandlerItem.filter(stackInSlot, IIndividual::isAnalyzed)) continue;
            return k;
        }
        return -1;
    }

    public void drawAnalyticsOverview(GuiGraphics graphics) {
        this.textLayout.startPage(graphics);
        this.textLayout.newLine();
        MutableComponent title = Component.m_237115_((String)"for.gui.portablealyzer");
        this.textLayout.drawCenteredLine(graphics, (Component)title, 8, 208, ColourProperties.INSTANCE.get("gui.screen"));
        this.textLayout.newLine();
        graphics.m_280554_(this.f_96547_, (FormattedText)Component.m_237115_((String)"for.gui.portablealyzer.help"), this.f_97735_ + 12 + 4, this.f_97736_ + 42, 200, ColourProperties.INSTANCE.get("gui.screen"));
        this.textLayout.newLine();
        this.textLayout.newLine();
        this.textLayout.newLine();
        this.textLayout.newLine();
        this.textLayout.drawLine(graphics, (Component)Component.m_237115_((String)"for.gui.alyzer.overview").m_130946_(":"), 16);
        this.textLayout.newLine();
        this.textLayout.drawLine(graphics, (Component)Component.m_237113_((String)"I  : ").m_7220_((Component)Component.m_237115_((String)"for.gui.general")), 16);
        this.textLayout.newLine();
        this.textLayout.drawLine(graphics, (Component)Component.m_237113_((String)"II : ").m_7220_((Component)Component.m_237115_((String)"for.gui.environment")), 16);
        this.textLayout.newLine();
        this.textLayout.drawLine(graphics, (Component)Component.m_237113_((String)"III: ").m_7220_((Component)Component.m_237115_((String)"for.gui.produce")), 16);
        this.textLayout.newLine();
        this.textLayout.drawLine(graphics, (Component)Component.m_237113_((String)"IV : ").m_7220_((Component)Component.m_237115_((String)"for.gui.evolution")), 16);
        this.textLayout.endPage(graphics);
    }

    public void drawAnalyticsPageClassification(GuiGraphics graphics, IIndividual individual) {
        this.textLayout.startPage(graphics);
        this.textLayout.drawLine(graphics, (Component)Component.m_237115_((String)"for.gui.alyzer.classification").m_130946_(":"), 12);
        this.textLayout.newLine();
        ArrayDeque<ITaxon> hierarchy = new ArrayDeque<ITaxon>();
        ISpecies<?> species = individual.getSpecies();
        for (ITaxon taxon = species.getGenus(); taxon != null; taxon = taxon.parent()) {
            if (taxon.name().isEmpty()) continue;
            hierarchy.push(taxon);
        }
        boolean overcrowded = hierarchy.size() > 5;
        int x = 12;
        while (!hierarchy.isEmpty()) {
            ITaxon group = (ITaxon)hierarchy.pop();
            if (overcrowded && group.rank().isDroppable()) continue;
            String name = Character.toUpperCase(group.name().charAt(0)) + group.name().substring(1);
            this.textLayout.drawLine(graphics, name, x, group.rank().getColour());
            this.textLayout.drawLine(graphics, group.rank().name(), 170, group.rank().getColour());
            this.textLayout.newLineCompressed();
            x += 12;
        }
        Object binomial = species.getBinomial();
        if (this.f_96547_.m_92895_((String)binomial) > 96) {
            binomial = Character.toUpperCase(species.getGenusName().charAt(0)) + ". " + species.getSpeciesName();
        }
        this.textLayout.drawLine(graphics, (String)binomial, x, 15445637);
        this.textLayout.drawLine(graphics, "SPECIES", 170, 15445637);
        this.textLayout.newLine();
        this.textLayout.drawLine(graphics, (Component)Component.m_237115_((String)"for.gui.alyzer.authority").m_130946_(": ").m_130946_(species.getAuthority()), 12);
        this.textLayout.newLine();
        String description = species.getDescriptionTranslationKey();
        if (Translator.canTranslateToLocal(description)) {
            description = Component.m_237115_((String)description).getString();
            String[] tokens = description.split("\\|");
            this.textLayout.drawSplitLine(graphics, tokens[0], 12, 200, 0x666666);
            if (tokens.length > 1) {
                String signature = "- " + tokens[1];
                graphics.m_280056_(this.f_96547_, signature, this.f_97735_ + 210 - this.font().m_92895_(signature), this.f_97736_ + 145 - 10, 10079282, true);
            }
        } else {
            this.textLayout.drawSplitLine(graphics, (Component)Component.m_237115_((String)"for.gui.alyzer.nodescription"), 12, 200, 0x666666);
        }
        this.textLayout.endPage(graphics);
    }

    public <I extends IIndividual> void drawAnalyticsPageMutations(GuiGraphics graphics, I individual) {
        this.textLayout.startPage(graphics, 12, 90, 155);
        this.textLayout.drawLine(graphics, (Component)Component.m_237115_((String)"for.gui.beealyzer.mutations").m_130946_(":"), 12);
        this.textLayout.newLine();
        ISpeciesType<?, ?> speciesRoot = individual.getType();
        ISpecies<?> species = individual.getSpecies();
        int columnWidth = 50;
        int x = 0;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        IBreedingTracker breedingTracker = speciesRoot.getBreedingTracker((LevelAccessor)player.m_9236_(), player.m_36316_());
        IMutationManager<ISpecies<?>> mutations = species.getType().getMutations();
        for (IMutation<ISpecies<?>> mutation : mutations.getMutationsFrom((ISpecies<?>)species.cast())) {
            if (breedingTracker.isDiscovered(mutation)) {
                this.drawMutationInfo(graphics, mutation, species, 12 + x, breedingTracker);
            } else {
                if (mutation.isSecret()) continue;
                this.drawUnknownMutation(graphics, mutation, 12 + x, breedingTracker);
            }
            if ((x += columnWidth) < columnWidth * 4) continue;
            x = 0;
            this.textLayout.newLine(16);
        }
        this.textLayout.endPage(graphics);
    }

    public void drawMutationInfo(GuiGraphics graphics, IMutation<?> combination, ISpecies<?> species, int x, IBreedingTracker breedingTracker) {
        Map<ISpecies<?>, ItemStack> iconStacks = combination.getType().getAlyzerPlugin().getIconStacks();
        ItemStack partnerBee = iconStacks.get(combination.getPartner(species));
        this.widgetManager.add(new ItemStackWidget(this.widgetManager, x, this.textLayout.getLineY(), partnerBee));
        this.drawProbabilityArrow(graphics, combination, this.f_97735_ + x + 18, this.f_97736_ + this.textLayout.getLineY() + 4, breedingTracker);
        Object result = combination.getResult();
        ItemStack resultBee = iconStacks.get(result);
        this.widgetManager.add(new ItemStackWidget(this.widgetManager, x + 33, this.textLayout.getLineY(), resultBee));
    }

    private void drawUnknownMutation(GuiGraphics graphics, IMutation<?> combination, int x, IBreedingTracker breedingTracker) {
        this.drawQuestionMark(graphics, this.f_97735_ + x, this.f_97736_ + this.textLayout.getLineY());
        this.drawProbabilityArrow(graphics, combination, this.f_97735_ + x + 18, this.f_97736_ + this.textLayout.getLineY() + 4, breedingTracker);
        this.drawQuestionMark(graphics, this.f_97735_ + x + 32, this.f_97736_ + this.textLayout.getLineY());
    }

    private void drawQuestionMark(GuiGraphics graphics, int x, int y) {
        graphics.m_280218_(this.textureFile, x, y, 78, 240, 16, 16);
    }

    private void drawProbabilityArrow(GuiGraphics graphics, IMutation<?> combination, int x, int y, IBreedingTracker breedingTracker) {
        float chance = combination.getChance();
        int line = 247;
        int column = switch (EnumMutateChance.rateChance(chance)) {
            case EnumMutateChance.HIGHER -> 115;
            case EnumMutateChance.HIGH -> 130;
            case EnumMutateChance.NORMAL -> 145;
            case EnumMutateChance.LOW -> 160;
            case EnumMutateChance.LOWEST -> 175;
            default -> 100;
        };
        graphics.m_280218_(this.textureFile, x, y, column, line, 15, 9);
        boolean researched = breedingTracker.isResearched(combination);
        if (researched) {
            graphics.m_280056_(this.f_96547_, "+", x + 9, y + 1, 0, false);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void drawToleranceInfo(GuiGraphics graphics, IValueChromosome<ToleranceType> chromosome, IValueAllele<ToleranceType> toleranceAllele, int x) {
        int textColor = GuiAlyzer.getColorCoding(toleranceAllele.dominant());
        ToleranceType tolerance = toleranceAllele.value();
        MutableComponent text = Component.m_237113_((String)"(").m_7220_((Component)chromosome.getDisplayName(toleranceAllele)).m_130946_(")");
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        switch (tolerance) {
            case BOTH_1: 
            case BOTH_2: 
            case BOTH_3: 
            case BOTH_4: 
            case BOTH_5: {
                this.drawBothSymbol(graphics, x - 2, this.textLayout.getLineY() - 1);
                this.textLayout.drawLine(graphics, (Component)text, x + 14, textColor);
                break;
            }
            case DOWN_1: 
            case DOWN_2: 
            case DOWN_3: 
            case DOWN_4: 
            case DOWN_5: {
                this.drawDownSymbol(graphics, x - 2, this.textLayout.getLineY() - 1);
                this.textLayout.drawLine(graphics, (Component)text, x + 14, textColor);
                break;
            }
            case UP_1: 
            case UP_2: 
            case UP_3: 
            case UP_4: 
            case UP_5: {
                this.drawUpSymbol(graphics, x - 2, this.textLayout.getLineY() - 1);
                this.textLayout.drawLine(graphics, (Component)text, x + 14, textColor);
                break;
            }
            default: {
                this.drawNoneSymbol(graphics, x - 2, this.textLayout.getLineY() - 1);
                this.textLayout.drawLine(graphics, "(0)", x + 14, textColor);
            }
        }
    }

    private void drawDownSymbol(GuiGraphics graphics, int x, int y) {
        graphics.m_280218_(this.textureFile, this.f_97735_ + x, this.f_97736_ + y, 0, 247, 15, 9);
    }

    private void drawUpSymbol(GuiGraphics graphics, int x, int y) {
        graphics.m_280218_(this.textureFile, this.f_97735_ + x, this.f_97736_ + y, 15, 247, 15, 9);
    }

    private void drawBothSymbol(GuiGraphics graphics, int x, int y) {
        graphics.m_280218_(this.textureFile, this.f_97735_ + x, this.f_97736_ + y, 30, 247, 15, 9);
    }

    private void drawNoneSymbol(GuiGraphics graphics, int x, int y) {
        graphics.m_280218_(this.textureFile, this.f_97735_ + x, this.f_97736_ + y, 45, 247, 15, 9);
    }

    public void drawFertilityInfo(GuiGraphics graphics, int fertility, int x, int textColor, int texOffset) {
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        String fertilityString = fertility + " x";
        int stringWidth = this.font().m_92895_(fertilityString);
        graphics.m_280218_(this.textureFile, this.f_97735_ + x + stringWidth + 2, this.f_97736_ + this.textLayout.getLineY() - 1, 60, 240 + texOffset, 12, 8);
        this.textLayout.drawLine(graphics, fertilityString, x, textColor);
    }

    public WidgetManager getWidgetManager() {
        return this.widgetManager;
    }

    @Override
    protected void addLedgers() {
        this.addErrorLedger(this.itemInventory);
        this.addHintLedger(this.getHints());
    }

    public List<String> getHints() {
        IIndividual individual;
        ItemStack specimen = this.itemInventory.getSpecimen();
        if (!specimen.m_41619_() && (individual = IIndividualHandlerItem.getIndividual(specimen)) != null) {
            return individual.getType().getAlyzerPlugin().getHints();
        }
        return Collections.emptyList();
    }
}

