/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class GuiTextBox
extends EditBox {
    private static final int enabledColor = 0xE0E0E0;
    private static final int disabledColor = 0x707070;
    private final Font font;
    private final int startX;
    private final int startY;
    private final int width;
    private final int height;
    private int lineScroll = 0;
    private int maxLines = 0;

    public GuiTextBox(Font font, int startX, int startY, int width, int height) {
        super(font, startX, startY, width, height, null);
        this.font = font;
        this.startX = startX;
        this.startY = startY;
        this.width = width;
        this.height = height;
    }

    private int getLineScrollOffset() {
        return 0;
    }

    public void advanceLine() {
        if (this.lineScroll < this.maxLines - 1) {
            ++this.lineScroll;
        }
    }

    public void regressLine() {
        if (this.lineScroll > 0) {
            --this.lineScroll;
        }
    }

    public boolean moreLinesAllowed() {
        int n = this.font.m_92923_((FormattedText)Component.m_237113_((String)this.getCursoredText()), this.width).size();
        Objects.requireNonNull(this.font);
        return n * 9 < this.height;
    }

    private String getCursoredText() {
        if (!this.m_93696_()) {
            return this.m_94155_();
        }
        int cursorPos = this.m_94207_() - this.getLineScrollOffset();
        String text = this.m_94155_();
        if (cursorPos < 0) {
            return text;
        }
        if (cursorPos >= text.length()) {
            return text + "_";
        }
        return text.substring(0, cursorPos) + "_" + text.substring(cursorPos);
    }

    private void drawScrolledSplitString(GuiGraphics graphics, Component text, int startX, int startY, int width, int textColour) {
        List lines = this.font.m_92923_((FormattedText)text, width);
        this.maxLines = lines.size();
        int count = 0;
        int lineY = startY;
        for (FormattedCharSequence line : lines) {
            if (count < this.lineScroll) {
                ++count;
                continue;
            }
            Objects.requireNonNull(this.font);
            if (lineY + 9 - startY > this.height) break;
            graphics.m_280648_(this.font, line, startX, lineY, textColour);
            Objects.requireNonNull(this.font);
            lineY += 9;
            ++count;
        }
    }
}

