/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.ledgers;

import com.mojang.authlib.GameProfile;
import forestry.api.client.ForestrySprites;
import forestry.api.client.IForestryClientApi;
import forestry.core.gui.ledgers.Ledger;
import forestry.core.gui.ledgers.LedgerManager;
import forestry.core.owner.IOwnedTile;
import forestry.core.utils.PlayerUtil;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;

public class OwnerLedger
extends Ledger {
    @Nullable
    private final GameProfile owner;

    public OwnerLedger(LedgerManager manager, IOwnedTile tile) {
        super(manager, "owner");
        this.owner = tile.getOwnerHandler().getOwner();
        this.maxHeight = 40;
    }

    @Override
    public boolean isVisible() {
        return this.owner != null;
    }

    @Override
    public void draw(GuiGraphics graphics, int y, int x) {
        this.drawBackground(graphics, y, x);
        TextureAtlasSprite accessIcon = IForestryClientApi.INSTANCE.getTextureManager().getSprite(ForestrySprites.MISC_ACCESS_SHARED);
        this.drawSprite(graphics, accessIcon, x + 3, y + 4);
        if (this.isFullyOpened()) {
            this.drawHeader(graphics, (Component)Component.m_237115_((String)"for.gui.owner"), x + 22, y + 8);
            this.drawText(graphics, PlayerUtil.getOwnerName(this.owner), x + 22, y + 20);
        }
    }

    @Override
    public Component getTooltip() {
        return Component.m_237115_((String)"for.gui.owner").m_130946_(": " + PlayerUtil.getOwnerName(this.owner));
    }
}

