/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.slots;

import forestry.api.core.tooltips.IToolTipProvider;
import forestry.api.core.tooltips.ToolTip;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class SlotForestry
extends Slot
implements IToolTipProvider {
    private boolean isPhantom;
    private boolean canAdjustPhantom = true;
    private boolean canShift = true;
    private int stackLimit = -1;
    @Nullable
    private ToolTip toolTips;

    public SlotForestry(Container inventory, int slotIndex, int xPos, int yPos) {
        super(inventory, slotIndex, xPos, yPos);
    }

    public SlotForestry setPhantom() {
        this.isPhantom = true;
        return this;
    }

    public SlotForestry blockShift() {
        this.canShift = false;
        return this;
    }

    public void m_5852_(ItemStack itemStack) {
        if (!this.isPhantom() || this.canAdjustPhantom()) {
            super.m_5852_(itemStack);
        }
    }

    public SlotForestry setCanAdjustPhantom(boolean canAdjust) {
        this.canAdjustPhantom = canAdjust;
        return this;
    }

    public SlotForestry setStackLimit(int limit) {
        this.stackLimit = limit;
        return this;
    }

    public boolean isPhantom() {
        return this.isPhantom;
    }

    public boolean canAdjustPhantom() {
        return this.canAdjustPhantom;
    }

    public boolean m_8010_(Player stack) {
        return !this.isPhantom();
    }

    public boolean canShift() {
        return this.canShift;
    }

    public int m_6641_() {
        if (this.stackLimit < 0) {
            return super.m_6641_();
        }
        return this.stackLimit;
    }

    public void setToolTips(ToolTip toolTips) {
        this.toolTips = toolTips;
    }

    @Override
    public ToolTip getToolTip(int mouseX, int mouseY) {
        return this.toolTips;
    }

    @Override
    public boolean isToolTipVisible() {
        return this.m_7993_().m_41619_();
    }

    @Override
    public boolean isHovering(double mouseX, double mouseY) {
        return mouseX >= (double)this.f_40220_ && mouseX <= (double)(this.f_40220_ + 16) && mouseY >= (double)this.f_40221_ && mouseY <= (double)(this.f_40221_ + 16);
    }
}

