/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory;

import forestry.api.arboriculture.genetics.ITreeSpeciesType;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.core.inventory.InventoryAdapterTile;
import forestry.core.tiles.TileAnalyzer;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.SlotUtil;
import forestry.core.utils.SpeciesUtil;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class InventoryAnalyzer
extends InventoryAdapterTile<TileAnalyzer> {
    public static final short SLOT_ANALYZE = 0;
    public static final short SLOT_CAN = 1;
    public static final short SLOT_INPUT_1 = 2;
    public static final short SLOT_INPUT_COUNT = 6;
    public static final short SLOT_OUTPUT_1 = 8;
    public static final short SLOT_OUTPUT_COUNT = 4;

    public InventoryAnalyzer(TileAnalyzer analyzer) {
        super(analyzer, 12, "Items");
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack stack) {
        if (SlotUtil.isSlotInRange(slotIndex, 2, 6)) {
            return IIndividualHandlerItem.isIndividual(stack);
        }
        if (slotIndex == 1) {
            Optional fluid = FluidUtil.getFluidContained((ItemStack)stack);
            return fluid.map(f -> ((TileAnalyzer)this.tile).getTankManager().canFillFluidType((FluidStack)f)).orElse(false);
        }
        return false;
    }

    @Override
    public boolean m_7157_(int slotIndex, ItemStack stack, Direction side) {
        return SlotUtil.isSlotInRange(slotIndex, 8, 4);
    }

    @Override
    public void m_6836_(int slotId, ItemStack itemStack) {
        if (!((ITreeSpeciesType)SpeciesUtil.TREE_TYPE.get()).isMember(itemStack)) {
            itemStack = GeneticsUtil.convertToGeneticEquivalent(itemStack);
        }
        super.m_6836_(slotId, itemStack);
    }
}

