/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory;

import com.google.common.collect.ImmutableSet;
import forestry.api.IForestryApi;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.core.ForestryError;
import forestry.api.core.IError;
import forestry.api.core.IErrorSource;
import forestry.core.circuits.EnumCircuitBoardType;
import forestry.core.circuits.ItemCircuitBoard;
import forestry.core.inventory.ItemInventory;
import java.util.List;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemInventorySolderingIron
extends ItemInventory
implements IErrorSource {
    private final List<ICircuitLayout> layouts = IForestryApi.INSTANCE.getCircuitManager().getLayouts();
    private final int layoutCount = this.layouts.size();
    private int layoutIndex = 0;
    private static final short inputCircuitBoardSlot = 0;
    private static final short finishedCircuitBoardSlot = 1;
    private static final short ingredientSlot1 = 2;
    private static final short ingredientSlotCount = 4;

    public ItemInventorySolderingIron(Player player, ItemStack itemStack) {
        super(player, 6, itemStack);
    }

    @Override
    public int m_6893_() {
        return 1;
    }

    public ICircuitLayout getLayout() {
        return this.layouts.get(this.layoutIndex);
    }

    public void setLayout(ICircuitLayout layout) {
        this.layoutIndex = Math.max(0, this.layouts.indexOf(layout));
    }

    public void advanceLayout() {
        this.layoutIndex = (this.layoutIndex + 1) % this.layoutCount;
    }

    public void regressLayout() {
        this.layoutIndex = this.layoutIndex == 0 ? this.layoutCount - 1 : --this.layoutIndex;
    }

    private ICircuit[] getCircuits(boolean doConsume) {
        ICircuit[] circuits = new ICircuit[4];
        for (int i = 0; i < 4; i = (int)((short)(i + 1))) {
            ICircuit circuit;
            ItemStack ingredient = this.m_8020_(2 + i);
            if (ingredient.m_41619_() || (circuit = IForestryApi.INSTANCE.getCircuitManager().getCircuit(this.layouts.get(this.layoutIndex), ingredient)) == null) continue;
            if (doConsume) {
                this.m_7407_(2 + i, ingredient.m_41613_());
            }
            circuits[i] = circuit;
        }
        return circuits;
    }

    @Override
    public void onSlotClick(int slotIndex, Player player) {
        if (this.layouts.get(this.layoutIndex) == null) {
            return;
        }
        ItemStack inputCircuitBoard = this.m_8020_(0);
        if (inputCircuitBoard.m_41619_() || inputCircuitBoard.m_41613_() > 1) {
            return;
        }
        if (!this.m_8020_(1).m_41619_()) {
            return;
        }
        if (!IForestryApi.INSTANCE.getCircuitManager().isCircuitBoard(inputCircuitBoard)) {
            return;
        }
        Item item = inputCircuitBoard.m_41720_();
        if (!(item instanceof ItemCircuitBoard)) {
            return;
        }
        ItemCircuitBoard circuitBoard = (ItemCircuitBoard)item;
        EnumCircuitBoardType type = circuitBoard.getType();
        if (this.getCircuitCount() != type.getSockets()) {
            return;
        }
        ICircuit[] circuits = this.getCircuits(true);
        ItemStack outputCircuitBoard = ItemCircuitBoard.createCircuitboard(type, this.layouts.get(this.layoutIndex), circuits);
        this.m_6836_(1, outputCircuitBoard);
        this.m_6836_(0, ItemStack.f_41583_);
    }

    private int getCircuitCount() {
        ICircuit[] circuits = this.getCircuits(false);
        int count = 0;
        for (ICircuit circuit : circuits) {
            if (circuit == null) continue;
            ++count;
        }
        return count;
    }

    public ImmutableSet<IError> getErrors() {
        ItemStack blankCircuitBoard;
        ImmutableSet.Builder errorStates = ImmutableSet.builder();
        if (this.layouts.get(this.layoutIndex) == null) {
            errorStates.add((Object)ForestryError.NO_CIRCUIT_LAYOUT);
        }
        if ((blankCircuitBoard = this.m_8020_(0)).m_41619_()) {
            errorStates.add((Object)ForestryError.NO_CIRCUIT_BOARD);
        } else {
            Item item = blankCircuitBoard.m_41720_();
            if (!(item instanceof ItemCircuitBoard)) {
                return errorStates.build();
            }
            EnumCircuitBoardType type = ((ItemCircuitBoard)item).getType();
            int circuitCount = 0;
            for (int i = 0; i < type.getSockets(); i = (int)((short)(i + 1))) {
                if (this.m_8020_(2 + i).m_41619_()) continue;
                ++circuitCount;
            }
            if (circuitCount != type.getSockets()) {
                errorStates.add((Object)ForestryError.CIRCUIT_MISMATCH);
            } else {
                int count = this.getCircuitCount();
                if (count != type.getSockets()) {
                    errorStates.add((Object)ForestryError.NO_CIRCUIT_LAYOUT);
                }
            }
        }
        return errorStates.build();
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        Item item = stack.m_41720_();
        if (slotIndex == 0) {
            return item instanceof ItemCircuitBoard;
        }
        if (slotIndex >= 2 && slotIndex < 6) {
            return IForestryApi.INSTANCE.getCircuitManager().getCircuit(this.layouts.get(this.layoutIndex), stack) != null;
        }
        return false;
    }
}

