/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import forestry.api.core.IToolPipette;
import forestry.core.fluids.PipetteContents;
import forestry.core.items.ItemForestry;
import forestry.core.items.definitions.IColoredItem;
import forestry.core.utils.RenderUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;

public class ItemPipette
extends ItemForestry
implements IToolPipette,
IColoredItem {
    public ItemPipette() {
        super(new Item.Properties().m_41487_(1));
    }

    @Override
    public boolean canPipette(ItemStack itemstack) {
        PipetteContents contained = PipetteContents.create(itemstack);
        return contained == null || !contained.isFull();
    }

    @Override
    public void m_7373_(ItemStack itemstack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, world, list, flag);
        PipetteContents contained = PipetteContents.create(itemstack);
        if (contained != null) {
            contained.addTooltip(list);
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new FluidHandlerItemStack(stack, 1000);
    }

    @Override
    public int getColorFromItemStack(ItemStack stack, int tintIndex) {
        PipetteContents contents;
        if (tintIndex == 1 && (contents = PipetteContents.create(stack)) != null) {
            return RenderUtil.getFluidColor(contents.getContents().getFluid());
        }
        return 0xFFFFFF;
    }
}

