/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import forestry.core.gui.ContainerItemInventory;
import forestry.core.items.ItemForestry;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public abstract class ItemWithGui
extends ItemForestry {
    public ItemWithGui(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player player, InteractionHand handIn) {
        ItemStack stack = player.m_21120_(handIn);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.openGui(serverPlayer, stack);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    protected void openGui(ServerPlayer serverPlayer, ItemStack heldItem) {
        NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)this.getMenuProvider(heldItem), buffer -> this.writeContainerData(serverPlayer, heldItem, (FriendlyByteBuf)buffer));
    }

    public SimpleMenuProvider getMenuProvider(ItemStack heldItem) {
        return new SimpleMenuProvider((windowId, playerInv, player) -> this.getContainer(windowId, player, heldItem), heldItem.m_41786_());
    }

    protected void writeContainerData(ServerPlayer player, ItemStack stack, FriendlyByteBuf buffer) {
        buffer.writeBoolean(player.m_7655_() == InteractionHand.MAIN_HAND);
    }

    public boolean onDroppedByPlayer(ItemStack itemstack, Player player) {
        if (!itemstack.m_41619_() && player instanceof ServerPlayer && player.f_36096_ instanceof ContainerItemInventory) {
            player.m_6915_();
        }
        return super.onDroppedByPlayer(itemstack, player);
    }

    @Nullable
    public abstract AbstractContainerMenu getContainer(int var1, Player var2, ItemStack var3);
}

