/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.multiblock;

import forestry.Forestry;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.core.multiblock.IMultiblockControllerInternal;
import forestry.core.multiblock.MultiblockLogic;
import forestry.core.multiblock.MultiblockRegistry;
import forestry.core.multiblock.MultiblockUtil;
import forestry.core.multiblock.MultiblockValidationException;
import forestry.core.tiles.TileUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class MultiblockControllerBase
implements IMultiblockControllerInternal {
    protected final Level level;
    private static final Random rand = new Random();
    private int tickCount = rand.nextInt(256);
    @Nullable
    private BlockPos destroyedCoord = null;
    protected AssemblyState assemblyState;
    protected HashSet<IMultiblockComponent> connectedParts;
    @Nullable
    private BlockPos referenceCoord;
    @Nullable
    private BlockPos minimumCoord;
    @Nullable
    private BlockPos maximumCoord;
    private boolean shouldCheckForDisconnections;
    @Nullable
    private MultiblockValidationException lastValidationException;

    protected MultiblockControllerBase(Level level) {
        this.level = level;
        this.connectedParts = new HashSet();
        this.referenceCoord = null;
        this.assemblyState = AssemblyState.DISASSEMBLED;
        this.minimumCoord = null;
        this.maximumCoord = null;
        this.shouldCheckForDisconnections = true;
        this.lastValidationException = null;
    }

    @Override
    public Collection<IMultiblockComponent> getComponents() {
        return Collections.unmodifiableCollection(this.connectedParts);
    }

    protected abstract void onAttachedPartWithMultiblockData(IMultiblockComponent var1, CompoundTag var2);

    @Override
    public void attachBlock(IMultiblockComponent part) {
        BlockPos coord = part.getCoordinates();
        if (!this.connectedParts.add(part)) {
            Forestry.LOGGER.warn("[{}] Controller {} is double-adding part {} @ {}. This is unusual. If you encounter odd behavior, please tear down the machine and rebuild it.", (Object)(this.level.m_5776_() ? "CLIENT" : "SERVER"), (Object)this.hashCode(), (Object)part.hashCode(), (Object)coord);
        }
        MultiblockLogic logic = (MultiblockLogic)part.getMultiblockLogic();
        logic.setController(this);
        this.onBlockAdded(part);
        if (logic.hasMultiblockSaveData()) {
            CompoundTag savedData = logic.getMultiblockSaveData();
            this.onAttachedPartWithMultiblockData(part, savedData);
            logic.onMultiblockDataAssimilated();
        }
        if (this.referenceCoord == null) {
            this.referenceCoord = coord;
            logic.becomeMultiblockSaveDelegate();
        } else if (coord.compareTo((Vec3i)this.referenceCoord) < 0) {
            TileUtil.actOnTile((LevelReader)this.level, this.referenceCoord, IMultiblockComponent.class, tile -> {
                MultiblockLogic teLogic = (MultiblockLogic)tile.getMultiblockLogic();
                teLogic.forfeitMultiblockSaveDelegate();
            });
            this.referenceCoord = coord;
            logic.becomeMultiblockSaveDelegate();
        } else {
            logic.forfeitMultiblockSaveDelegate();
        }
        if (this.minimumCoord != null) {
            if (coord.m_123341_() < this.minimumCoord.m_123341_()) {
                this.minimumCoord = new BlockPos(coord.m_123341_(), this.minimumCoord.m_123342_(), this.minimumCoord.m_123343_());
            }
            if (coord.m_123342_() < this.minimumCoord.m_123342_()) {
                this.minimumCoord = new BlockPos(this.minimumCoord.m_123341_(), coord.m_123342_(), this.minimumCoord.m_123343_());
            }
            if (coord.m_123343_() < this.minimumCoord.m_123343_()) {
                this.minimumCoord = new BlockPos(this.minimumCoord.m_123341_(), this.minimumCoord.m_123342_(), coord.m_123343_());
            }
        }
        if (this.maximumCoord != null) {
            if (coord.m_123341_() > this.maximumCoord.m_123341_()) {
                this.maximumCoord = new BlockPos(coord.m_123341_(), this.maximumCoord.m_123342_(), this.maximumCoord.m_123343_());
            }
            if (coord.m_123342_() > this.maximumCoord.m_123342_()) {
                this.maximumCoord = new BlockPos(this.maximumCoord.m_123341_(), coord.m_123342_(), this.maximumCoord.m_123343_());
            }
            if (coord.m_123343_() > this.maximumCoord.m_123343_()) {
                this.maximumCoord = new BlockPos(this.maximumCoord.m_123341_(), this.maximumCoord.m_123342_(), coord.m_123343_());
            }
        }
        MultiblockRegistry.addDirtyController((LevelAccessor)this.level, this);
    }

    protected abstract void onBlockAdded(IMultiblockComponent var1);

    protected abstract void onBlockRemoved(IMultiblockComponent var1);

    protected void onMachineAssembled() {
    }

    protected void onMachineRestored() {
    }

    protected void onMachinePaused() {
    }

    protected void onMachineDisassembled() {
    }

    private void onDetachBlock(IMultiblockComponent part) {
        MultiblockLogic logic = (MultiblockLogic)part.getMultiblockLogic();
        logic.setController(null);
        this.onBlockRemoved(part);
        logic.forfeitMultiblockSaveDelegate();
        this.maximumCoord = null;
        this.minimumCoord = null;
        if (this.referenceCoord != null && this.referenceCoord.equals((Object)part.getCoordinates())) {
            this.referenceCoord = null;
        }
        this.shouldCheckForDisconnections = true;
    }

    @Override
    public void detachBlock(IMultiblockComponent part, boolean chunkUnloading) {
        if (chunkUnloading && this.assemblyState == AssemblyState.ASSEMBLED) {
            this.assemblyState = AssemblyState.PAUSED;
            this.onMachinePaused();
        }
        BlockPos oldReference = this.referenceCoord;
        this.onDetachBlock(part);
        if (!this.connectedParts.remove(part)) {
            BlockPos partCoords = part.getCoordinates();
            Forestry.LOGGER.warn("[{}] Double-removing part ({}) @ {}, {}, {}, this is unexpected and may cause problems. If you encounter anomalies, please tear down the reactor and rebuild it.", (Object)(this.level.m_5776_() ? "CLIENT" : "SERVER"), (Object)part.hashCode(), (Object)partCoords.m_123341_(), (Object)partCoords.m_123342_(), (Object)partCoords.m_123343_());
        }
        if (this.connectedParts.isEmpty()) {
            MultiblockRegistry.addDeadController((LevelAccessor)this.level, this);
            this.destroyedCoord = oldReference;
            return;
        }
        MultiblockRegistry.addDirtyController((LevelAccessor)this.level, this);
        if (this.referenceCoord == null) {
            this.selectNewReferenceCoord();
        }
    }

    @Override
    public String getLastValidationError() {
        if (this.lastValidationException == null) {
            return null;
        }
        return this.lastValidationException.getMessage();
    }

    @Override
    public void reassemble() {
        MultiblockRegistry.addDirtyController((LevelAccessor)this.level, this);
    }

    protected abstract void isMachineWhole() throws MultiblockValidationException;

    @Override
    public void checkIfMachineIsWhole() {
        boolean isWhole;
        AssemblyState oldState = this.assemblyState;
        this.lastValidationException = null;
        try {
            this.isMachineWhole();
            isWhole = true;
        }
        catch (MultiblockValidationException e) {
            this.lastValidationException = e;
            isWhole = false;
        }
        if (isWhole) {
            this.assembleMachine(oldState);
        } else if (oldState == AssemblyState.ASSEMBLED) {
            this.disassembleMachine();
        }
    }

    private void assembleMachine(AssemblyState oldState) {
        this.assemblyState = AssemblyState.ASSEMBLED;
        for (IMultiblockComponent part : this.connectedParts) {
            part.onMachineAssembled(this, this.getMinimumCoord(), this.getMaximumCoord());
        }
        if (oldState == AssemblyState.PAUSED) {
            this.onMachineRestored();
        } else {
            this.onMachineAssembled();
        }
    }

    private void disassembleMachine() {
        this.assemblyState = AssemblyState.DISASSEMBLED;
        for (IMultiblockComponent part : this.connectedParts) {
            part.onMachineBroken();
        }
        this.onMachineDisassembled();
    }

    @Override
    public void assimilate(IMultiblockControllerInternal other) {
        BlockPos otherReferenceCoord = other.getReferenceCoord();
        BlockPos referenceCoord = this.getReferenceCoord();
        if (otherReferenceCoord != null && referenceCoord != null && referenceCoord.compareTo((Vec3i)otherReferenceCoord) >= 0) {
            throw new IllegalArgumentException("The controller with the lowest minimum-coord value must consume the one with the higher coords");
        }
        HashSet<IMultiblockComponent> partsToAcquire = new HashSet<IMultiblockComponent>(other.getComponents());
        other._onAssimilated(this);
        for (IMultiblockComponent acquiredPart : partsToAcquire) {
            if (MultiblockControllerBase.isInvalid(acquiredPart)) continue;
            this.connectedParts.add(acquiredPart);
            MultiblockLogic logic = (MultiblockLogic)acquiredPart.getMultiblockLogic();
            logic.setController(this);
            this.onBlockAdded(acquiredPart);
        }
        this.onAssimilate(other);
        other.onAssimilated(this);
    }

    @Override
    public void _onAssimilated(IMultiblockControllerInternal otherController) {
        if (this.referenceCoord != null) {
            if (this.level.m_7726_().m_5563_(this.referenceCoord.m_123341_() >> 4, this.referenceCoord.m_123343_() >> 4)) {
                TileUtil.actOnTile((LevelReader)this.level, this.referenceCoord, IMultiblockComponent.class, part -> {
                    MultiblockLogic logic = (MultiblockLogic)part.getMultiblockLogic();
                    logic.forfeitMultiblockSaveDelegate();
                });
            }
            this.referenceCoord = null;
        }
        this.connectedParts.clear();
    }

    protected abstract void onAssimilate(IMultiblockControllerInternal var1);

    @Override
    public final void updateMultiblockEntity() {
        ++this.tickCount;
        if (this.connectedParts.isEmpty()) {
            MultiblockRegistry.addDeadController((LevelAccessor)this.level, this);
            return;
        }
        if (this.assemblyState != AssemblyState.ASSEMBLED) {
            return;
        }
        if (this.level.f_46443_) {
            this.clientTick(this.tickCount);
        } else if (this.serverTick(this.tickCount) && this.minimumCoord != null && this.maximumCoord != null && this.level.m_46832_(this.minimumCoord, this.maximumCoord)) {
            int minChunkX = this.minimumCoord.m_123341_() >> 4;
            int minChunkZ = this.minimumCoord.m_123343_() >> 4;
            int maxChunkX = this.maximumCoord.m_123341_() >> 4;
            int maxChunkZ = this.maximumCoord.m_123343_() >> 4;
            for (int x = minChunkX; x <= maxChunkX; ++x) {
                for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                    LevelChunk chunkToSave = this.level.m_7726_().m_7131_(x, z);
                    if (chunkToSave == null) continue;
                    chunkToSave.m_8092_(true);
                }
            }
        }
    }

    protected abstract boolean serverTick(int var1);

    protected int getTickCount() {
        return this.tickCount;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected abstract void clientTick(int var1);

    protected final boolean updateOnInterval(int tickInterval) {
        return this.tickCount % tickInterval == 0;
    }

    protected void isBlockGoodForExteriorLevel(int level, Level world, BlockPos pos) throws MultiblockValidationException {
        Block block = world.m_8055_(pos).m_60734_();
        throw new MultiblockValidationException(Component.m_237110_((String)"for.multiblock.error.invalid.interior", (Object[])new Object[]{block}).getString(), pos);
    }

    protected void isBlockGoodForInterior(Level world, BlockPos pos) throws MultiblockValidationException {
        Block block = world.m_8055_(pos).m_60734_();
        throw new MultiblockValidationException(Component.m_237110_((String)"for.multiblock.error.invalid.interior", (Object[])new Object[]{block}).getString(), pos);
    }

    @Override
    @Nullable
    public BlockPos getReferenceCoord() {
        if (this.referenceCoord == null) {
            return this.selectNewReferenceCoord();
        }
        return this.referenceCoord;
    }

    public int getNumConnectedBlocks() {
        return this.connectedParts.size();
    }

    @Override
    public void recalculateMinMaxCoords() {
        this.minimumCoord = new BlockPos(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.maximumCoord = new BlockPos(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        for (IMultiblockComponent part : this.connectedParts) {
            BlockPos partCoords = part.getCoordinates();
            int minX = this.minimumCoord.m_123341_();
            int minY = this.minimumCoord.m_123342_();
            int minZ = this.minimumCoord.m_123343_();
            int maxX = this.maximumCoord.m_123341_();
            int maxY = this.maximumCoord.m_123342_();
            int maxZ = this.maximumCoord.m_123343_();
            if (partCoords.m_123341_() < this.minimumCoord.m_123341_()) {
                minX = partCoords.m_123341_();
            }
            if (partCoords.m_123341_() > this.maximumCoord.m_123341_()) {
                maxX = partCoords.m_123341_();
            }
            if (partCoords.m_123342_() < this.minimumCoord.m_123342_()) {
                minY = partCoords.m_123342_();
            }
            if (partCoords.m_123342_() > this.maximumCoord.m_123342_()) {
                maxY = partCoords.m_123342_();
            }
            if (partCoords.m_123343_() < this.minimumCoord.m_123343_()) {
                minZ = partCoords.m_123343_();
            }
            if (partCoords.m_123343_() > this.maximumCoord.m_123343_()) {
                maxZ = partCoords.m_123343_();
            }
            this.minimumCoord = new BlockPos(minX, minY, minZ);
            this.maximumCoord = new BlockPos(maxX, maxY, maxZ);
        }
    }

    protected BlockPos getMinimumCoord() {
        if (this.minimumCoord == null) {
            this.recalculateMinMaxCoords();
        }
        return new BlockPos((Vec3i)this.minimumCoord);
    }

    protected BlockPos getMaximumCoord() {
        if (this.maximumCoord == null) {
            this.recalculateMinMaxCoords();
        }
        return new BlockPos((Vec3i)this.maximumCoord);
    }

    protected final BlockPos getCenterCoord() {
        BlockPos minCoord = this.getMinimumCoord();
        BlockPos maxCoord = this.getMaximumCoord();
        return new BlockPos((minCoord.m_123341_() + maxCoord.m_123341_()) / 2, (minCoord.m_123342_() + maxCoord.m_123342_()) / 2, (minCoord.m_123343_() + maxCoord.m_123343_()) / 2);
    }

    protected final BlockPos getTopCenterCoord() {
        BlockPos minCoord = this.getMinimumCoord();
        BlockPos maxCoord = this.getMaximumCoord();
        return new BlockPos((minCoord.m_123341_() + maxCoord.m_123341_()) / 2, maxCoord.m_123342_(), (minCoord.m_123343_() + maxCoord.m_123343_()) / 2);
    }

    protected final boolean isCoordInMultiblock(int x, int y, int z) {
        if (this.minimumCoord == null || this.maximumCoord == null) {
            return false;
        }
        return x >= this.minimumCoord.m_123341_() && x <= this.maximumCoord.m_123341_() && y >= this.minimumCoord.m_123342_() && y <= this.maximumCoord.m_123342_() && z >= this.minimumCoord.m_123343_() && z <= this.maximumCoord.m_123343_();
    }

    @Override
    public boolean hasNoParts() {
        return this.connectedParts.isEmpty();
    }

    @Override
    public boolean shouldConsume(IMultiblockControllerInternal otherController) {
        if (!otherController.getClass().equals(this.getClass())) {
            throw new IllegalArgumentException("Attempting to merge two multiblocks with different master classes - this should never happen!");
        }
        if (otherController == this) {
            return false;
        }
        int res = this._shouldConsume(otherController);
        if (res < 0) {
            return true;
        }
        if (res > 0) {
            return false;
        }
        Forestry.LOGGER.warn("[{}] Encountered two controllers with the same reference coordinate. Auditing connected parts and retrying.", (Object)(this.level.f_46443_ ? "CLIENT" : "SERVER"));
        this.auditParts();
        otherController.auditParts();
        res = this._shouldConsume(otherController);
        if (res < 0) {
            return true;
        }
        if (res > 0) {
            return false;
        }
        Forestry.LOGGER.error("My Controller ({}): size ({}), parts: {}", (Object)this.hashCode(), (Object)this.connectedParts.size(), (Object)this.getPartsListString());
        Forestry.LOGGER.error("Other Controller ({}): size ({}), coords: {}", (Object)otherController.hashCode(), (Object)otherController.getComponents().size(), (Object)otherController.getPartsListString());
        throw new IllegalArgumentException("[" + (this.level.f_46443_ ? "CLIENT" : "SERVER") + "] Two controllers with the same reference coord that somehow both have valid parts - this should never happen!");
    }

    private int _shouldConsume(IMultiblockControllerInternal otherController) {
        BlockPos myCoord = this.getReferenceCoord();
        BlockPos theirCoord = otherController.getReferenceCoord();
        if (theirCoord == null || myCoord == null) {
            return -1;
        }
        return myCoord.compareTo((Vec3i)theirCoord);
    }

    @Override
    public String getPartsListString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (IMultiblockComponent part : this.connectedParts) {
            if (!first) {
                sb.append(", ");
            }
            BlockPos partCoord = part.getCoordinates();
            sb.append(String.format("(%d: %d, %d, %d)", part.hashCode(), partCoord.m_123341_(), partCoord.m_123342_(), partCoord.m_123343_()));
            first = false;
        }
        return sb.toString();
    }

    @Override
    public void auditParts() {
        HashSet<IMultiblockComponent> deadParts = new HashSet<IMultiblockComponent>();
        for (IMultiblockComponent part : this.connectedParts) {
            BlockPos partCoord = part.getCoordinates();
            if (!MultiblockControllerBase.isInvalid(part) && TileUtil.getTile((BlockGetter)this.level, partCoord) == part) continue;
            this.onDetachBlock(part);
            deadParts.add(part);
        }
        this.connectedParts.removeAll(deadParts);
        Forestry.LOGGER.warn("[{}] Controller found {} dead parts during an audit, {} parts remain attached", (Object)(this.level.f_46443_ ? "CLIENT" : "SERVER"), (Object)deadParts.size(), (Object)this.connectedParts.size());
    }

    @Override
    public Set<IMultiblockComponent> checkForDisconnections() {
        if (!this.shouldCheckForDisconnections) {
            return Collections.emptySet();
        }
        if (this.hasNoParts()) {
            MultiblockRegistry.addDeadController((LevelAccessor)this.level, this);
            return Collections.emptySet();
        }
        ChunkSource chunkProvider = this.level.m_7726_();
        this.referenceCoord = null;
        HashSet<IMultiblockComponent> deadParts = new HashSet<IMultiblockComponent>();
        IMultiblockComponent referencePart = null;
        int originalSize = this.connectedParts.size();
        for (IMultiblockComponent part : this.connectedParts) {
            BlockPos partCoord = part.getCoordinates();
            if (chunkProvider.m_7131_(partCoord.m_123341_() >> 4, partCoord.m_123343_() >> 4) == null || MultiblockControllerBase.isInvalid(part)) {
                deadParts.add(part);
                this.onDetachBlock(part);
                continue;
            }
            if (TileUtil.getTile((BlockGetter)this.level, partCoord) != part) {
                deadParts.add(part);
                this.onDetachBlock(part);
                continue;
            }
            MultiblockLogic logic = (MultiblockLogic)part.getMultiblockLogic();
            logic.setUnvisited();
            logic.forfeitMultiblockSaveDelegate();
            BlockPos c = part.getCoordinates();
            if (this.referenceCoord == null) {
                this.referenceCoord = c;
                referencePart = part;
                continue;
            }
            if (c.compareTo((Vec3i)this.referenceCoord) >= 0) continue;
            this.referenceCoord = c;
            referencePart = part;
        }
        this.connectedParts.removeAll(deadParts);
        deadParts.clear();
        if (referencePart == null || this.hasNoParts()) {
            this.shouldCheckForDisconnections = false;
            MultiblockRegistry.addDeadController((LevelAccessor)this.level, this);
            return Collections.emptySet();
        }
        MultiblockLogic logic = (MultiblockLogic)referencePart.getMultiblockLogic();
        logic.becomeMultiblockSaveDelegate();
        LinkedList<IMultiblockComponent> partsToCheck = new LinkedList<IMultiblockComponent>();
        partsToCheck.add(referencePart);
        while (!partsToCheck.isEmpty()) {
            IMultiblockComponent part = (IMultiblockComponent)partsToCheck.removeFirst();
            MultiblockLogic partLogic = (MultiblockLogic)part.getMultiblockLogic();
            partLogic.setVisited();
            List<IMultiblockComponent> nearbyParts = MultiblockUtil.getNeighboringParts(this.level, part);
            for (IMultiblockComponent nearbyPart : nearbyParts) {
                MultiblockLogic nearbyPartLogic = (MultiblockLogic)nearbyPart.getMultiblockLogic();
                if (nearbyPartLogic.getController() != this || nearbyPartLogic.isVisited()) continue;
                nearbyPartLogic.setVisited();
                partsToCheck.add(nearbyPart);
            }
        }
        HashSet<IMultiblockComponent> removedParts = new HashSet<IMultiblockComponent>();
        for (IMultiblockComponent orphanCandidate : this.connectedParts) {
            MultiblockLogic logic2 = (MultiblockLogic)orphanCandidate.getMultiblockLogic();
            if (logic2.isVisited()) continue;
            deadParts.add(orphanCandidate);
            this.onDetachBlock(orphanCandidate);
            removedParts.add(orphanCandidate);
        }
        this.connectedParts.removeAll(deadParts);
        deadParts.clear();
        if (this.referenceCoord == null) {
            this.selectNewReferenceCoord();
        }
        this.shouldCheckForDisconnections = false;
        return removedParts;
    }

    @Override
    public Set<IMultiblockComponent> detachAllBlocks() {
        ChunkSource chunkProvider = this.level.m_7726_();
        for (IMultiblockComponent part : this.connectedParts) {
            BlockPos partCoord = part.getCoordinates();
            if (chunkProvider.m_7131_(partCoord.m_123341_() >> 4, partCoord.m_123343_() >> 4) == null) continue;
            this.onDetachBlock(part);
        }
        HashSet<IMultiblockComponent> detachedParts = this.connectedParts;
        this.connectedParts = new HashSet();
        return detachedParts;
    }

    @Override
    public boolean isAssembled() {
        return this.assemblyState == AssemblyState.ASSEMBLED;
    }

    @Nullable
    private BlockPos selectNewReferenceCoord() {
        ChunkSource chunkProvider = this.level.m_7726_();
        IMultiblockComponent theChosenOne = null;
        this.referenceCoord = null;
        for (IMultiblockComponent part : this.connectedParts) {
            BlockPos partCoord = part.getCoordinates();
            if (MultiblockControllerBase.isInvalid(part) || chunkProvider.m_7131_(partCoord.m_123341_() >> 4, partCoord.m_123343_() >> 4) == null || this.referenceCoord != null && this.referenceCoord.compareTo((Vec3i)partCoord) <= 0) continue;
            this.referenceCoord = part.getCoordinates();
            theChosenOne = part;
        }
        if (theChosenOne != null) {
            MultiblockLogic logic = (MultiblockLogic)theChosenOne.getMultiblockLogic();
            logic.becomeMultiblockSaveDelegate();
        }
        return this.referenceCoord;
    }

    private static boolean isInvalid(IMultiblockComponent part) {
        return part instanceof BlockEntity && ((BlockEntity)part).m_58901_();
    }

    @Override
    @Nullable
    public BlockPos getDestroyedCoord() {
        return this.destroyedCoord;
    }

    protected static enum AssemblyState {
        DISASSEMBLED,
        ASSEMBLED,
        PAUSED;

    }
}

