/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.multiblock;

import forestry.Forestry;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.api.multiblock.IMultiblockLogic;
import forestry.core.multiblock.IMultiblockControllerInternal;
import forestry.core.multiblock.MultiblockRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;

public abstract class MultiblockLogic<T extends IMultiblockControllerInternal>
implements IMultiblockLogic {
    private final Class<T> controllerClass;
    private boolean visited;
    private boolean saveMultiblockData;
    @Nullable
    private CompoundTag cachedMultiblockData;
    @Nullable
    protected T controller;

    protected MultiblockLogic(Class<T> controllerClass) {
        this.controllerClass = controllerClass;
        this.controller = null;
        this.visited = false;
        this.saveMultiblockData = false;
        this.cachedMultiblockData = null;
    }

    public void setController(@Nullable IMultiblockControllerInternal controller) {
        if (controller == null) {
            this.controller = null;
        } else if (this.controllerClass.isAssignableFrom(controller.getClass())) {
            this.controller = (IMultiblockControllerInternal)this.controllerClass.cast(controller);
        }
    }

    public Class<T> getControllerClass() {
        return this.controllerClass;
    }

    public abstract T getController();

    public abstract T createNewController(Level var1);

    @Override
    public void validate(Level world, IMultiblockComponent part) {
        MultiblockRegistry.onPartAdded(world, part);
    }

    @Override
    public final void invalidate(Level world, IMultiblockComponent part) {
        this.detachSelf(world, part, false);
    }

    @Override
    public final void onChunkUnload(Level world, IMultiblockComponent part) {
        this.detachSelf(world, part, true);
    }

    protected void detachSelf(Level world, IMultiblockComponent part, boolean chunkUnloading) {
        if (this.controller != null) {
            this.controller.detachBlock(part, chunkUnloading);
            this.controller = null;
        }
        MultiblockRegistry.onPartRemovedFromWorld(world, part);
    }

    @Override
    public void readFromNBT(CompoundTag data) {
        if (data.m_128441_("multiblockData")) {
            this.cachedMultiblockData = data.m_128469_("multiblockData");
        }
    }

    @Override
    public CompoundTag write(CompoundTag data) {
        if (this.isMultiblockSaveDelegate() && this.controller != null) {
            CompoundTag multiblockData = new CompoundTag();
            this.controller.write(multiblockData);
            data.m_128365_("multiblockData", (Tag)multiblockData);
        }
        return data;
    }

    public final void assertDetached(IMultiblockComponent part) {
        if (this.controller != null) {
            BlockPos coords = part.getCoordinates();
            Forestry.LOGGER.info("[assert] Part @ ({}, {}, {}) should be detached already, but detected that it was not. This is not a fatal error, and will be repaired, but is unusual.", (Object)coords.m_123341_(), (Object)coords.m_123342_(), (Object)coords.m_123343_());
            this.controller = null;
        }
    }

    @Override
    public final boolean isConnected() {
        return this.controller != null;
    }

    public void becomeMultiblockSaveDelegate() {
        this.saveMultiblockData = true;
    }

    public void forfeitMultiblockSaveDelegate() {
        this.saveMultiblockData = false;
    }

    public final boolean isMultiblockSaveDelegate() {
        return this.saveMultiblockData;
    }

    public final void setUnvisited() {
        this.visited = false;
    }

    public final void setVisited() {
        this.visited = true;
    }

    public final boolean isVisited() {
        return this.visited;
    }

    public final boolean hasMultiblockSaveData() {
        return this.cachedMultiblockData != null;
    }

    @Nullable
    public final CompoundTag getMultiblockSaveData() {
        return this.cachedMultiblockData;
    }

    public final void onMultiblockDataAssimilated() {
        this.cachedMultiblockData = null;
    }

    @Override
    public void encodeDescriptionPacket(CompoundTag packetData) {
        if (this.isMultiblockSaveDelegate() && this.controller != null) {
            CompoundTag tag = new CompoundTag();
            this.controller.formatDescriptionPacket(tag);
            packetData.m_128365_("multiblockData", (Tag)tag);
        }
    }

    @Override
    public void decodeDescriptionPacket(CompoundTag packetData) {
        if (packetData.m_128441_("multiblockData")) {
            CompoundTag tag = packetData.m_128469_("multiblockData");
            if (this.controller != null) {
                this.controller.decodeDescriptionPacket(tag);
            } else {
                this.cachedMultiblockData = tag;
            }
        }
    }
}

